<?php
namespace ElementorPro\Modules\AssetsManager\AssetTypes\AdminMenuItems;

use Elementor\Core\Admin\Menu\Interfaces\Admin_Menu_Item;
use Elementor\Settings;
use ElementorPro\Modules\AssetsManager\AssetTypes\Fonts_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Custom_Fonts_Menu_Item implements Admin_Menu_Item {
	public function get_capability(): string {
		return Fonts_Manager::CAPABILITY;
	}

	public function get_label(): string {
		return esc_html__( 'Custom Fonts', 'elementor-pro' );
	}

	public function get_parent_slug(): string {
		return Settings::PAGE_ID;
	}

	public function get_position(): ?int {
		return null;
	}

	public function is_visible(): bool {
		return true;
	}
}
