<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\TagManager;

class RevertVariableResponse extends \Google\Site_Kit_Dependencies\Google\Model
{
    protected $variableType = \Google\Site_Kit_Dependencies\Google\Service\TagManager\Variable::class;
    protected $variableDataType = '';
    /**
     * Variable as it appears in the latest container version since the last
     * workspace synchronization operation. If no variable is present, that means
     * the variable was deleted in the latest container version.
     *
     * @param Variable $variable
     */
    public function setVariable(\Google\Site_Kit_Dependencies\Google\Service\TagManager\Variable $variable)
    {
        $this->variable = $variable;
    }
    /**
     * @return Variable
     */
    public function getVariable()
    {
        return $this->variable;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\TagManager\RevertVariableResponse::class, 'Google\\Site_Kit_Dependencies\\Google_Service_TagManager_RevertVariableResponse');
