import type { SVGProps } from 'react';

interface CustomIconProps extends SVGProps<SVGSVGElement> {
    size?: number;
    fill?: string;
    stroke?: string;
    strokeWidth?: number;
    viewBox?: string;
}

const userShield = ({
    size = 60,
    fill = 'none',
    stroke = 'none',
    strokeWidth = 1,
    viewBox = '0 0 36 41',
    ...props
}:CustomIconProps) => (
    <svg
        width={size}
        height={size}
        fill={fill}
        stroke={stroke}
        strokeWidth={strokeWidth}
        viewBox={viewBox}
        strokeLinecap="round"
        strokeLinejoin="round"
        xmlns="http://www.w3.org/2000/svg"
        {...props}
    >
        <path
            d="M16 0.799805C16.2667 0.799805 16.5083 0.816471 16.725 0.849805C16.9417 0.883138 17.1667 0.949805 17.4 1.0498L29.4 5.5498C30.1667 5.8498 30.7917 6.33314 31.275 6.9998C31.7583 7.66647 32 8.41647 32 9.2498V15.4998C32 16.0665 31.8083 16.5415 31.425 16.9248C31.0417 17.3081 30.5667 17.4998 30 17.4998C29.4333 17.4998 28.9583 17.3081 28.575 16.9248C28.1917 16.5415 28 16.0665 28 15.4998V9.2998L16 4.7998L4 9.2998V18.6998C4 20.3665 4.24167 22.0331 4.725 23.6998C5.20833 25.3665 5.875 26.9498 6.725 28.4498C7.575 29.9498 8.60833 31.2998 9.825 32.4998C11.0417 33.6998 12.3667 34.6831 13.8 35.4498C14.3 35.7165 14.6583 36.0998 14.875 36.5998C15.0917 37.0998 15.1 37.5998 14.9 38.0998C14.6667 38.6331 14.2917 38.9998 13.775 39.1998C13.2583 39.3998 12.75 39.3665 12.25 39.0998C8.48333 37.2331 5.5 34.4165 3.3 30.6498C1.1 26.8831 0 22.8998 0 18.6998V9.2498C0 8.41647 0.241667 7.66647 0.725 6.9998C1.20833 6.33314 1.83333 5.8498 2.6 5.5498L14.6 1.0498C14.8333 0.949805 15.0667 0.883138 15.3 0.849805C15.5333 0.816471 15.7667 0.799805 16 0.799805ZM26 40.4998C23.2333 40.4998 20.875 39.5248 18.925 37.5748C16.975 35.6248 16 33.2665 16 30.4998C16 27.7331 16.975 25.3748 18.925 23.4248C20.875 21.4748 23.2333 20.4998 26 20.4998C28.7667 20.4998 31.125 21.4748 33.075 23.4248C35.025 25.3748 36 27.7331 36 30.4998C36 33.2665 35.025 35.6248 33.075 37.5748C31.125 39.5248 28.7667 40.4998 26 40.4998ZM26 30.4998C26.8333 30.4998 27.5417 30.2081 28.125 29.6248C28.7083 29.0415 29 28.3331 29 27.4998C29 26.6665 28.7083 25.9581 28.125 25.3748C27.5417 24.7915 26.8333 24.4998 26 24.4998C25.1667 24.4998 24.4583 24.7915 23.875 25.3748C23.2917 25.9581 23 26.6665 23 27.4998C23 28.3331 23.2917 29.0415 23.875 29.6248C24.4583 30.2081 25.1667 30.4998 26 30.4998ZM26 36.4998C26.8333 36.4998 27.6167 36.3415 28.35 36.0248C29.0833 35.7081 29.7333 35.2498 30.3 34.6498C30.4667 34.4498 30.5333 34.2248 30.5 33.9748C30.4667 33.7248 30.3167 33.5331 30.05 33.3998C29.4167 33.0998 28.7583 32.8748 28.075 32.7248C27.3917 32.5748 26.7 32.4998 26 32.4998C25.3 32.4998 24.6083 32.5748 23.925 32.7248C23.2417 32.8748 22.5833 33.0998 21.95 33.3998C21.6833 33.5331 21.5333 33.7248 21.5 33.9748C21.4667 34.2248 21.5333 34.4498 21.7 34.6498C22.2667 35.2498 22.9167 35.7081 23.65 36.0248C24.3833 36.3415 25.1667 36.4998 26 36.4998Z"
        />
    </svg>
);

export default userShield;