<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdmin;

class GoogleAnalyticsAdminV1alphaProperty extends \Google\Site_Kit_Dependencies\Google\Model
{
    /**
     * @var string
     */
    public $account;
    /**
     * @var string
     */
    public $createTime;
    /**
     * @var string
     */
    public $currencyCode;
    /**
     * @var string
     */
    public $deleteTime;
    /**
     * @var string
     */
    public $displayName;
    /**
     * @var string
     */
    public $expireTime;
    /**
     * @var string
     */
    public $industryCategory;
    /**
     * @var string
     */
    public $name;
    /**
     * @var string
     */
    public $parent;
    /**
     * @var string
     */
    public $propertyType;
    /**
     * @var string
     */
    public $serviceLevel;
    /**
     * @var string
     */
    public $timeZone;
    /**
     * @var string
     */
    public $updateTime;
    /**
     * @param string
     */
    public function setAccount($account)
    {
        $this->account = $account;
    }
    /**
     * @return string
     */
    public function getAccount()
    {
        return $this->account;
    }
    /**
     * @param string
     */
    public function setCreateTime($createTime)
    {
        $this->createTime = $createTime;
    }
    /**
     * @return string
     */
    public function getCreateTime()
    {
        return $this->createTime;
    }
    /**
     * @param string
     */
    public function setCurrencyCode($currencyCode)
    {
        $this->currencyCode = $currencyCode;
    }
    /**
     * @return string
     */
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }
    /**
     * @param string
     */
    public function setDeleteTime($deleteTime)
    {
        $this->deleteTime = $deleteTime;
    }
    /**
     * @return string
     */
    public function getDeleteTime()
    {
        return $this->deleteTime;
    }
    /**
     * @param string
     */
    public function setDisplayName($displayName)
    {
        $this->displayName = $displayName;
    }
    /**
     * @return string
     */
    public function getDisplayName()
    {
        return $this->displayName;
    }
    /**
     * @param string
     */
    public function setExpireTime($expireTime)
    {
        $this->expireTime = $expireTime;
    }
    /**
     * @return string
     */
    public function getExpireTime()
    {
        return $this->expireTime;
    }
    /**
     * @param string
     */
    public function setIndustryCategory($industryCategory)
    {
        $this->industryCategory = $industryCategory;
    }
    /**
     * @return string
     */
    public function getIndustryCategory()
    {
        return $this->industryCategory;
    }
    /**
     * @param string
     */
    public function setName($name)
    {
        $this->name = $name;
    }
    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * @param string
     */
    public function setParent($parent)
    {
        $this->parent = $parent;
    }
    /**
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }
    /**
     * @param string
     */
    public function setPropertyType($propertyType)
    {
        $this->propertyType = $propertyType;
    }
    /**
     * @return string
     */
    public function getPropertyType()
    {
        return $this->propertyType;
    }
    /**
     * @param string
     */
    public function setServiceLevel($serviceLevel)
    {
        $this->serviceLevel = $serviceLevel;
    }
    /**
     * @return string
     */
    public function getServiceLevel()
    {
        return $this->serviceLevel;
    }
    /**
     * @param string
     */
    public function setTimeZone($timeZone)
    {
        $this->timeZone = $timeZone;
    }
    /**
     * @return string
     */
    public function getTimeZone()
    {
        return $this->timeZone;
    }
    /**
     * @param string
     */
    public function setUpdateTime($updateTime)
    {
        $this->updateTime = $updateTime;
    }
    /**
     * @return string
     */
    public function getUpdateTime()
    {
        return $this->updateTime;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\GoogleAnalyticsAdmin\GoogleAnalyticsAdminV1alphaProperty::class, 'Google\\Site_Kit_Dependencies\\Google_Service_GoogleAnalyticsAdmin_GoogleAnalyticsAdminV1alphaProperty');
