<?php 

namespace WPV_AE; 

use Elementor\Plugin;

class Shortcode{

    private static $_instance = null;

    public static function instance()
    {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    private function __construct(){

        add_shortcode('INSERT_ELEMENTOR', [$this, 'render_shortcode']);

        add_filter( 'widget_text', 'do_shortcode' );
    }

    public function render_shortcode($atts){
        
        // Enable support for WPML & Polylang
        $language_support = apply_filters('ae_multilingual_support', false);

        if(!class_exists('Elementor\Plugin')){
            return '';
        }
		
        if(!isset($atts['id']) || empty($atts['id'])){
            return '';
        }

        $post_id = $atts['id'];

		if($language_support){
            $post_id = apply_filters( 'wpml_object_id', $post_id, 'ae_global_templates' );
        }

		$post = get_posts(
			[
				'post_type' => get_post_type($post_id),
				'post__in' => [$post_id] 
			]
		);

		if(!$post){
			return '';
		}

        $response = Plugin::instance()->frontend->get_builder_content_for_display($post[0]->ID);
        return $response;
    }

}

Shortcode::instance();