<?php
namespace Aepro\Modules\PostBlocksAdv\Skins;

use Aepro\Aepro;
use Aepro\Frontend;
use Aepro\Modules\PostBlocksAdv\Classes\Query;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;
use Elementor\Icons_Manager;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Core\Files\CSS\Post as Post_CSS;
use Elementor\Plugin;
use Aepro\Classes\CacheManager;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Skin_Grid extends Skin_Base {
    //phpcs:ignore PSR2.Methods.MethodDeclaration.Underscore
	protected function _register_controls_actions() {
		parent::_register_controls_actions(); // TODO: Change the autogenerated stub
		add_action( 'elementor/element/ae-post-blocks-adv/section_layout/before_section_end', [ $this, 'get_grid_controls' ] );
		add_action( 'elementor/element/ae-post-blocks-adv/section_query/after_section_end', [ $this, 'register_controls' ] );
		add_action( 'elementor/element/ae-post-blocks-adv/layout_style/after_section_end', [ $this, 'register_style_controls' ] );
	}

	public function get_id() {
		return 'grid';
	}

	public function get_title() {
		return __( 'Grid', 'ae-pro' );
	}

	public function render() {
		$this->if_layout_is_blank();

		$settings = $this->parent->get_settings_for_display();
		if ( ! isset( $settings['layout'] ) || empty( $settings['layout'] ) || get_post_status( $settings['layout'] ) !== 'publish' ) {
			return false;
		}
		$this->generate_output( $settings );
	}

	public function generate_output( $settings = false, $with_wrapper = true ) {

		add_filter( 'elementor/element/is_dynamic_content', function ( $is_dynamic, $element, $element_data ) {
			$is_dynamic = true;
			return $is_dynamic;
		}, 10, 3 );

		$query = new Query( $settings );
		$posts = $query->get_posts();

		// Securing Current post of Parent Query
		$prev_post = get_post();

		//Multi Lingual templates
		$settings['layout'] = apply_filters( 'wpml_object_id', $settings['layout'], 'ae_global_templates', true );

		// Checked for No Post Message.

		$layout                = $settings['layout'];
		$grid_layout           = $this->get_instance_value( 'grid_layout' );
		$masonry               = $this->get_instance_value( 'masonry' );
		$item_reveal_animation = $this->get_instance_value( 'item_reveal_animation' );
		$enable_overlay        = $this->get_instance_value( 'enable_overlay' );
		$ias                   = '';
		$ias                   = $this->get_instance_value( 'show_infinite_scroll' );
		$ias_loader            = $this->get_instance_value( 'ias_loader' );
		$ias_load_with_button  = $this->get_instance_value( 'ias_load_with_button' );
		$ias_load_offest_page  = $this->get_instance_value( 'ias_load_offest_page' );
		if ( $this->get_instance_value( 'ias_history_disable' ) === 'yes' ) {
			$ias_history_disable = 'false';
		} else {
			$ias_history_disable = 'replace';
		}

		// Outer Wrapper Attributes
		$this->parent->add_render_attribute( 'outer-wrapper', 'class', 'ae-outer-wrapper' );
		$this->parent->add_render_attribute( 'outer-wrapper', 'data-source', $settings['source'] );
		$this->parent->add_render_attribute( 'outer-wrapper', 'data-pid', get_the_ID() );
		$this->parent->add_render_attribute( 'outer-wrapper', 'data-wid', $this->parent->get_id() );

		if ( in_array( $grid_layout, [ 'default', 'smart-grid', 'checker-board' ], true ) && $masonry !== 'yes' ) {
			$this->parent->add_render_attribute( 'outer-wrapper', 'class', 'ae-height-100' );
		}

		if ( Plugin::instance()->editor->is_edit_mode() || $settings['source'] === 'current_loop' || ( $this->get_instance_value( 'disable_ajax' ) === 'yes' && $settings['show_filters'] !== 'yes' ) ) {
			$this->parent->add_render_attribute( 'outer-wrapper', 'class', 'no-ajax' );
		}

		if ( $masonry === 'yes' ) {
			$this->parent->add_render_attribute( 'outer-wrapper', 'class', 'ae-masonry-yes' );
		}

		$disable_scroll_on_ajax_load = $this->get_instance_value( 'disable_scroll_on_ajax_load' );
		if ( $disable_scroll_on_ajax_load === '' ) {
			$this->parent->add_render_attribute( 'outer-wrapper', 'data-disable_scroll_on_ajax_load', 'no' );
			$this->parent->add_render_attribute( 'outer-wrapper', 'data-pagination_scroll_top_offset', $this->get_instance_value( 'pagination_scroll_top_offset' )['size'] );
		}

		if ( $ias === 'yes' ) {
			$this->parent->add_render_attribute( 'outer-wrapper', 'class', 'ae-ias-load-with-button-' . $ias_load_with_button );
			$this->parent->add_render_attribute( 'outer-wrapper', 'data-load-offset-page', $ias_load_offest_page );
			$this->parent->add_render_attribute( 'outer-wrapper', 'class', 'ae-ias-' . $ias );
			$this->parent->add_render_attribute( 'outer-wrapper', 'data-ias-history', $ias_history_disable );
		}

		if ( $item_reveal_animation === 'yes' && $enable_overlay === 'yes' ) {
			$this->parent->add_render_attribute( 'outer-wrapper', 'data-item-reveal-animation', 'yes' );
			$overlay_animation_speed['size'] = 1000;
			$this->parent->add_render_attribute( 'outer-wrapper', 'data-overlay-animation-speed', $overlay_animation_speed['size'] );
		}

		// Collection Attributes
		$this->parent->add_render_attribute( 'collection', 'class', 'ae-post-collection' );

		//WooCommerce Sales Badge
		if ( isset( $settings['sale_badge_switcher'] ) && $settings['sale_badge_switcher'] === 'yes' ) {
			$this->parent->add_render_attribute( 'outer-wrapper', 'class', 'sale-badge-' . $settings['sale_badge_switcher'] );
		}

		$sg_layout = [];
		if ( $this->get_instance_value( 'grid_layout' ) === 'smart-grid' ) {
			$sg_layouts         = $this->smart_grid_layouts();
			$selected_sg_layout = $this->get_instance_value( 'sg_layout' );
			$sg_layout          = $sg_layouts[ $selected_sg_layout ]['alternate_layouts'];
		}

		/* Ajax Overlay */
		if ( $this->get_instance_value( 'enable_overlay' ) ) { ?>
			<div class="ae-post-overlay">
				<div class="ae-post-overlay-wrapper">
					<div class="ae-post-overlay-icon">
						<?php Icons_Manager::render_icon( $this->get_instance_value( 'overlay_icon' ), [ 'aria-hidden' => 'true' ] ); ?>
					</div>
					<div class="ae-post-overlay-text">
						<?php echo $this->get_instance_value( 'overlay_text' ); ?>
					</div>
				</div>
			</div>
			<?php
		}

		/* Post HTML */
		/* With Wrapper */
		if ( $with_wrapper ) {
			/* Widget Title */
			if ( ( $posts->have_posts() ) || ! empty( $settings['no_posts_message'] ) ) {
				$this->parent->get_widget_title_html();
			}
			?>
			<div <?php echo $this->parent->get_render_attribute_string( 'outer-wrapper' ); ?> >
			<?php
		}

		/* Filters */
		$this->get_filters_html( $settings );

			// Checked for No Post Message.
		if ( ! $posts->have_posts() ) {
			echo $this->ae_no_post_message( $settings );
			if ( $with_wrapper ) {
				?>
				</div> <!-- end .ae-outer-wrapper -->
				<?php
			}
			return;
		}

		$seq = 0;
		global $post;
		$css_file = Post_CSS::create( $layout );

		$css_file->enqueue();

		global $wp_query;
		$old_queried_object = $wp_query->queried_object;

		?>

		<div <?php echo $this->parent->get_render_attribute_string( 'collection' ); ?> >
			<?php
			$wid = $this->parent->get_id();
			while ( $posts->have_posts() ) {

				$seq++;

				$posts->the_post();
				Frontend::$_ae_post_block = get_the_ID();
				$layout                   = $this->get_layout( $seq, $settings, $sg_layout );
				$post_to_queried_object = apply_filters( 'aepro/post_blocks_adv/post_to_queried_object', true );
				if($post_to_queried_object){
					$wp_query->queried_object = $post;
				}
				$this->render_item( $layout, $wid );
			}
			$wp_query->queried_object = $old_queried_object;
			Frontend::$_ae_post_block = 0;
			//phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
			$post = $prev_post;
			setup_postdata( $post );
			?>
		</div>
		<?php
		if ( $ias === 'yes' ) {
			$last_page_text = $this->get_instance_value( 'ias_last_page_text' );
			?>
			<div class="scroller-status">
				<div class="infinite-scroll-request loader-ellips">
					<?php if ( $ias_loader === 'default' ) { ?>
						<span class="loader-ellips__dot"></span>
						<span class="loader-ellips__dot"></span>
						<span class="loader-ellips__dot"></span>
						<span class="loader-ellips__dot"></span>
					<?php } else { ?>
						<span class="loader loader-<?php echo $ias_loader; ?>" >
							<?php //phpcs:ignore WordPress.WP.AlternativeFunctions.file_get_contents_file_get_contents ?>
							<?php echo file_get_contents( AE_PRO_PATH . '/includes/assets/lib/infinite-scroll/shapes/' . $ias_loader . '.svg' ); ?>
						</span>
						<?php
					}
					?>
				</div>
				<p class="infinite-scroll-last"><?php echo $last_page_text; ?></p>
				<p class="infinite-scroll-error">No more pages to load</p>
			</div>
			<?php if ( $ias_load_with_button === 'yes' ) { ?>
				<div class="load-more-wrapper"><button class="view-more-button" style="display:none;"> <?php echo $this->get_instance_value( 'ias_load_more_button_text' ); ?> </button ></div>
			<?php } ?>
			<?php
		}

		$this->pagination_markup( $settings, $posts );

		if ( $with_wrapper ) {
			?>
			</div> <!-- end .ae-outer-wrapper -->
			<?php
		}
	}

	public function register_controls( Widget_Base $widget ) {
		$this->parent = $widget;
		$this->infinite_scroll_controls();
		$this->pagination_controls();
		$this->loading_overlay();
	}

	public function register_style_controls() {
		$this->pagination_style_controls();
		$this->infinite_scroll_style_controls();
		$this->loading_overlay_style();
	}
	public function get_grid_controls( Widget_Base $widget ) {
		$this->parent = $widget;

		$this->add_control(
			'grid_layout',
			[
				'label'        => __( 'Grid Layout', 'ae-pro' ),
				'type'         => Controls_Manager::SELECT,
				'options'      => [
					'default'       => __( 'Default', 'ae-pro' ),
					'list'          => __( 'List', 'ae-pro' ),
					'smart-grid'    => __( 'Smart Grid', 'ae-pro' ),
					'checker-board' => __( 'Checker Board', 'ae-pro' ),
				],
				'default'      => 'default',
				'prefix_class' => 'ae-grid-',
				'render_type'  => 'template',
			]
		);

		$this->add_control(
			'layout_mode_alert',
			[
				'type'            => Controls_Manager::RAW_HTML,
				'content_classes' => 'ae_layout_mode_alert',
				//phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText
				'raw'             => __( Aepro::$_helper->get_widget_admin_note_html( 'Know more about Post Block Carousel', 'https://wpvibes.link/go/feature-post-block-carousel' ), 'ae-pro' ),
				'separator'       => 'none',
				'condition'       => [
					'layout_mode' => 'carousel',
				],
			]
		);

		$this->add_control(
			'sg_layout',
			[
				'label'        => __( 'Choose Grid Layout', 'ae-pro' ),
				'type'         => Controls_Manager::CHOOSE,
				'options'      => $this->smart_grid_layouts(),
				'label_block'  => true,
				'prefix_class' => 'ae-sg-',
				'render_type'  => 'template',
				'default'      => 'layout1',
				'toggle'       => false,
				'condition'    => [
					$this->get_control_id( 'grid_layout' ) => 'smart-grid',
				],
			]
		);

		$block_layouts[''] = 'Select Block Layout';
		$block_layouts     = $block_layouts + CacheManager::instance()->get_block_layouts();
		$this->add_control(
			'alt_layout',
			[
				'label'       => __( 'Secondary Block Layout', 'ae-pro' ),
				'type'        => Controls_Manager::SELECT,
				'options'     => $block_layouts,
				'description' => __( 'Know more about Block Layouts <a href="http://aedocs.webtechstreet.com/article/9-creating-block-layout-in-anywhere-elementor-pro" target="_blank">Click Here</a>', 'ae-pro' ),
				'condition'   => [
					$this->get_control_id( 'grid_layout' ) => [ 'smart-grid', 'checker-board' ],
				],
			]
		);

		$this->add_control(
			'masonry',
			[
				'label'        => __( 'Masonry', 'ae-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => '',
				'masonry_on'   => __( 'On', 'ae-pro' ),
				'masonry_off'  => __( 'Off', 'ae-pro' ),
				'return_value' => 'yes',
				'condition'    => [
					$this->get_control_id( 'grid_layout' ) => [ 'default', 'checker-board' ],
				],
			]
		);

		$this->add_control(
			'show_infinite_scroll',
			[
				'label'        => __( 'Infinite Scroll', 'ae-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => '',
				'label_on'     => __( 'Yes', 'ae-pro' ),
				'label_off'    => __( 'No', 'ae-pro' ),
				'return_value' => 'yes',
			]
		);

		$this->add_control(
			'show_pagination',
			[
				'label'        => __( 'Pagination', 'ae-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'yes',
				'label_on'     => __( 'Yes', 'ae-pro' ),
				'label_off'    => __( 'No', 'ae-pro' ),
				'return_value' => 'yes',
				'condition'    => [
					$this->get_control_id( 'grid_layout' ) => [ 'list', 'default', 'smart-grid', 'checker-board' ],
					$this->get_control_id( 'show_infinite_scroll' ) => '',
				],
			]
		);

		$this->add_control(
			'scroll_to_top_heading',
			[
				'label'     => __( 'Scroll To Top', 'ae-pro' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
				'conditions'          => [
					'relation' => 'or',
					'terms'    => [
						[
							'name'     => $this->get_control_id( 'show_pagination' ),
							'operator' => '==',
							'value'    => 'yes',
						],
						[
							'name'     => 'show_filters',
							'operator' => '==',
							'value'    => 'yes',
						],
					],
				],
			]
		);

		$this->add_control(
			'disable_scroll_on_ajax_load',
			[
				'label'        => __( 'Disable', 'ae-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => '',
				'label_on'     => __( 'Yes', 'ae-pro' ),
				'label_off'    => __( 'No', 'ae-pro' ),
				'return_value' => 'yes',
				'conditions'          => [
					'relation' => 'or',
					'terms'    => [
						[
							'name'     => $this->get_control_id( 'show_pagination' ),
							'operator' => '==',
							'value'    => 'yes',
						],
						[
							'name'     => 'show_filters',
							'operator' => '==',
							'value'    => 'yes',
						],
					],
				],
			]
		);

		$this->add_responsive_control(
			'pagination_scroll_top_offset',
			[
				'label'              => __( 'Top Offset', 'ae-pro' ),
				'type'               => Controls_Manager::SLIDER,
				'default'            => [
					'size' => 0,
				],
				'range'              => [
					'px' => [
						'min'  => 0,
						'max'  => 1000,
						'step' => 1,
					],
				],
				'frontend_available' => true,
				'conditions'          => [
					'relation' => 'and',
					'terms'    => [
						[
							'relation' => 'or',
							'terms'    => [
								[
									'name'     => $this->get_control_id( 'show_pagination' ),
									'operator' => '==',
									'value'    => 'yes',
								],
								[
									'name'     => 'show_filters',
									'operator' => '==',
									'value'    => 'yes',
								],
							],
						],
						[
							'relation' => 'or',
							'terms'    => [
								[
									'name'     => $this->get_control_id( 'disable_scroll_on_ajax_load' ),
									'operator' => '==',
									'value'    => '',
								],
							]
						]
					]
				]
			]
		);
		
		$this->add_control(
			'scroll_to_top_divider',
			[
				'type'  => Controls_Manager::DIVIDER,
				'style' => 'thick',
			]
		);

		$this->add_control(
			'enable_overlay',
			[
				'label'        => __( 'Loading Overlay', 'ae-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'yes',
				'label_on'     => __( 'Yes', 'ae-pro' ),
				'label_off'    => __( 'No', 'ae-pro' ),
				'return_value' => 'yes',
				'condition'    => [
					$this->get_control_id( 'grid_layout' ) => [ 'default', 'list', 'smart-grid', 'checker-board' ],
				],
			]
		);

		$this->add_responsive_control(
			'columns',
			[
				'label'           => __( 'Columns', 'ae-pro' ),
				'type'            => Controls_Manager::NUMBER,
				'desktop_default' => '3',
				'tablet_default'  => '2',
				'mobile_default'  => '1',
				'min'             => 1,
				'max'             => 12,
				'condition'       => [
					$this->get_control_id( 'grid_layout' ) => [ 'default', 'checker-board' ],
				],
				'selectors'       => [
					'{{WRAPPER}} .ae-post-collection' => 'grid-template-columns: repeat({{VALUE}}, minmax(0, 1fr)); display:grid',
					'{{WRAPPER}} .ae-masonry-yes .ae-post-collection' => 'display: block;',
					'{{WRAPPER}} .ae-masonry-yes .ae-post-collection .ae-post-item' => 'width: calc(100% / {{VALUE}});',
				],
				'frontend_available' => true,
			]
		);

		$this->add_responsive_control(
			'item_col_gap',
			[
				'label'     => __( 'Column Gap', 'ae-pro' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'default'   => [
					'unit' => 'px',
					'size' => 10,
				],
				'condition' => [
					$this->get_control_id( 'grid_layout' ) => [ 'default', 'checker-board' ],
				],
				'selectors' => [
					'{{WRAPPER}} .ae-post-collection' => 'column-gap: {{SIZE}}{{UNIT}}; grid-column-gap: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .ae-masonry-yes .ae-post-collection .ae-post-item' => 'padding-right: calc({{SIZE}}{{UNIT}}/2); padding-left: calc({{SIZE}}{{UNIT}}/2)',
					'{{WRAPPER}} .ae-masonry-yes .ae-post-collection' => 'margin-left: calc(-{{SIZE}}{{UNIT}}/2); margin-right: calc(-{{SIZE}}{{UNIT}}/2)',
				],
			]
		);

		$this->add_responsive_control(
			'item_row_gap',
			[
				'label'     => __( 'Row Gap', 'ae-pro' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'default'   => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' => [
					'{{WRAPPER}} .ae-post-collection' => 'row-gap: {{SIZE}}{{UNIT}}; grid-row-gap: {{SIZE}}{{UNIT}}',
					'{{WRAPPER}} .ae-masonry-yes .ae-post-collection .ae-post-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					$this->get_control_id( 'grid_layout' ) => [ 'list', 'default', 'checker-board' ],
				],
			]
		);

		$this->add_responsive_control(
			'sg_row_gap',
			[
				'label'     => __( 'Row Gap', 'ae-pro' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'default'   => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}}  .ae-post-collection' => 'grid-row-gap:{{SIZE}}{{UNIT}};',
				],
				'condition' => [
					$this->get_control_id( 'grid_layout' ) => [ 'smart-grid' ],
				],
			]
		);

		$this->add_responsive_control(
			'sg_col_gap',
			[
				'label'     => __( 'Col Gap', 'ae-pro' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'default'   => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}}  .ae-post-collection' => 'grid-column-gap:{{SIZE}}{{UNIT}};',
				],
				'condition' => [
					$this->get_control_id( 'grid_layout' ) => [ 'smart-grid' ],
				],
			]
		);

		$this->add_control(
			'tablet_cols',
			[
				'label'           => __( 'Tablet Cols', 'ae-pro' ),
				'type'            => Controls_Manager::NUMBER,
				'desktop_default' => '2',
				'min'             => 1,
				'max'             => 12,
				'condition'       => [
					$this->get_control_id( 'grid_layout' ) => 'smart-grid',
				],
				'selectors'       => [
					'(tablet){{WRAPPER}} .ae-post-collection' => 'grid-template-columns: repeat({{VALUE}}, minmax(0, 1fr))',
					'(tablet){{WRAPPER}} .ae-post-collection .ae-post-item' => 'grid-row:unset; grid-column:unset;',
				],
			]
		);

		$this->add_control(
			'mobile_cols',
			[
				'label'           => __( 'Mobile Cols', 'ae-pro' ),
				'type'            => Controls_Manager::NUMBER,
				'desktop_default' => '1',
				'min'             => 1,
				'max'             => 12,
				'condition'       => [
					$this->get_control_id( 'grid_layout' ) => 'smart-grid',
				],
				'selectors'       => [
					'(mobile){{WRAPPER}} .ae-post-collection' => 'grid-template-columns:repeat({{VALUE}}, minmax(0, 1fr))',
					'(mobile){{WRAPPER}} .ae-post-collection .ae-post-item' => 'grid-row:unset; grid-column:unset;',
				],
			]
		);
	}

	public function infinite_scroll_controls() {

		$this->start_controls_section(
			'infinite_scroll_controls',
			[
				'label'     => __( 'Infinite Scroll', 'ae-pro' ),
				'condition' => [
					$this->get_control_id( 'show_infinite_scroll' ) => 'yes',
				],
			]
		);

		$this->add_control(
			'ias_loader',
			[
				'label'   => __( 'Loader', 'ae-pro' ),
				'type'    => Controls_Manager::SELECT,
				'options' => [
					'default'  => __( 'Default', 'ae-pro' ),
					'eclipse'  => __( 'Eclipse', 'ae-pro' ),
					'infinity' => __( 'Infinity', 'ae-pro' ),
					'pulse'    => __( 'Pulse', 'ae-pro' ),
					'ripple'   => __( 'Ripple', 'ae-pro' ),
					'spin'     => __( 'Spin', 'ae-pro' ),
				],
				'default' => 'default',
			]
		);

		$this->add_control(
			'ias_last_page_text',
			[
				'label'       => __( 'Last Page Text', 'ae-pro' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Last Page Text', 'ae-pro' ),
				'default'     => __( 'End of content', 'ae-pro' ),
			]
		);

		$this->add_control(
			'ias_load_with_button',
			[
				'label'        => __( 'Load With Button', 'ae-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => '',
				'label_on'     => __( 'Yes', 'ae-pro' ),
				'label_off'    => __( 'No', 'ae-pro' ),
				'return_value' => 'yes',
			]
		);

		$this->add_control(
			'ias_load_more_button_text',
			[
				'label'       => __( 'Button Text', 'ae-pro' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => __( 'Button Text', 'ae-pro' ),
				'default'     => __( 'View More', 'ae-pro' ),
				'condition'   => [
					$this->get_control_id( 'ias_load_with_button' ) => 'yes',
				],
			]
		);

		$this->add_control(
			'ias_load_offest_page',
			[
				'label'       => __( 'Offset Page', 'ae-pro' ),
				'type'        => Controls_Manager::NUMBER,
				'min'         => 0,
				'max'         => 12,
				'placeholder' => __( 'Offset Page', 'ae-pro' ),
				'default'     => __( '2', 'ae-pro' ),
				'condition'   => [
					$this->get_control_id( 'ias_load_with_button' ) => 'yes',
				],
			]
		);

		$this->add_control(
			'ias_history_disable',
			[
				'label'        => __( 'Disable History', 'ae-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => '',
				'label_on'     => __( 'Yes', 'ae-pro' ),
				'label_off'    => __( 'No', 'ae-pro' ),
				'return_value' => 'yes',
			]
		);
		$this->end_controls_section();
	}

	public function pagination_controls() {

		$this->start_controls_section(
			'pagination_controls',
			[
				'label'     => __( 'Pagination', 'ae-pro' ),
				'condition' => [
					$this->get_control_id( 'show_pagination' ) => 'yes',
					$this->get_control_id( 'show_infinite_scroll' ) => '',
				],
			]
		);

		$this->add_control(
			'show_prev_next',
			[
				'label'        => __( 'Show Prev/Next', 'ae-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'yes',
				'label_on'     => __( 'Show', 'ae-pro' ),
				'label_off'    => __( 'Hide', 'ae-pro' ),
				'return_value' => 'yes',
			]
		);

		$this->add_control(
			'disable_ajax',
			[
				'label'        => __( 'Disable Ajax', 'ae-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => '',
				'label_on'     => __( 'Yes', 'ae-pro' ),
				'label_off'    => __( 'No', 'ae-pro' ),
				'return_value' => 'yes',
				'condition'    => [
					'source!'       => 'current_loop',
					'show_filters!' => 'yes',
				],
			]
		);

		$this->add_control(
			'prev_text',
			[
				'label'     => __( 'Previous Text', 'ae-pro' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => __( '&laquo; Previous', 'ae-pro' ),
				'condition' => [
					$this->get_control_id( 'show_prev_next' ) => 'yes',
				],
			]
		);

		$this->add_control(
			'next_text',
			[
				'label'     => __( 'Next Text', 'ae-pro' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => __( 'Next &raquo;', 'ae-pro' ),
				'condition' => [
					$this->get_control_id( 'show_prev_next' ) => 'yes',
				],
			]
		);

		$this->add_control(
			'pagination_page_limit',
			[
				'label'       => __( 'Page Limit', 'ae-pro' ),
				'default'     => '',
				'description' => __( 'Leave blank to show all pages', 'ae-pro' ),
			]
		);

		/* $this->add_control(
			'disable_scroll_on_ajax_load',
			[
				'label'        => __( 'Disable Scroll to Top on Load', 'ae-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => '',
				'label_on'     => __( 'Yes', 'ae-pro' ),
				'label_off'    => __( 'No', 'ae-pro' ),
				'return_value' => 'yes',
				'condition'    => [
					$this->get_control_id( 'disable_ajax' ) => '',
				],
			]
		);

		$this->add_responsive_control(
			'pagination_scroll_top_offset',
			[
				'label'              => __( 'Scroll To Top Offset', 'ae-pro' ),
				'type'               => Controls_Manager::SLIDER,
				'default'            => [
					'size' => 0,
				],
				'range'              => [
					'px' => [
						'min'  => 0,
						'max'  => 1000,
						'step' => 1,
					],
				],
				'frontend_available' => true,
				'condition'          => [
					$this->get_control_id( 'disable_scroll_on_ajax_load' ) => '',
					$this->get_control_id( 'disable_ajax' ) => '',
				],
			]
		); */

		$this->add_responsive_control(
			'pagination_align',
			[
				'label'     => __( 'Alignment', 'ae-pro' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left' => [
						'title' => __( 'Left', 'ae-pro' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'ae-pro' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'ae-pro' ),
						'icon'  => 'fa fa-align-right',
					],
				],
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .ae-pagination-wrapper' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}

	public function pagination_style_controls() {

		$this->start_controls_section(
			'pagination_style',
			[
				'label'     => __( 'Pagination', 'ae-pro' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					$this->get_control_id( 'show_pagination' ) => 'yes',
					$this->get_control_id( 'show_infinite_scroll' ) => '',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'pagination_typography',
				'label'    => __( 'Typography', 'ae-pro' ),
				'selector' => '{{WRAPPER}} .ae-pagination-wrapper *',
			]
		);

		$this->add_responsive_control(
			'item_gap',
			[
				'label'     => __( 'Item Gap', 'ae-pro' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .ae-pagination-wrapper *' => 'margin-left:{{SIZE}}{{UNIT}}; margin-right:{{SIZE}}{{UNIT}};',
				],

			]
		);

		$this->add_responsive_control(
			'pi_padding',
			[
				'label'      => __( 'Padding', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .ae-pagination-wrapper *' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->start_controls_tabs( 'tabs_pagination_styles' );

		$this->start_controls_tab(
			'tab_pagination_style_normal',
			[
				'label' => __( 'Normal', 'ae-pro' ),
			]
		);

		$this->add_control(
			'pi_color',
			[
				'label'     => __( 'Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ae-pagination-wrapper *' => 'color:{{VALUE}}',
				],
			]
		);

		$this->add_control(
			'pi_bg',
			[
				'label'     => __( 'Background', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ae-pagination-wrapper *' => 'background-color:{{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_pagination_style_hover',
			[
				'label' => __( 'hover', 'ae-pro' ),
			]
		);

		$this->add_control(
			'pi_hover_color',
			[
				'label'     => __( 'Hover/Active Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ae-pagination-wrapper .current' => 'color:{{VALUE}}',
					'{{WRAPPER}} .ae-pagination-wrapper span:hover' => 'color:{{VALUE}}',
					'{{WRAPPER}} .ae-pagination-wrapper a:hover' => 'color:{{VALUE}}',
				],
			]
		);

		$this->add_control(
			'pi_hover_bg',
			[
				'label'     => __( 'Hover/Active Background', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ae-pagination-wrapper .current' => 'background-color:{{VALUE}}',
					'{{WRAPPER}} .ae-pagination-wrapper span:hover' => 'background-color:{{VALUE}}',
					'{{WRAPPER}} .ae-pagination-wrapper a:hover' => 'background-color:{{VALUE}}',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'pi_border',
				'label'    => __( 'Border', 'ae-pro' ),
				'selector' => '{{WRAPPER}} .ae-pagination-wrapper *',
			]
		);

		$this->add_control(
			'pi_border_hover_color',
			[
				'label'     => __( 'Border Hover Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ae-pagination-wrapper *:hover' => 'border-color: {{VALUE}}',
				],
				'condition' => [
					$this->get_control_id( 'pi_border_border!' ) => '',
				],
			]
		);

		$this->add_control(
			'pi_border_radius',
			[
				'label'      => __( 'Border Radius', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .ae-pagination-wrapper *' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'pagination_box_shadow',
				'label'    => __( 'Box Shadow', 'ae-pro' ),
				'selector' => '{{WRAPPER}} .ae-pagination-wrapper *',
			]
		);

		$this->add_control(
			'pagination_margin',
			[
				'label'      => __( 'Margin', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .ae-pagination-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}

	public function infinite_scroll_style_controls() {

		$this->start_controls_section(
			'infinite_scroll_style',
			[
				'label'     => __( 'Infinite Scroll', 'ae-pro' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					$this->get_control_id( 'show_infinite_scroll' ) => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'loadmore_align',
			[
				'label'     => __( 'Align', 'ae-pro' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => [
					'left' => [
						'title' => __( 'Left', 'ae-pro' ),
						'icon'  => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'ae-pro' ),
						'icon'  => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'ae-pro' ),
						'icon'  => 'fa fa-align-right',
					],
				],
				'default'   => 'center',
				'selectors' => [
					'{{WRAPPER}} .load-more-wrapper'       => 'text-align: {{VALUE}};',
					'{{WRAPPER}} .infinite-scroll-last'    => 'text-align: {{VALUE}}',
					'{{WRAPPER}} .infinite-scroll-request' => 'text-align: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'ias_loader_color',
			[
				'label'     => __( 'Loader Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .loader-ellips__dot' => 'background-color:{{VALUE}}',
					'{{WRAPPER}} .loader.loader-eclipse svg path, {{WRAPPER}} .loader.loader-spin svg circle, {{WRAPPER}} .loader.loader-pulse svg rect' => 'fill:{{VALUE}}',
					'{{WRAPPER}} .loader.loader-ripple svg circle, {{WRAPPER}} .loader.loader-infinity svg path' => 'stroke:{{VALUE}}',
				],
			]
		);

		$this->add_control(
			'last_message_heading',
			[
				'label'     => __( 'Last Message', 'ae-pro' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'last_message_typography',
				'label'    => __( 'Typography', 'ae-pro' ),
				'global'   => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .infinite-scroll-last',
			]
		);

		$this->add_control(
			'last_message_bg',
			[
				'label'     => __( 'Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'global'    => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'selectors' => [
					'{{WRAPPER}} .infinite-scroll-last' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'load_more_heading',
			[
				'label'     => __( 'Load More', 'ae-pro' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'load_more_typography',
				'label'    => __( 'Typography', 'ae-pro' ),
				'global'   => [
					'default' => Global_Typography::TYPOGRAPHY_TEXT,
				],
				'selector' => '{{WRAPPER}} .view-more-button',
			]
		);

		$this->start_controls_tabs( 'tabs_read_more_styles' );

		$this->start_controls_tab(
			'tab_load_more_normal',
			[
				'label' => __( 'Normal', 'ae-pro' ),
			]
		);

		$this->add_control(
			'load_more_color',
			[
				'label'     => __( 'Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'global'    => [
					'default' => Global_Colors::COLOR_TEXT,
				],
				'selectors' => [
					'{{WRAPPER}} .view-more-button' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'load_more_bg',
			[
				'label'     => __( 'Background Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'global'    => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'selectors' => [
					'{{WRAPPER}} .view-more-button' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name'     => 'load_more_border',
				'label'    => __( 'Border', 'ae-pro' ),
				'default'  => '1px',
				'selector' => '{{WRAPPER}} .view-more-button',
			]
		);

		$this->add_control(
			'load_more_border_radius',
			[
				'label'      => __( 'Border Radius', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .view-more-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'load_more_text_padding',
			[
				'label'      => __( 'Padding', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .view-more-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'load_more_text_margin',
			[
				'label'      => __( 'Margin', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .view-more-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_load_more_hover',
			[
				'label' => __( 'Hover', 'ae-pro' ),
			]
		);

		$this->add_control(
			'load_more_color_hover',
			[
				'label'     => __( 'Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'global'    => [
					'default' => Global_Colors::COLOR_TEXT,
				],
				'selectors' => [
					'{{WRAPPER}} .view-more-button:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'load_more_bg_hover',
			[
				'label'     => __( 'Background Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'global'    => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'selectors' => [
					'{{WRAPPER}} .view-more-button:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'load_more_border_color_hover',
			[
				'label'     => __( 'Border Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'global'    => [
					'default' => Global_Colors::COLOR_TEXT,
				],
				'selectors' => [
					'{{WRAPPER}} .view-more-button:hover' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'load_more_border_radius_hover',
			[
				'label'      => __( 'Border Radius', 'ae-pro' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors'  => [
					'{{WRAPPER}} .view-more-button:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
	}

	public function loading_overlay() {

		$this->start_controls_section(
			'overlay_section',
			[
				'label'     => __( 'Overlay', 'ae-pro' ),
				'condition' => [
					$this->get_control_id( 'enable_overlay' ) => 'yes',
				],
			]
		);

		$this->add_control(
			'overlay_loading_text_icon',
			[
				'label' => __( 'Icon', 'ae-pro' ),
				'type'  => Controls_Manager::HEADING,
			]
		);

		$this->add_control(
			'overlay_loading_text_icon_divider',
			[
				'type'  => Controls_Manager::DIVIDER,
				'style' => 'thick',
			]
		);

		$this->add_control(
			'overlay_icon',
			[
				'label'            => __( 'Icon', 'ae-pro' ),
				'type'             => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default'          => [
					'value'   => 'fa fa-sync',
					'library' => 'fa-solid',
				],
			]
		);

		$this->add_control(
			'overlay_text',
			[
				'label'   => __( 'Text', 'ae-pro' ),
				'type'    => Controls_Manager::TEXT,
				'default' => 'Loading...',
			]
		);

		$this->add_control(
			'overlay_icon_animation',
			[
				'label'        => __( 'Animate', 'ae-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => '',
				'label_on'     => __( 'Yes', 'ae-pro' ),
				'label_off'    => __( 'No', 'ae-pro' ),
				'return_value' => 'yes',
				'prefix_class' => 'overlay-icon-animation-',
			]
		);

		$this->add_control(
			'overlay_loading_text_alignment',
			[
				'label' => __( 'Alignment', 'ae-pro' ),
				'type'  => Controls_Manager::HEADING,
			]
		);

		$this->add_control(
			'overlay_loading_text_alignment_divider',
			[
				'type'  => Controls_Manager::DIVIDER,
				'style' => 'thick',
			]
		);

		$this->add_responsive_control(
			'overlay_text_horizontal_position',
			[
				'label'                => __( 'Horizontal', 'ae-pro' ),
				'type'                 => Controls_Manager::CHOOSE,
				'options'              => [
					'left' => [
						'title' => __( 'Left', 'ae-pro' ),
						'icon'  => 'eicon-h-align-left',
					],
					'right' => [
						'title' => __( 'Right', 'ae-pro' ),
						'icon'  => 'eicon-h-align-right',
					],
					'center' => [
						'title' => __( 'Center', 'ae-pro' ),
						'icon'  => 'eicon-h-align-center',
					],
				],
				'selectors_dictionary' => [
					'left'   => 'left: 0;',
					'right'  => 'right: 0;',
					'center' => 'left: 50%; transform: translateX(-50%)',
				],
				'selectors'            => [
					'{{WRAPPER}}.overlay-h-pos-left .ae-post-overlay-wrapper' => '{{VALUE}}',
					'{{WRAPPER}}.overlay-h-pos-right .ae-post-overlay-wrapper' => '{{VALUE}}',
					'{{WRAPPER}}.overlay-h-pos-center .ae-post-overlay-wrapper' => '{{VALUE}}',
				],
				'default'              => 'center',
				'prefix_class'         => 'overlay-h-pos-',
			]
		);

		$this->add_responsive_control(
			'overlay_text_vertical_position',
			[
				'label'                => __( 'Vertical', 'ae-pro' ),
				'type'                 => Controls_Manager::CHOOSE,
				'options'              => [
					'top' => [
						'title' => __( 'Top', 'ae-pro' ),
						'icon'  => 'eicon-v-align-top',
					],
					'bottom' => [
						'title' => __( 'Bottom', 'ae-pro' ),
						'icon'  => 'eicon-v-align-bottom',
					],
					'middle' => [
						'title' => __( 'Middle', 'ae-pro' ),
						'icon'  => 'eicon-v-align-middle',
					],
				],
				'selectors_dictionary' => [
					'top'    => 'top 0;',
					'bottom' => 'bottom: 0;',
					'middle' => 'top: 50%; transform: translateY(-50%)',
				],
				'selectors'            => [
					'{{WRAPPER}}.overlay-v-pos-top .ae-post-overlay-wrapper' => '{{VALUE}}',
					'{{WRAPPER}}.overlay-v-pos-middle .ae-post-overlay-wrapper' => '{{VALUE}}',
					'{{WRAPPER}}.overlay-v-pos-bottom .ae-post-overlay-wrapper' => '{{VALUE}}',
				],
				'default'              => 'middle',
				'prefix_class'         => 'overlay-v-pos-',
			]
		);

		$this->add_responsive_control(
			'overlay_text_horizontal_offset',
			[
				'label'          => __( 'Horizontal Offset', 'ae-pro' ),
				'type'           => Controls_Manager::SLIDER,
				'size_units'     => [ '%', 'px' ],
				'default'        => [
					'unit' => '%',
				],
				'tablet_default' => [
					'unit' => '%',
				],
				'mobile_default' => [
					'unit' => '%',
				],
				'range'          =>
					[
						'min'  => 1,
						'max'  => 1000,
						'step' => 1,
					],
				'selectors'      => [
					'{{WRAPPER}}.overlay-h-pos-right .ae-post-overlay-wrapper' => 'right: {{SIZE}}{{UNIT}}; transform: translateX({{SIZE}}{{UNIT}});',
					'{{WRAPPER}}.overlay-h-pos-left .ae-post-overlay-wrapper' => 'left: {{SIZE}}{{UNIT}}; transform: translateX(-{{SIZE}}{{UNIT}});',
					'{{WRAPPER}}.overlay-h-pos-left.overlay-v-pos-middle .ae-post-overlay-wrapper' => 'left: {{SIZE}}{{UNIT}}; top: 50%; transform: translate(-{{SIZE}}{{UNIT}},-50%);',
					'{{WRAPPER}}.overlay-h-pos-right.overlay-v-pos-middle .ae-post-overlay-wrapper' => 'right: {{SIZE}}{{UNIT}}; top: 50%; transform: translate({{SIZE}}{{UNIT}},-50%);',

				],
			]
		);
		$this->add_responsive_control(
			'overlay_text_vertical_offset',
			[
				'label'          => __( 'Vertical Offset', 'ae-pro' ),
				'type'           => Controls_Manager::SLIDER,
				'size_units'     => [ '%', 'px' ],
				'default'        => [
					'unit' => '%',
				],
				'tablet_default' => [
					'unit' => '%',
				],
				'mobile_default' => [
					'unit' => '%',
				],
				'range'          =>
					[
						'min'  => 1,
						'max'  => 1000,
						'step' => 1,
					],
				'selectors'      => [
					'{{WRAPPER}}.overlay-h-pos-left.overlay-v-pos-top .ae-post-overlay-wrapper' => 'top: {{SIZE}}{{UNIT}}; transform: translate(-{{' . $this->get_control_id( 'overlay_text_horizontal_offset' ) . '.SIZE}}{{' . $this->get_control_id( 'overlay_text_horizontal_offset' ) . '.UNIT}}, -{{SIZE}}{{UNIT}});',
					'{{WRAPPER}}.overlay-h-pos-right.overlay-v-pos-top .ae-post-overlay-wrapper' => 'top: {{SIZE}}{{UNIT}}; transform: translate({{' . $this->get_control_id( 'overlay_text_horizontal_offset' ) . '.SIZE}}{{' . $this->get_control_id( 'overlay_text_horizontal_offset' ) . '.UNIT}}, -{{SIZE}}{{UNIT}});',
					'{{WRAPPER}}.overlay-h-pos-left.overlay-v-pos-bottom .ae-post-overlay-wrapper' => 'bottom: {{SIZE}}{{UNIT}}; transform: translate(-{{' . $this->get_control_id( 'overlay_text_horizontal_offset' ) . '.SIZE}}{{' . $this->get_control_id( 'overlay_text_horizontal_offset' ) . '.UNIT}},{{SIZE}}{{UNIT}});',
					'{{WRAPPER}}.overlay-h-pos-right.overlay-v-pos-bottom .ae-post-overlay-wrapper' => 'bottom: {{SIZE}}{{UNIT}}; transform: translate({{' . $this->get_control_id( 'overlay_text_horizontal_offset' ) . '.SIZE}}{{' . $this->get_control_id( 'overlay_text_horizontal_offset' ) . '.UNIT}},{{SIZE}}{{UNIT}});',
					'{{WRAPPER}}.overlay-h-pos-center.overlay-v-pos-middle .ae-post-overlay-wrapper' => 'left: 50%; top: 50%; transform: translate(-50%,-50%);',
					'{{WRAPPER}}.overlay-v-pos-bottom .ae-post-overlay-wrapper' => 'bottom: {{SIZE}}{{UNIT}}; transform: translateY({{SIZE}}{{UNIT}});',
					'{{WRAPPER}}.overlay-h-pos-center.overlay-v-pos-bottom .ae-post-overlay-wrapper' => 'bottom: {{SIZE}}{{UNIT}}; transform: translate(-50%, {{SIZE}}{{UNIT}});',
					'{{WRAPPER}}.overlay-h-pos-center.overlay-v-pos-top .ae-post-overlay-wrapper' => 'top: {{SIZE}}{{UNIT}}; transform: translate(-50%, -{{SIZE}}{{UNIT}});',
				],
			]
		);

		$this->add_control(
			'item_reveal_animation',
			[
				'label'        => __( 'Item Reveal Animation', 'ae-pro' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => '',
				'label_on'     => __( 'Yes', 'ae-pro' ),
				'label_off'    => __( 'No', 'ae-pro' ),
				'return_value' => 'yes',
			]
		);

		$this->add_control(
			'preview_overlay',
			[
				'label'                => __( 'Preview Overlay', 'ae-pro' ),
				'type'                 => Controls_Manager::SWITCHER,
				'default'              => '',
				'label_on'             => __( 'Yes', 'ae-pro' ),
				'label_off'            => __( 'No', 'ae-pro' ),
				'return_value'         => 'yes',
				'selectors_dictionary' => [
					'yes' => 'display: block',
				],
				'selectors'            => [
					'.elementor-editor-active {{WRAPPER}} .ae-post-overlay' => '{{VALUE}}',
				],
			]
		);

		$this->end_controls_section();
	}

	public function loading_overlay_style() {
		$this->start_controls_section(
			'overlay_style_section',
			[
				'label'     => __( 'Overlay', 'ae-pro' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					$this->get_control_id( 'enable_overlay' ) => 'yes',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name'           => 'overlay_color',
				'label'          => __( 'Overlay Color', 'ae-pro' ),
				'types'          => [ 'none', 'classic', 'gradient' ],
				'selector'       => '{{WRAPPER}} .ae-post-overlay',
				'exclude'        => [ 'image' ],
				'fields_options' => [
					'background' => [
						'default' => 'classic',
					],
					'color' => [
						'default' => 'rgba(0,0,0,0.5)',
					],
				],
			]
		);

		$this->add_control(
			'overlay_icon_color',
			[
				'label'     => __( 'Icon Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ae-post-overlay-icon i' => 'color:{{VAlUE}};',
					'{{WRAPPER}} .ae-post-overlay-icon svg' => 'fill:{{VAlUE}};',
				],
				'default'   => '#FFFFFF',
			]
		);

		$this->add_control(
			'overlay_icon_size',
			[
				'label'     => __( 'Icon Size', 'ae-pro' ),
				'type'      => Controls_Manager::SLIDER,
				'default'   =>
					[
						'size' => 50,
					],
				'range'     =>
					[
						'min'  => 10,
						'max'  => 100,
						'step' => 1,
					],
				'selectors' => [
					'{{WRAPPER}} .ae-post-overlay-icon i' => 'font-size:{{SIZE}}px;',
					'{{WRAPPER}} .ae-post-overlay-icon svg' => 'width : {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'overlay_text_color',
			[
				'label'     => __( 'Text Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ae-post-overlay-text' => 'color:{{VAlUE}};',
				],
				'default'   => '#FFFFFF',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'overlay_text_typography',
				'label'    => __( 'Typography', 'ae-pro' ),
				'selector' => '{{WRAPPER}} .ae-post-overlay-text',
			]
		);

		$this->end_controls_section();
	}

	public function smart_grid_layouts() {

		$smart_grid = [

			'layout1' => [
				'title'             => __( 'Layout 1', 'ae-pro' ),
				'icon'              => 'aep aep-sg-1',
				'count'             => 3,
				'alternate_layouts' => [ 1 ],
			],

			'layout2' => [
				'title'             => __( 'Layout 2', 'ae-pro' ),
				'icon'              => 'aep aep-sg-2',
				'alternate_layouts' => [ 2 ],
			],

			'layout3' => [
				'label'             => __( 'Layout 3', 'ae-pro' ),
				'icon'              => 'aep aep-sg-3',
				'alternate_layouts' => [ 1 ],
			],

			'layout4' => [
				'label'             => __( 'Layout 4', 'ae-pro' ),
				'icon'              => 'aep aep-sg-4',
				'alternate_layouts' => [ 1 ],
			],
		];

		return $smart_grid;
	}

	public function pagination_markup( $settings, $post_items ) {

		global $wp;
		$ias_pagination = '';
		if ( $settings[ $settings['_skin'] . '_show_infinite_scroll' ] === 'yes' ) {
			$ias_pagination = 'yes';
		}

		if ( $settings[ $settings['_skin'] . '_show_pagination' ] !== 'yes' && $ias_pagination === '' ) {
			return;
		}

		$page_limit            = $post_items->max_num_pages;
		$pagination_page_limit = $settings[ $settings['_skin'] . '_pagination_page_limit' ];

		if ( isset( $pagination_page_limit ) && $pagination_page_limit !== '' ) {
			$page_limit = min( $pagination_page_limit, $page_limit );
		}

		if( $ias_pagination === 'yes' ) {
			$page_limit = $post_items->max_num_pages; // Just to activate hidden pagination for InfiniteScroll.
		}

		if ( 2 > $page_limit ) {
			return;
		}

		$this->parent->add_render_attribute( 'pagination-wrapper', 'class', 'ae-pagination-wrapper' );

		?>
		<div <?php echo $this->parent->get_render_attribute_string( 'pagination-wrapper' ); ?>>
			<?php
			$current = 1;
			//phpcs:ignore WordPress.Security.NonceVerification.Missing
			if ( isset( $_POST['page_num'] ) ) {
				//phpcs:ignore WordPress.Security.NonceVerification.Missing
				$current = $_POST['page_num'];
				//phpcs:ignore WordPress.PHP.StrictComparisons.LooseComparison
			} elseif ( isset( $settings['enable_facetwp'] ) && $settings['enable_facetwp'] == 'yes' ) {
				// FacetWP Support
				//FWP exists
				if ( function_exists( 'FWP' ) ) {
					// get pagination query var
					//phpcs:ignore WordPress.Security.NonceVerification.Recommended
					if ( isset( $_GET[ FWP()->helper->get_setting( 'prefix' ) . 'paged' ] ) ) {
						//phpcs:ignore WordPress.Security.NonceVerification.Recommended
						$paged   = $_GET[ FWP()->helper->get_setting( 'prefix' ) . 'paged' ];
						$current = $paged;
					}
				}
			} elseif ( is_paged() ) {
				$current = ( get_query_var( 'page' ) ) ? get_query_var( 'page' ) : 1;
			}
			//phpcs:ignore WordPress.Security.NonceVerification.Missing
			if ( isset( $_POST['curr_url'] ) ) {
				//phpcs:ignore WordPress.PHP.DiscouragedPHPFunctions.obfuscation_base64_decode, WordPress.Security.NonceVerification.Missing
				$base_url = base64_decode( $_POST['curr_url'] );
			} else {
				$base_url = Aepro::$_helper->get_current_url_non_paged();
			}

			$paginate_args = [
				'base'    => $base_url . '%_%',
				'total'   => $page_limit,
				'current' => $current,
			];

			if ( $settings['source'] === 'current_loop' ) {
				unset( $paginate_args['base'] );
				$current = get_query_var( 'paged' );
				//phpcs:ignore WordPress.PHP.StrictComparisons.LooseComparison
				if ( $current == 0 ) {
					$paginate_args['current'] = 1;
				} else {
					$paginate_args['current'] = $current;
				}
			}

			if ( $this->get_instance_value( 'show_prev_next' ) === 'yes' || $this->get_instance_value( 'show_infinite_scroll' ) === 'yes' ) {
				$paginate_args['prev_next'] = true;
				$paginate_args['prev_text'] = $this->get_instance_value( 'prev_text' );
				$paginate_args['next_text'] = $this->get_instance_value( 'next_text' );
			} else {
				$paginate_args['prev_next'] = false;
			}

			$disable_ajax = $this->get_instance_value( 'disable_ajax' );
			if ( ( ! isset( $disable_ajax ) || $disable_ajax === 'yes' ) && $settings['show_filters'] !== 'yes' ) {

				unset( $paginate_args['base'] );
				$paginate_args['current'] = $this->get_current_page_num();
				echo paginate_links( $paginate_args );

			} else {

				echo Aepro::$_helper->paginate_links( $paginate_args );
			}

			?>
		</div>
		<?php
	}

	public function get_current_page_num() {
		$current = 1;
		//phpcs:ignore WordPress.Security.NonceVerification.Missing
		if ( isset( $_POST['page_num'] ) ) {
			//phpcs:ignore WordPress.Security.NonceVerification.Missing
			$current = $_POST['page_num'];
			return $current;
		}

		if ( is_front_page() && ! is_home() ) {
			$current = ( get_query_var( 'page' ) ) ? get_query_var( 'page' ) : 1;
		} else {
			$current = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;
		}

		return $current;
	}
}
