/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 17:
/***/ ((module) => {

"use strict";


// do not edit .js files directly - edit src/index.jst



module.exports = function equal(a, b) {
  if (a === b) return true;

  if (a && b && typeof a == 'object' && typeof b == 'object') {
    if (a.constructor !== b.constructor) return false;

    var length, i, keys;
    if (Array.isArray(a)) {
      length = a.length;
      if (length != b.length) return false;
      for (i = length; i-- !== 0;)
        if (!equal(a[i], b[i])) return false;
      return true;
    }



    if (a.constructor === RegExp) return a.source === b.source && a.flags === b.flags;
    if (a.valueOf !== Object.prototype.valueOf) return a.valueOf() === b.valueOf();
    if (a.toString !== Object.prototype.toString) return a.toString() === b.toString();

    keys = Object.keys(a);
    length = keys.length;
    if (length !== Object.keys(b).length) return false;

    for (i = length; i-- !== 0;)
      if (!Object.prototype.hasOwnProperty.call(b, keys[i])) return false;

    for (i = length; i-- !== 0;) {
      var key = keys[i];

      if (!equal(a[key], b[key])) return false;
    }

    return true;
  }

  // true if both NaN, false otherwise
  return a!==a && b!==b;
};


/***/ }),

/***/ 965:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(532);
/* harmony import */ var _dynamic_bg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(207);


(function($){
    const AcfFlexibleCarousel = ( $scope , $ ) => {
        // Carousel
        if($scope.find('.ae-swiper-outer-wrapper').hasClass('ae-carousel-yes')) {
            const wid = $scope.data('id');
            const outer_wrapper = $scope.find('.ae-swiper-outer-wrapper');
            const swiper_settings = outer_wrapper.data('swiper-settings');
            new _base__WEBPACK_IMPORTED_MODULE_0__/* .SwiperBase */ .Y( swiper_settings, wid, $scope );
        }

        if(elementorFrontend.isEditMode()){
            
            $scope.find('.elementor-section').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });

            $scope.find('.elementor-column').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });
        }   
    }
    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/ae-acf-flexible-content.carousel', AcfFlexibleCarousel);
    });
})( jQuery );

/***/ }),

/***/ 23:
/***/ (() => {

(function($){
    const AcfFlexibleGrid = ( $scope , $ ) => {
        const grid = $scope.find('.ae-acf-fc-collection');
        // Masonry Layout
        if($scope.find('.ae-acf-fc-outer-wrapper').hasClass('ae-acf-fc-masonry-yes')){
             const $grid_obj = grid.masonry({
                 horizontalOrder: true
             });
             $grid_obj.imagesLoaded().progress(function(){
                 $grid_obj.masonry('layout');
             });

         }
         if(elementorFrontend.isEditMode()){
            
            $scope.find('.elementor-section').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });

            $scope.find('.elementor-column').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });
        }
    }
    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/ae-acf-flexible-content.grid', AcfFlexibleGrid);
    });
})( jQuery );

/***/ }),

/***/ 818:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(532);


( function( $ ) {

    var ACFGalleryCarousel = function ( $scope , $ ) {
        const outer_wrapper =  $scope.find('.ae-swiper-outer-wrapper');
		const wid = $scope.data('id');
        const swiper_settings = outer_wrapper.data('swiper-settings');

        new _base__WEBPACK_IMPORTED_MODULE_0__/* .SwiperBase */ .Y( swiper_settings, wid, $scope);
    };

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/ae-acf-gallery.carousel', 	 ACFGalleryCarousel );
    });

})( jQuery );



/***/ }),

/***/ 652:
/***/ (() => {

(function($){
    const ACFGalleryGrid = ( $scope , $ ) => {
        var $wrapper = $scope.find('.ae-grid-wrapper');
        if($scope.find('.ae-grid-wrapper').hasClass('ae-masonry-yes')){
            var grid = $scope.find('.ae-grid');
            var $grid_obj = grid.masonry({
            });

            $grid_obj.imagesLoaded().progress(function(){
                $grid_obj.masonry('layout');
            });
        }
        if(!$wrapper.hasClass('ae-hover-direction-effect')) {
            $scope.find('.ae-grid-item').hover(function(){
                $(this).find('.ae-grid-overlay').addClass('animated');
            });
         }
        if($wrapper.hasClass('ae-hover-direction-effect')){
            const  overlay_speed = parseInt($wrapper.attr('data-overlay-speed'));
            $scope.find('.ae-grid-item').hover(function () {
                $(this).find('.ae-grid-overlay').addClass('aep-overlay');
            });
            
            $wrapper.find('.ae-grid-item' ).hoverdir({
                speed: overlay_speed,
                hoverElem : '.ae-grid-overlay'
            });
        };
    };

    $(window).on( 'elementor/frontend/init', function() {
       
        elementorFrontend.hooks.addAction('frontend/element_ready/ae-acf-gallery.grid', ACFGalleryGrid);
    });
})(jQuery);



/***/ }),

/***/ 955:
/***/ (() => {

(function($){
    const ACFGalleryJustified = ( $scope , $ ) => {
        var $wrapper = $scope.find('.ae-jg-wrapper');
        if(!$wrapper.hasClass('justified-gallery')){
            return;
        }
        if($scope.find('.justified-gallery')){
            const grid_wrap = $scope.find('.justified-gallery');
            const jg_settings = grid_wrap.data('jg-settings');
            const rowHeight = (jg_settings.row_height.size === '') ? 200 :jg_settings.row_height.size;
            const gap = (jg_settings.gap.size === '') ? 10 :jg_settings.gap.size;
            const max_row = (jg_settings.max_row === '') ? 0 :jg_settings.max_row;
            const last_row = jg_settings.last_row;
            
            $(grid_wrap).justifiedGallery({
                rowHeight: rowHeight, 
                margins: gap,
                lastRow: last_row,
                maxRowsCount : max_row,
                cssAnimation: true,
                captions : false,
            });
            if(!$wrapper.hasClass('ae-hover-direction-effect')) {
                $scope.find('.ae-jg-item-inner').hover(function(){
                    $(this).find('.ae-grid-overlay').addClass('animated');
                });
             }
             if($wrapper.hasClass('ae-hover-direction-effect')){
                const  overlay_speed = parseInt($wrapper.attr('data-overlay-speed'));
                $scope.find('.ae-jg-item-inner').hover(function () {
                    $(this).find('.ae-grid-overlay').addClass('aep-overlay');
                });
                
                $wrapper.find('.ae-jg-item-inner').hoverdir({
                        speed: overlay_speed,
                        hoverElem : '.ae-grid-overlay'
                });
                
            };
        }
    }; 

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/ae-acf-gallery.justified', ACFGalleryJustified);
    });
})(jQuery);

/***/ }),

/***/ 852:
/***/ (() => {

(function($){
    const ACFGallerySmartGrid = ( $scope , $ ) => {
        var $wrapper = $scope.find('.ae-acf-gallery-layout-smart-grid');
        if ($scope.find('.ae-acf-gallery-layout-smart-grid')) {
            let grid_wrapper = $scope.find('.ae-grid-wrapper');
            let ae_grid = grid_wrapper.find('.ae-grid');
            let ae_grid_smart = grid_wrapper.find('.ae-grid-smart');
            if (($('body').data('elementor-device-mode') == 'tablet' || $('body').hasClass('elementor-device-tablet'))
                || ($('body').data('elementor-device-mode') == 'mobile' || $('body').hasClass('elementor-device-mobile'))) {
                $(ae_grid_smart).prepend(ae_grid.html());
                ae_grid.hide();
            }
        }

        if(!$wrapper.hasClass('ae-hover-direction-effect')) {
            $scope.find('.ae-grid-item').hover(function(){
                $(this).find('.ae-grid-overlay').addClass('animated');
            });
         }
        if($wrapper.hasClass('ae-hover-direction-effect')){
            const  overlay_speed = parseInt($wrapper.attr('data-overlay-speed'));
            $scope.find('.ae-grid-item-inner').hover(function () {
                $(this).find('.ae-grid-overlay').addClass('aep-overlay');
            });
            
            $wrapper.find('.ae-grid-item-inner' ).hoverdir({
                    speed: overlay_speed,
                    hoverElem : '.ae-grid-overlay'
            });
           
        };
    };


    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/ae-acf-gallery.smart_grid', ACFGallerySmartGrid);
    });
})(jQuery);



/***/ }),

/***/ 150:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony import */ var _dynamic_bg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(207);

(function ($) {

    const ACFRepeaterAccordionHandler = ($scope, $) => {
        const tid = $scope.find('.ae-accordion').data('tab-id');
        const title = $scope.find('[data-tab-id="' + tid + '"] > .ae-accordion-item > .elementor-tab-title.ae-tab-title');
        const speed = $scope.find('.ae-accordion[data-tab-id="' + tid + '"]').data('transition-speed');
        const expand_button = $scope.find('[data-tab-id="' + tid + '"] .ae-accordion-toggle-button.expand');
        const collapse_button = $scope.find('[data-tab-id="' + tid + '"] .ae-accordion-toggle-button.collapse');
        let acc_status = 'start';
        (title).on('click', function (e) {
            e.preventDefault();
            collapse_button.removeClass('active');
            expand_button.removeClass('active');
            acc_status = 'start';
            const $this = $(this);
            if ($this.hasClass("ae-active")) {
                $this.removeClass("ae-active");
                $this.next().slideUp(speed);
            } else {
                $this
                    .parent()
                    .parent()
                    .find(".elementor-tab-title.ae-tab-title")
                    .removeClass("ae-active");
                $this
                    .parent()
                    .parent()
                    .find(".ae-tab-content.ae-acf-repeater-accordion")
                    .slideUp(speed);
                $this.toggleClass("ae-active");
                //$this.next().css({ opacity: '0' });
                $this.next().slideDown(speed, 'linear', function () {
                    $this.next().css({ opacity: '1'});
                    /* $this.next().find('.elementor-section').each(function () {
                        elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
                    });

                    $this.next().find('.elementor-column').each(function(){
                        elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
                    });
                    
                    $this.next().find('.elementor-widget').each(function(){
                        elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
                    }); */
                });
            }
            if ('undefined' !== typeof $this.data('hashtag')) {
                window.location.hash = $this.data('hashtag');
            }

            // setTimeout(function () {
                /* Initialise ACF Gallery on Ajax */
               /*  $this.siblings('.ae-tab-content').find('.elementor-widget-ae-acf-gallery').each(function () {
                    elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
                });
                 
                $this.siblings('.ae-tab-content').find('[data-widget_type="ae-post-blocks-adv.carousel"]').each(function () {
                    elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
                }); */
                 
                
             //}, 50);
        });
        (expand_button).on('click',function(e){
            e.preventDefault();
            const $this = $(this);
            var role = $(this).data('role');
            if(acc_status == role){
                return;
            }else{
                acc_status = role;
                collapse_button.removeClass('active');
                $this.toggleClass('active');
                title.each(function(index,element){
                    $(element).addClass('ae-active');
                    var content = $(element).next();
                    content.slideDown(speed);
                    content.addClass('ae-active');
                });
            }
        });
        (collapse_button).on('click',function(e){
            e.preventDefault();
            const $this = $(this);
            var role = $(this).data('role');
            if(acc_status == role){
                return;
            } else {
                acc_status = role;
                expand_button.removeClass('active');
                $this.toggleClass('active');
                title.each(function (index, element) {
                    $(element).removeClass('ae-active'); 
                    var content = $(element).next();
                    content.slideUp(speed);
                    //content.removeClass('ae-active');
                });
            }
        });

        let $hashtag = window.location.hash.substring(1);
        if ($hashtag) {
            let $tab = title.filter('[data-hashtag="' + $hashtag + '"]');
            if ($tab.length > 0) {
                if (!$tab.hasClass('ae-active')) {
                    jQuery($tab).trigger('click');
                }
                let $tab_offset = parseInt(jQuery($tab).offset().top);
                jQuery('html, body').animate({
                    scrollTop: $tab_offset - 100
                }, 1000);
            }
		}
		
		//Refresh Dynamic BG in Edit Mode
		if (elementorFrontend.isEditMode()) {
            const sections = $scope.find('.elementor-section');
            $.each(sections, function (key, $section) {
                (0,_dynamic_bg__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A)($($section), $);
            });

            const columns = $scope.find('.elementor-column');
            $.each(columns, function (key, $column) {
                (0,_dynamic_bg__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A)($($column), $);
            });
        }
    };

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/ae-acf-repeater.accordion',  ACFRepeaterAccordionHandler );
    });

})(jQuery);

/***/ }),

/***/ 453:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(532);
/* harmony import */ var _dynamic_bg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(207);


(function ($) {
	$(window).on('elementor/frontend/init', function () {
		var ModuleHandler = elementorModules.frontend.handlers.Base,
			ACFRepeaterDefaultHandler;
		ACFRepeaterDefaultHandler = ModuleHandler.extend({
			getDefaultSettings: function getDefaultSettings() {
				return {
					selectors: {
						container: '.ae-acf-repeater-wrapper',
						item: '.ae-acf-repeater-item:not(.ae-hide)',
						grid_gap: '.grid-gap',
						swiper_wrapper: '.ae-swiper-outer-wrapper',
					},
					settings: this.getElementSettings(),
				};
			},
			getDefaultElements: function getDefaultElements() {
				const selectors = this.getSettings('selectors');
				return {
					container: this.$element.find(selectors.container),
					items: this.$element.find(selectors.item),
					grid_gap: this.$element.find(selectors.grid_gap),
					swiper_wrapper: this.$element.find(selectors.swiper_wrapper),
				};
			},
			onInit: function onInit() {
				const { container } = this.getDefaultElements();
				const that = this;
				container.imagesLoaded().done(function () {
					that.runMasonry();
				});

				window.addEventListener('resize', this.runMasonry.bind(this));

				this.runPager();
				this.runSwiper();
				this.runLoadMore();

				//Refresh Dynamic BG in Edit Mode
				if (elementorFrontend.isEditMode()) {
					const sections = this.$element.find('.elementor-section');
					$.each(sections, function (key, $section) {
						(0,_dynamic_bg__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A)($($section), $);
					});

					const columns = this.$element.find('.elementor-column');
					$.each(columns, function (key, $column) {
						(0,_dynamic_bg__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .A)($($column), $);
					});
				}
			},
			onElementChange: function onElementChange(propertyName) {
				if (propertyName === 'item_row_gap') {
					this.runMasonry();
				}
			},
			runLoadMore: function runLoadMore() {
				const { settings } = this.getSettings();
				if (settings.grid_pagination != 'yes') return;
				const $scope = this.$element;
				const { container } = this.getDefaultElements();
				let load_more_wrapper = $scope.find('.ae-load-more-wrapper');
				const number_of_pages = load_more_wrapper.data('page-count');
				const load_more_button = load_more_wrapper.find('.ae-load-more-button');
				const no_load_more_text = load_more_wrapper.find('.ae-no-load-more-text');
				const load_more_loader = load_more_wrapper.find('.ae-load-more-loader');
				let page_num = load_more_wrapper.data('current-page');
				let masonry = this;
				load_more_button.on('click', function (e) {
					e.preventDefault();
					load_more_loader.removeClass('ae-hide');
					if (page_num < number_of_pages) {
						page_num = page_num + 1;
					}
					load_more_wrapper.attr('data-current-page', page_num);
					let page = 'page-' + page_num;
					let repeater_item = container.find('.ae-acf-repeater-item');
					setTimeout(function () {
						load_more_loader.addClass('ae-hide');
						$(repeater_item).each(function () {
							if ($(this).hasClass(page)) {
								$(this).removeClass('ae-hide');
							}
						});
						if (page_num == number_of_pages) {
							load_more_button.addClass('ae-hide');
							no_load_more_text.removeClass('ae-hide');
						}
						
						masonry.runMasonry();
					}, 1000);
				});
			},
			runPager: function runPager() {
				const { settings } = this.getSettings();
				if (settings.grid_pagination != 'yes') return;
				const $scope = this.$element;
				const { container } = this.getDefaultElements();
				let pagination_wrapper = $scope.find('.ae-pagination-wrapper');
				const number_of_pages = pagination_wrapper.data('page-count');
				let page_numbers = pagination_wrapper.find('.page-numbers');
				let page_num = pagination_wrapper.data('current-page');
				let masonry = this;
				$(page_numbers).each(function () {
					$(this).on('click', function (e) {
						e.preventDefault();
						if ($(this).hasClass('current')) {
							return false;
						}
						page_num = pagination_wrapper.data('current-page');
						if ($(this).hasClass('prev')) {
							if (page_num > 1) {
								page_num = page_num - 1;
							}
						} else if ($(this).hasClass('next')) {
							if (page_num < number_of_pages) {
								page_num = page_num + 1;
							}
						} else {
							page_num = $(this).data('page');
						}
						
						pagination_wrapper.find('.page-numbers').removeClass('current');
						pagination_wrapper.find('.page-numbers').removeAttr('disabled');
						pagination_wrapper.find('.page-numbers.page[data-page="' + (page_num) + '"]').addClass('current').attr('disabled', 'disabled');
						pagination_wrapper.data('current-page', page_num);

						if (page_num == 1) {
							pagination_wrapper.find('.prev').addClass('current');
							pagination_wrapper.find('.prev').attr('disabled', 'disabled');
						} else if (page_num == number_of_pages) {
							pagination_wrapper.find('.next').addClass('current');
							pagination_wrapper.find('.next').attr('disabled', 'disabled');
						}
						
						let page = 'page-' + page_num;

						let repeater_item = container.find('.ae-acf-repeater-item');
						$(repeater_item).each(function () {
							if (!$(this).hasClass('ae-hide')) {
								$(this).addClass('ae-hide');
							}
							if ($(this).hasClass(page)) {
								$(this).removeClass('ae-hide');
							}
						});

						if (settings['pagination_scroll_top_offset']) {
							pagination_scroll_top_offset = settings['pagination_scroll_top_offset']['size'];
							if (document.body.dataset.elementorDeviceMode != 'desktop') {
								pagination_scroll_top_offset = settings['pagination_scroll_top_offset_' + document.body.dataset.elementorDeviceMode]['size'];
							}
							var pagination_scroll_top_offset = pagination_scroll_top_offset
							jQuery('html,body').animate({
								scrollTop: container.offset().top - pagination_scroll_top_offset
							},
								'slow');
						}

						masonry.runMasonry();
					});
				});
			},
			runMasonry: function runMasonry() {
				const { settings } = this.getSettings();

				const { container, items, grid_gap } = this.getDefaultElements();
				if (settings.masonry_grid != 'yes') return;
				var heights = [],
				distanceFromTop = 0,
				columnsCount = 3,
				verticalSpaceBetween = 10;

				distanceFromTop = container.position().top;
				columnsCount = container.css('grid-template-columns').split(' ').length;
				verticalSpaceBetween = grid_gap.width();
				distanceFromTop += parseInt(container.css('margin-top'), 10);
				
				items.each(function (index) {
					var row = Math.floor(index / columnsCount),
						$item = jQuery(this),
						itemHeight = $item[0].getBoundingClientRect().height + verticalSpaceBetween;
					if (row) {
						
						var itemPosition = $item.position(),
							indexAtRow = index % columnsCount,
							pullHeight = itemPosition.top - distanceFromTop - heights[indexAtRow];
						
						//pullHeight -= parseInt($item.css('margin-top'), 10);
						
						pullHeight *= -1;
						$item.css('margin-top', pullHeight + 'px');
						heights[indexAtRow] += itemHeight;
					} else {
						heights.push(itemHeight);
						$item.css('margin-top', 0);
					}
					$item.css('visibility', 'visible');
					
				});
				
			},
			runSwiper: function runSwiper() {
				const $scope = this.$element;
				const { settings } = this.getSettings();
				if (settings.layout_mode != 'carousel') return;

				const widget_id = this.$element.data('id');
				const { swiper_wrapper } = this.getDefaultElements();
				const swiper_settings = swiper_wrapper.data('swiper-settings');
				new _base__WEBPACK_IMPORTED_MODULE_0__/* .SwiperBase */ .Y(swiper_settings, widget_id, $scope);

			},
		});
		elementorFrontend.hooks.addAction('frontend/element_ready/ae-acf-repeater.default', function ($scope) {
			elementorFrontend.elementsHandler.addHandler(ACFRepeaterDefaultHandler, {
				$element: $scope
			  });
		});
	});
})(jQuery);

/***/ }),

/***/ 567:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony import */ var _dynamic_bg__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(207);

(function ($) {

    const ACFRepeaterTabsHandler = ( $scope, $ ) => {
        tabsLoad($scope, $);
        $(window).on('resize', function () {
           tabsLoad($scope, $);
        });
    };

    const tabsLoad = ($scope, $) => {
        const tid = $scope.find('.ae-acf-repeater-tabs').data('tab-id');
        var defaultActiveTab = $scope.find('.ae-acf-repeater-tabs').data('active-tab'),
            $tabsTitles,
            $tabs,
            $active,
            $content,
            $counter = 0;

        
        if (document.body.dataset.elementorDeviceMode == 'mobile') {
            $tabsTitles = $scope.find('[data-tab-id="' + tid + '"] > .ae-acf-repeater-tabs-content-wrapper > .ae-acf-repeater-tab-mobile-title');    
        } else {
            $tabsTitles = $scope.find('[data-tab-id="' + tid + '"] > .ae-acf-repeater-tabs-wrapper > .ae-acf-repeater-tab-desktop-title');
        }
        
        $tabs = $scope.find('[data-tab-id="' + tid + '"] > .ae-acf-repeater-tabs-content-wrapper > .ae-acf-repeater-tab-content');

        $counter = 1;

        const activateTab = (tabIndex) => {
            if ( $active ) {
                $active.removeClass( 'active' );
                $content.hide();
            }

            $active = $tabsTitles.filter( '[data-tab="' + tabIndex + '"]' );
            $active.addClass( 'active' );

            $content = $tabs.filter( '[data-tab="' + tabIndex + '"]' );
            $content.show();

           

            
            if ('undefined' !== typeof $active.data('hashtag')) {
                window.location.hash = $active.data('hashtag');
            }
        };

        
        $tabsTitles.on( 'click', function() { 
            activateTab( this.dataset.tab );

        });

        let $hashtag = window.location.hash.substring(1);
        if ($hashtag) {
            let $tab = $tabsTitles.filter('[data-hashtag="' + $hashtag + '"]');
            if ($tab.length > 0) {
                if (!$tab.hasClass('ae-active')) {
                    defaultActiveTab = $tab.data('tab');
                }
                jQuery('html, body').animate({
                    scrollTop: parseInt(jQuery($tab).offset().top) - 100
                }, 1000);
            } else {
                if ( ! defaultActiveTab ) {
                    defaultActiveTab = 1;
                }
            }
        } else {
            if ( ! defaultActiveTab ) {
                defaultActiveTab = 1;
            }
        }
		activateTab(defaultActiveTab);
		
		if (elementorFrontend.isEditMode()) {
            const sections = $scope.find('.elementor-section');
            $.each(sections, function (key, $section) {
                (0,_dynamic_bg__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A)($($section), $);
            });

            const columns = $scope.find('.elementor-column');
            $.each(columns, function (key, $column) {
                (0,_dynamic_bg__WEBPACK_IMPORTED_MODULE_0__/* ["default"] */ .A)($($column), $);
            });
        }
    };

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/ae-acf-repeater.tabs',   ACFRepeaterTabsHandler );
    });
})(jQuery);

/***/ }),

/***/ 245:
/***/ (() => {

const FoldToUnfold = ($scope, $) => {

    if($scope.find('.ae-acf-wrapper').hasClass('ae-acf-unfold-yes')) {
        const acfcontent = $scope.find('.ae-acf-wrapper');
        const acfcontentinner = $scope.find('.ae-acf-content-wrapper');
        const acfcontentunfold = acfcontent.find('.ae-acf-unfold');
        const acfcontentunfoldlink = acfcontentunfold.find('.ae-acf-unfold-link');
        const acfcontentunfoldlinktext = acfcontentunfold.find('.ae-acf-unfold-button-text');
        const acfcontentunfoldlinkicon = acfcontentunfold.find('.ae-acf-unfold-button-icon');
        let totalHeight = 0;
        totalHeight = acfcontentinner.outerHeight();
        if(totalHeight){
            totalHeight += acfcontentunfold.outerHeight();
        }
        if((acfcontentinner.outerHeight() <= acfcontentunfold.data('unfold-max-height')) && acfcontentunfold.data('auto-hide-unfold') == 'yes' ){
            acfcontentunfold.css({ 'display': 'none'});
        }else {
            acfcontentunfoldlink.on('click', function () {
                if (acfcontentunfold.hasClass('fold')) {
                    acfcontent.css({
                        'height': acfcontent.outerHeight(),
                        'max-height': '100%'
                    }).animate({'height': totalHeight}, {'duration': acfcontentunfold.data('animation-speed')});
                    acfcontentunfold.toggleClass('fold');
                    acfcontentunfoldlinktext.html(acfcontentunfold.data('fold-text'));
                    acfcontentunfoldlinkicon.html('<i class="' + acfcontentunfold.data('fold-icon') + '"></i>');
                } else {
                    acfcontent.css({'max-height': totalHeight}).animate({'max-height': acfcontentunfold.data('unfold-max-height')}, {'duration': acfcontentunfold.data('animation-speed')});
                    acfcontentunfold.toggleClass('fold');
                    acfcontentunfoldlinktext.html(acfcontentunfold.data('unfold-text'))
                    acfcontentunfoldlinkicon.html('<i class="' + acfcontentunfold.data('unfold-icon') + '"></i>');
                }

            });
        }

    }
};

(function($){

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/ae-acf.wysiwyg', FoldToUnfold );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/ae-acf.text-area',   FoldToUnfold );
    });

})(jQuery);

/***/ }),

/***/ 448:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(532);


(function($){
    const AeTaxonomyBlocksAccordionHandler = ( $scope , $ ) => {
        const wid = $scope.data('id');
        const outer_wrapper = $scope.find('.ae-taxonomy-widget-wrapper');
        const expand_button = $scope.find('.ae-accordion-toggle-button.expand');
        const collapse_button = $scope.find('.ae-accordion-toggle-button.collapse');
        const items = $scope.find(".ae-accordion-item");
        const swiper_settings = outer_wrapper.data('swiper-settings');
        let title_nav = '';
        // if($(outer_wrapper).hasClass('ae-swiper-nav-align-title')){
        //     const next_button = $scope.find('.ae-term-blocks-title .ae-swiper-button-next');
        //     const prev_button = $scope.find('.ae-term-blocks-title .ae-swiper-button-prev');
        //     next_button.on('click', function(e){
        //         e.preventDefault();
        //         const $this = $(this);
        //         const curr_item = $this.closest('.ae-accordion-item');
        //         const el = $(curr_item).find('.ae-swiper-container');
        //     })
        // }
        
        let acc_status = 'start';
        let toggle = '';
        
        if ($scope.hasClass('ae-tb-layout-carousel')) {
            $.each(items,function(i,item){
                let tid = $(item).data('item-id');
                new _base__WEBPACK_IMPORTED_MODULE_0__/* .SwiperBase */ .Y(swiper_settings, tid);
            })
            
        }
        if(outer_wrapper.hasClass('ae-toggle-yes')){
            toggle = true;
        }

        if(elementorFrontend.isEditMode()){
            
            $scope.find('.elementor-section').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });

            $scope.find('.elementor-column').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });
        }

            
    };

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/ae-taxonomy-blocks.term_post_loop', AeTaxonomyBlocksAccordionHandler);
    });
})(jQuery);

/***/ }),

/***/ 127:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(532);


(function($){
    const AeTaxonomyBlocks = ( $scope , $ ) => {
        
        if ($scope.find('.ae-taxonomy-widget-wrapper').hasClass('ae-carousel-yes')) {
            
            const wid = $scope.data('id');
            const outer_wrapper = $scope.find('.ae-swiper-outer-wrapper');
            const swiper_settings = outer_wrapper.data('swiper-settings');
            new _base__WEBPACK_IMPORTED_MODULE_0__/* .SwiperBase */ .Y(swiper_settings, wid);
        }
            
    };

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/ae-taxonomy-blocks.card', AeTaxonomyBlocks);
        elementorFrontend.hooks.addAction('frontend/element_ready/ae-taxonomy-blocks.classic', AeTaxonomyBlocks);
    });
})(jQuery);

/***/ }),

/***/ 532:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  Y: () => (/* binding */ SwiperBase)
});

// UNUSED EXPORTS: isEditMode

;// CONCATENATED MODULE: ./node_modules/@wordpress/hooks/build-module/validateNamespace.js
/**
 * Validate a namespace string.
 *
 * @param  {string} namespace The namespace to validate - should take the form
 *                            `vendor/plugin/function`.
 *
 * @return {boolean}             Whether the namespace is valid.
 */
function validateNamespace(namespace) {
  if ('string' !== typeof namespace || '' === namespace) {
    // eslint-disable-next-line no-console
    console.error('The namespace must be a non-empty string.');
    return false;
  }

  if (!/^[a-zA-Z][a-zA-Z0-9_.\-\/]*$/.test(namespace)) {
    // eslint-disable-next-line no-console
    console.error('The namespace can only contain numbers, letters, dashes, periods, underscores and slashes.');
    return false;
  }

  return true;
}

/* harmony default export */ const build_module_validateNamespace = (validateNamespace);
//# sourceMappingURL=validateNamespace.js.map
;// CONCATENATED MODULE: ./node_modules/@wordpress/hooks/build-module/validateHookName.js
/**
 * Validate a hookName string.
 *
 * @param  {string} hookName The hook name to validate. Should be a non empty string containing
 *                           only numbers, letters, dashes, periods and underscores. Also,
 *                           the hook name cannot begin with `__`.
 *
 * @return {boolean}            Whether the hook name is valid.
 */
function validateHookName(hookName) {
  if ('string' !== typeof hookName || '' === hookName) {
    // eslint-disable-next-line no-console
    console.error('The hook name must be a non-empty string.');
    return false;
  }

  if (/^__/.test(hookName)) {
    // eslint-disable-next-line no-console
    console.error('The hook name cannot begin with `__`.');
    return false;
  }

  if (!/^[a-zA-Z][a-zA-Z0-9_.-]*$/.test(hookName)) {
    // eslint-disable-next-line no-console
    console.error('The hook name can only contain numbers, letters, dashes, periods and underscores.');
    return false;
  }

  return true;
}

/* harmony default export */ const build_module_validateHookName = (validateHookName);
//# sourceMappingURL=validateHookName.js.map
;// CONCATENATED MODULE: ./node_modules/@wordpress/hooks/build-module/createAddHook.js
/**
 * Internal dependencies
 */



/**
 * Returns a function which, when invoked, will add a hook.
 *
 * @param  {Object}   hooks Stored hooks, keyed by hook name.
 *
 * @return {Function}       Function that adds a new hook.
 */

function createAddHook(hooks) {
  /**
   * Adds the hook to the appropriate hooks container.
   *
   * @param {string}   hookName  Name of hook to add
   * @param {string}   namespace The unique namespace identifying the callback in the form `vendor/plugin/function`.
   * @param {Function} callback  Function to call when the hook is run
   * @param {?number}  priority  Priority of this hook (default=10)
   */
  return function addHook(hookName, namespace, callback) {
    var priority = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 10;

    if (!build_module_validateHookName(hookName)) {
      return;
    }

    if (!build_module_validateNamespace(namespace)) {
      return;
    }

    if ('function' !== typeof callback) {
      // eslint-disable-next-line no-console
      console.error('The hook callback must be a function.');
      return;
    } // Validate numeric priority


    if ('number' !== typeof priority) {
      // eslint-disable-next-line no-console
      console.error('If specified, the hook priority must be a number.');
      return;
    }

    var handler = {
      callback: callback,
      priority: priority,
      namespace: namespace
    };

    if (hooks[hookName]) {
      // Find the correct insert index of the new hook.
      var handlers = hooks[hookName].handlers;
      var i;

      for (i = handlers.length; i > 0; i--) {
        if (priority >= handlers[i - 1].priority) {
          break;
        }
      }

      if (i === handlers.length) {
        // If append, operate via direct assignment.
        handlers[i] = handler;
      } else {
        // Otherwise, insert before index via splice.
        handlers.splice(i, 0, handler);
      } // We may also be currently executing this hook.  If the callback
      // we're adding would come after the current callback, there's no
      // problem; otherwise we need to increase the execution index of
      // any other runs by 1 to account for the added element.


      (hooks.__current || []).forEach(function (hookInfo) {
        if (hookInfo.name === hookName && hookInfo.currentIndex >= i) {
          hookInfo.currentIndex++;
        }
      });
    } else {
      // This is the first hook of its type.
      hooks[hookName] = {
        handlers: [handler],
        runs: 0
      };
    }

    if (hookName !== 'hookAdded') {
      doAction('hookAdded', hookName, namespace, callback, priority);
    }
  };
}

/* harmony default export */ const build_module_createAddHook = (createAddHook);
//# sourceMappingURL=createAddHook.js.map
;// CONCATENATED MODULE: ./node_modules/@wordpress/hooks/build-module/createRemoveHook.js
/**
 * Internal dependencies
 */



/**
 * Returns a function which, when invoked, will remove a specified hook or all
 * hooks by the given name.
 *
 * @param  {Object}   hooks      Stored hooks, keyed by hook name.
 * @param  {boolean}     removeAll  Whether to remove all callbacks for a hookName, without regard to namespace. Used to create `removeAll*` functions.
 *
 * @return {Function}            Function that removes hooks.
 */

function createRemoveHook(hooks, removeAll) {
  /**
   * Removes the specified callback (or all callbacks) from the hook with a
   * given hookName and namespace.
   *
   * @param {string}    hookName  The name of the hook to modify.
   * @param {string}    namespace The unique namespace identifying the callback in the form `vendor/plugin/function`.
   *
   * @return {number}             The number of callbacks removed.
   */
  return function removeHook(hookName, namespace) {
    if (!build_module_validateHookName(hookName)) {
      return;
    }

    if (!removeAll && !build_module_validateNamespace(namespace)) {
      return;
    } // Bail if no hooks exist by this name


    if (!hooks[hookName]) {
      return 0;
    }

    var handlersRemoved = 0;

    if (removeAll) {
      handlersRemoved = hooks[hookName].handlers.length;
      hooks[hookName] = {
        runs: hooks[hookName].runs,
        handlers: []
      };
    } else {
      // Try to find the specified callback to remove.
      var handlers = hooks[hookName].handlers;

      var _loop = function _loop(i) {
        if (handlers[i].namespace === namespace) {
          handlers.splice(i, 1);
          handlersRemoved++; // This callback may also be part of a hook that is
          // currently executing.  If the callback we're removing
          // comes after the current callback, there's no problem;
          // otherwise we need to decrease the execution index of any
          // other runs by 1 to account for the removed element.

          (hooks.__current || []).forEach(function (hookInfo) {
            if (hookInfo.name === hookName && hookInfo.currentIndex >= i) {
              hookInfo.currentIndex--;
            }
          });
        }
      };

      for (var i = handlers.length - 1; i >= 0; i--) {
        _loop(i);
      }
    }

    if (hookName !== 'hookRemoved') {
      doAction('hookRemoved', hookName, namespace);
    }

    return handlersRemoved;
  };
}

/* harmony default export */ const build_module_createRemoveHook = (createRemoveHook);
//# sourceMappingURL=createRemoveHook.js.map
;// CONCATENATED MODULE: ./node_modules/@wordpress/hooks/build-module/createHasHook.js
/**
 * Returns a function which, when invoked, will return whether any handlers are
 * attached to a particular hook.
 *
 * @param  {Object}   hooks Stored hooks, keyed by hook name.
 *
 * @return {Function}       Function that returns whether any handlers are
 *                          attached to a particular hook and optional namespace.
 */
function createHasHook(hooks) {
  /**
   * Returns whether any handlers are attached for the given hookName and optional namespace.
   *
   * @param {string}  hookName  The name of the hook to check for.
   * @param {?string} namespace Optional. The unique namespace identifying the callback
   *                                      in the form `vendor/plugin/function`.
   *
   * @return {boolean} Whether there are handlers that are attached to the given hook.
   */
  return function hasHook(hookName, namespace) {
    // Use the namespace if provided.
    if ('undefined' !== typeof namespace) {
      return hookName in hooks && hooks[hookName].handlers.some(function (hook) {
        return hook.namespace === namespace;
      });
    }

    return hookName in hooks;
  };
}

/* harmony default export */ const build_module_createHasHook = (createHasHook);
//# sourceMappingURL=createHasHook.js.map
;// CONCATENATED MODULE: ./node_modules/@wordpress/hooks/build-module/createRunHook.js


/**
 * Returns a function which, when invoked, will execute all callbacks
 * registered to a hook of the specified type, optionally returning the final
 * value of the call chain.
 *
 * @param  {Object}   hooks          Stored hooks, keyed by hook name.
 * @param  {?boolean}    returnFirstArg Whether each hook callback is expected to
 *                                   return its first argument.
 *
 * @return {Function}                Function that runs hook callbacks.
 */
function createRunHook(hooks, returnFirstArg) {
  /**
   * Runs all callbacks for the specified hook.
   *
   * @param  {string} hookName The name of the hook to run.
   * @param  {...*}   args     Arguments to pass to the hook callbacks.
   *
   * @return {*}               Return value of runner, if applicable.
   */
  return function runHooks(hookName) {
    if (!hooks[hookName]) {
      hooks[hookName] = {
        handlers: [],
        runs: 0
      };
    }

    hooks[hookName].runs++;
    var handlers = hooks[hookName].handlers; // The following code is stripped from production builds.

    if (false) {}

    for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      args[_key - 1] = arguments[_key];
    }

    if (!handlers || !handlers.length) {
      return returnFirstArg ? args[0] : undefined;
    }

    var hookInfo = {
      name: hookName,
      currentIndex: 0
    };

    hooks.__current.push(hookInfo);

    while (hookInfo.currentIndex < handlers.length) {
      var handler = handlers[hookInfo.currentIndex];
      var result = handler.callback.apply(null, args);

      if (returnFirstArg) {
        args[0] = result;
      }

      hookInfo.currentIndex++;
    }

    hooks.__current.pop();

    if (returnFirstArg) {
      return args[0];
    }
  };
}

/* harmony default export */ const build_module_createRunHook = (createRunHook);
//# sourceMappingURL=createRunHook.js.map
;// CONCATENATED MODULE: ./node_modules/@wordpress/hooks/build-module/createCurrentHook.js
/**
 * Returns a function which, when invoked, will return the name of the
 * currently running hook, or `null` if no hook of the given type is currently
 * running.
 *
 * @param  {Object}   hooks          Stored hooks, keyed by hook name.
 *
 * @return {Function}                Function that returns the current hook.
 */
function createCurrentHook(hooks) {
  /**
   * Returns the name of the currently running hook, or `null` if no hook of
   * the given type is currently running.
   *
   * @return {?string}             The name of the currently running hook, or
   *                               `null` if no hook is currently running.
   */
  return function currentHook() {
    if (!hooks.__current || !hooks.__current.length) {
      return null;
    }

    return hooks.__current[hooks.__current.length - 1].name;
  };
}

/* harmony default export */ const build_module_createCurrentHook = (createCurrentHook);
//# sourceMappingURL=createCurrentHook.js.map
;// CONCATENATED MODULE: ./node_modules/@wordpress/hooks/build-module/createDoingHook.js
/**
 * Returns a function which, when invoked, will return whether a hook is
 * currently being executed.
 *
 * @param  {Object}   hooks Stored hooks, keyed by hook name.
 *
 * @return {Function}       Function that returns whether a hook is currently
 *                          being executed.
 */
function createDoingHook(hooks) {
  /**
   * Returns whether a hook is currently being executed.
   *
   * @param  {?string} hookName The name of the hook to check for.  If
   *                            omitted, will check for any hook being executed.
   *
   * @return {boolean}             Whether the hook is being executed.
   */
  return function doingHook(hookName) {
    // If the hookName was not passed, check for any current hook.
    if ('undefined' === typeof hookName) {
      return 'undefined' !== typeof hooks.__current[0];
    } // Return the __current hook.


    return hooks.__current[0] ? hookName === hooks.__current[0].name : false;
  };
}

/* harmony default export */ const build_module_createDoingHook = (createDoingHook);
//# sourceMappingURL=createDoingHook.js.map
;// CONCATENATED MODULE: ./node_modules/@wordpress/hooks/build-module/createDidHook.js
/**
 * Internal dependencies
 */

/**
 * Returns a function which, when invoked, will return the number of times a
 * hook has been called.
 *
 * @param  {Object}   hooks Stored hooks, keyed by hook name.
 *
 * @return {Function}       Function that returns a hook's call count.
 */

function createDidHook(hooks) {
  /**
   * Returns the number of times an action has been fired.
   *
   * @param  {string} hookName The hook name to check.
   *
   * @return {number}          The number of times the hook has run.
   */
  return function didHook(hookName) {
    if (!build_module_validateHookName(hookName)) {
      return;
    }

    return hooks[hookName] && hooks[hookName].runs ? hooks[hookName].runs : 0;
  };
}

/* harmony default export */ const build_module_createDidHook = (createDidHook);
//# sourceMappingURL=createDidHook.js.map
;// CONCATENATED MODULE: ./node_modules/@wordpress/hooks/build-module/createHooks.js
/**
 * Internal dependencies
 */







/**
 * Returns an instance of the hooks object.
 *
 * @return {Object} Object that contains all hooks.
 */

function createHooks() {
  var actions = Object.create(null);
  var filters = Object.create(null);
  actions.__current = [];
  filters.__current = [];
  return {
    addAction: build_module_createAddHook(actions),
    addFilter: build_module_createAddHook(filters),
    removeAction: build_module_createRemoveHook(actions),
    removeFilter: build_module_createRemoveHook(filters),
    hasAction: build_module_createHasHook(actions),
    hasFilter: build_module_createHasHook(filters),
    removeAllActions: build_module_createRemoveHook(actions, true),
    removeAllFilters: build_module_createRemoveHook(filters, true),
    doAction: build_module_createRunHook(actions),
    applyFilters: build_module_createRunHook(filters, true),
    currentAction: build_module_createCurrentHook(actions),
    currentFilter: build_module_createCurrentHook(filters),
    doingAction: build_module_createDoingHook(actions),
    doingFilter: build_module_createDoingHook(filters),
    didAction: build_module_createDidHook(actions),
    didFilter: build_module_createDidHook(filters),
    actions: actions,
    filters: filters
  };
}

/* harmony default export */ const build_module_createHooks = (createHooks);
//# sourceMappingURL=createHooks.js.map
;// CONCATENATED MODULE: ./node_modules/@wordpress/hooks/build-module/index.js
/**
 * Internal dependencies
 */


var _createHooks = build_module_createHooks(),
    addAction = _createHooks.addAction,
    addFilter = _createHooks.addFilter,
    removeAction = _createHooks.removeAction,
    removeFilter = _createHooks.removeFilter,
    hasAction = _createHooks.hasAction,
    hasFilter = _createHooks.hasFilter,
    removeAllActions = _createHooks.removeAllActions,
    removeAllFilters = _createHooks.removeAllFilters,
    doAction = _createHooks.doAction,
    applyFilters = _createHooks.applyFilters,
    currentAction = _createHooks.currentAction,
    currentFilter = _createHooks.currentFilter,
    doingAction = _createHooks.doingAction,
    doingFilter = _createHooks.doingFilter,
    didAction = _createHooks.didAction,
    didFilter = _createHooks.didFilter,
    actions = _createHooks.actions,
    filters = _createHooks.filters;


//# sourceMappingURL=index.js.map
;// CONCATENATED MODULE: ./src/js/base.js


window.aep = {
    hooks : build_module_createHooks()
}

const isEditMode = () => {
    return false;
}

class SwiperBase{

    constructor(data, wid, scope = null) {

        let swiper = [];
        let swiperContainer = '.elementor-element-' + wid + ' .ae-swiper-container';
		let active_breakpoints = elementorFrontend.config.responsive.activeBreakpoints;
		let wclass = '.elementor-element-' + wid;

        if (scope !== null) {
			wid = scope.data('id');
			let slideId = scope.find('.ae-swiper-container').data('ae-slider-id');
			swiperContainer = '.elementor-element-' + wid + ' [data-ae-slider-id="' + slideId + '"]';
			wclass = '.elementor-element-' + wid + ' .ae-slider-id-' + slideId;
		}
		
        if (typeof data === "undefined") {
            return false;
        }

        // Special Case Only For AE-Woo-Gallery
        if(data.hasOwnProperty('widget')){
            if(data.widget == 'ae-woo-gallery' ){
                if (data.navigation != 'no') {
                    swiper['navigation'] = {
                        nextEl: '.ae-swiper-button-next',
                        prevEl: '.ae-swiper-button-prev',
                    }
                }
                swiper['pagination']= {
                    el: '.ae-swiper-pagination',
                    type: 'bullets',
                    clickable: true,
                }
                swiper['init'] = false;
            }
        }else{
            swiper = {
                direction: data.direction,
                speed: data.speed,
                autoHeight: data.autoHeight,
                autoplay: data.autoplay,
                effect: data.effect,
                loop: data.loop,
                //zoom: data.zoom,
                wrapperClass: 'ae-swiper-wrapper',
                slideClass: 'ae-swiper-slide',
                observer: true,
				observeParents: true,
			}
			
			if (data.initialSlide !== 0 && data.hasOwnProperty('initialSlide')) {
				swiper['initialSlide'] = data.initialSlide;
			}

            const res_props = {
                'slidesPerView' : 'slidesPerView',
                'slidesPerGroup' : 'slidesPerGroup',
                'spaceBetween' : 'spaceBetween'
            }
            // Minimum Screen Set
            if(active_breakpoints.hasOwnProperty('mobile')){
                for (const key in res_props) {
                    if (data.hasOwnProperty(key)) {
                        swiper[key] = data[key].mobile;       
                    }
                }
            }
    
            if (data.loop && data.hasOwnProperty('slidersPerView')) {
                if (document.querySelectorAll(wclass + ' .ae-swiper-slide').length < data.slidesPerView.tablet) {
                    swiper['loop'] = false;
                }
            }

			const arr = {};
			const arrThumbs = {};

            // Responsive BreakPoints Sets
            if(data.hasOwnProperty('breakpoints_value')){
                Object.keys(data.breakpoints_value).map(key => {
                    
                    const value = parseInt(data.breakpoints_value[key]); 
                    if(key === 'desktop'){
                        key = 'default';
                    }
                    const spaceBetween = parseInt(data.spaceBetween[key]);
                    const slidesPerView = parseInt(data.slidesPerView[key]);
                    const slidesPerGroup = parseInt(data.slidesPerGroup[key]);
                    arr[value - 1] = {
                        spaceBetween,
                        slidesPerView,
                        slidesPerGroup
					};

					if (typeof data['thumbs'] !== 'undefined' && data['thumbs']['enable']) {
					
						const spaceBetweenThumbs = parseInt(data.thumbs.spaceBetween[key]);
						const slidesPerViewThumbs = parseInt(data.thumbs.slidesPerView[key]);
						//const slidesPerGroupThumbs = parseInt(slider_data.thumbs.slidesPerGroup[key]);
						arrThumbs[value - 1] = {
							spaceBetween: spaceBetweenThumbs,
							slidesPerView: slidesPerViewThumbs,
						};
					}
                });
            }
    
            // BreakPoints
            const bp = aepro.breakpoints;
    
            // let breakpoints = {};
            // breakpoints[bp.lg - 1] = {
            //     spaceBetween: data.spaceBetween.tablet,
            //     slidesPerView: data.slidesPerView.tablet,
            //     slidesPerGroup: data.slidesPerGroup.tablet,
            // };
            // breakpoints[bp.md - 1] = {
            //     spaceBetween: data.spaceBetween.mobile,
            //     slidesPerView: data.slidesPerView.mobile,
            //     slidesPerGroup: data.slidesPerGroup.mobile,
            // };
    
            swiper['breakpoints'] = arr;
    
            swiper['keyboard'] = (data.keyboard === 'yes') ? { enabled: true, onlyInViewport: true } : false;
    
            if (data.navigation === 'yes') {
                swiper['navigation'] = {
                    nextEl: wclass + ' .ae-swiper-button-next',
                    prevEl: wclass + ' .ae-swiper-button-prev',
                }
            }
    
            if (data.ptype !== '') {
                swiper['pagination'] = {
                    el: wclass + ' .ae-swiper-pagination',
                    type: data.ptype,
                    clickable: data.clickable
                }
            }
            if (data.scrollbar == 'yes') {
    
                swiper['scrollbar'] = {
                    el: wclass + ' .ae-swiper-scrollbar',
                    hide: true
                };
			}

			if (typeof data['thumbs'] !== 'undefined' && data['thumbs']['enable']) {
				swiper['thumbs'] = {
					swiper: {
						el: wclass + ' .ae-thumb-swiper-container',
						direction: "horizontal",
						breakpoints: arrThumbs,
						speed: data.speed,
						loop: "yes" === data.loop ? true : false,
						freeMode: true,
						watchSlidesVisibility: true,
						watchSlidesProgress: true,
						slideToClickedSlide: true,
					},
				}
			}

            swiper['init'] = false;
        }

        // Special Case For AE-Woo-Gallery-Widget
        if(data.hasOwnProperty('widget')){
            if(data.widget === 'ae-woo-gallery'){
                swiper = this.ae_woo_gallery_update_object(data,swiper);
            }
        }
        
        //if ('undefined' === typeof Swiper) {
		const asyncSwiper = elementorFrontend.utils.swiper;
			
		if (jQuery(swiperContainer) !== null && jQuery(swiperContainer).length === 0){
			return;
		}
		
		new asyncSwiper(jQuery(swiperContainer), swiper).then((newSwiperInstance) => {
                const mswiper = newSwiperInstance;
                this.after_swiper_load_func(mswiper);
                const pause_on_hover = data.pause_on_hover;
                if (pause_on_hover == 'yes') {
                    this.pause_on_hover_func(mswiper, pause_on_hover, wid);
                }

                elementorFrontend.hooks.doAction( `aepro/trigger/swiper/widget/${wid}`, mswiper);
            });
        /* } else {
            const mswiper = new Swiper('.elementor-element-' + wid + ' .ae-swiper-container', swiper);
            //if ('undefined' !== typeof mswiper.$wrapperEl) {
                this.after_swiper_load_func(mswiper);
                const pause_on_hover = data.pause_on_hover;
                if (pause_on_hover == 'yes') {
                    this.pause_on_hover_func(mswiper, pause_on_hover, wid);
                }
           //}

            elementorFrontend.hooks.doAction( `aepro/trigger/swiper/widget/${wid}`, mswiper);
        } */
        
        jQuery('.elementor-element-' + wid + ' .ae-swiper-container').css('visibility', 'visible');
        

        // TODO:: Swiper post initialize actions

        // TODO:: Swiper sticky section fix
    }
    after_swiper_load_func(mswiper) {
        if (mswiper.length > 0) {

                mswiper.forEach(function (slider) {

                    slider.on('slideChangeTransitionStart', function () {

                        // set dynamic background
                        slider.$wrapperEl.find('.ae-featured-bg-yes').each(function () {
                            if (jQuery(this).css('background-image') == 'none') {
                                let img = jQuery(this).attr('data-ae-bg');
                                jQuery(this).css('background-image', 'url(' + img + ')');
                            }
                        });
                        slider.$wrapperEl.find('.ae-bg-color-yes').each(function () {
                            let color = jQuery(this).attr('data-ae-bg-color');
                            let blank_color = 'rgba(0, 0, 0, 0)';
                            if (jQuery(this).css('background-color') === blank_color) {
                                jQuery(this).css('background-color', color);
                            }
                        });

                        // reveal animated widgets
                        slider.$wrapperEl.find('.swiper-slide-duplicate').find('.elementor-invisible').each(function () {
                            // get settings
                            elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
                        });

                        slider.$wrapperEl.find('.swiper-slide').find('.animated').each(function () {
                            // get settings
                             elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
                        });

                    });

                    slider.on('click', function () {

                        const clickedSlide = mswiper.clickedSlide;
                        if (typeof clickedSlide === 'undefined') {
                            return;
                        }

                        const wrapper = clickedSlide.querySelector('.ae-link-yes');

                        if (wrapper === null || wrapper.length == 0) {
                            return;
                        } else {
                            const url = jQuery(wrapper).data('ae-url');
                            if (url !== undefined) {
                                if (jQuery(wrapper).data('ae-url') && jQuery(wrapper).hasClass('ae-new-window-yes')) {
                                    window.open(jQuery(wrapper).data('ae-url'));
                                } else {
                                    location.href = jQuery(wrapper).data('ae-url');
                                }
                            }
                        }
                    });

                    slider.init();
                });

            } else {

                mswiper.on('slideChangeTransitionStart', function () {
                    // set dynamic background
                    mswiper.$wrapperEl.find('.ae-featured-bg-yes').each(function () {
                        
                        if (jQuery(this).css('background-image') == 'none') {
                            let img = jQuery(this).attr('data-ae-bg');
                            jQuery(this).css('background-image', 'url(' + img + ')');
                        }
                    });

                    mswiper.$wrapperEl.find('.ae-bg-color-yes').each(function () {
                        let color = jQuery(this).attr('data-ae-bg-color');
                            let blank_color = 'rgba(0, 0, 0, 0)';
                            if (jQuery(this).css('background-color') === blank_color) {
                                jQuery(this).css('background-color', color);
                            }
                    });
                    // reveal animated widgets
                    mswiper.$wrapperEl.find('.swiper-slide-duplicate').find('.elementor-invisible').each(function () {
                        // get settings
                         elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
                    });

                    mswiper.$wrapperEl.find('.swiper-slide').find('.animated').each(function () {
                        // get settings
                         elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
                    });
                });
                

                mswiper.on('click', function () {

                    const clickedSlide = mswiper.clickedSlide;
                    if (typeof clickedSlide === 'undefined') {
                        return;
                    }

                    const wrapper = clickedSlide.querySelector('.ae-link-yes');

                    if (wrapper === null || wrapper.length == 0) {
                        return;
                    } else {
                        const url = jQuery(wrapper).data('ae-url');
                        if (url !== undefined) {
                            if (jQuery(wrapper).data('ae-url') && jQuery(wrapper).hasClass('ae-new-window-yes')) {
                                window.open(jQuery(wrapper).data('ae-url'));
                            } else {
                                location.href = jQuery(wrapper).data('ae-url');
                            }
                        }
                    }
                });

                mswiper.init();

            }
    }

    pause_on_hover_func(mswiper, pause_on_hover, wid) {
        jQuery('.elementor-element-' + wid + ' .ae-swiper-container').hover(function () {
            mswiper.autoplay.stop();
        }, function () {
            mswiper.autoplay.start();
        });
    }

    ae_woo_gallery_update_object(data,swiper){
        if (data.navigation != 'no') {
            swiper['navigation'] = {
                nextEl: '.ae-swiper-button-next',
                prevEl: '.ae-swiper-button-prev',
            }
        }
        swiper['pagination']= {
            el: '.ae-swiper-pagination',
            type: 'bullets',
            clickable: true,
        }
        Object.keys(swiper).map(key =>{
            const value = swiper[key];
            if(typeof value === 'object'){
                Object.keys(value).map(val =>{
                    const v = value[val];
                    if(typeof v === 'undefined' ){
                        delete value[val];   
                    }
                })
            }else{
                if(typeof value === 'undefined'){
                    delete swiper[key];
                }
                
            }
        });
        return swiper;
    }
}

/***/ }),

/***/ 822:
/***/ (() => {

(function($){

    const CFGoogleMap = ( $scope , $) => {

        if($scope.find('.ae-cf-gmap').length) {
            
            const add_marker = ($marker, map) => {
                // var
                const latlng = new google.maps.LatLng($marker.attr('data-lat'), $marker.attr('data-lng'));

                // create marker
                var marker = new google.maps.Marker({
                    position: latlng,
                    map: map,
                });

                // add to array
                map.markers.push(marker);

                // if marker contains HTML, add it to an infoWindow

                if ($marker.html()) {
                    // create info window
                    var infowindow = new google.maps.InfoWindow({
                        content: $marker.html()
                    });

                    // show info window when marker is clicked
                    google.maps.event.addListener(marker, 'click', function () {
                        infowindow.open(map, marker);
                    });
                }
            }

            const new_map = ($el) => {
                const zoom = $scope.find('.ae-cf-gmap').data('zoom');
                const $markers = $el.find('.marker');
                const styles = $scope.find('.ae-cf-gmap').data('styles');
                
                // vars
                const args = {
                    zoom: zoom,
                    center: new google.maps.LatLng(0, 0),
                    mapTypeId: google.maps.MapTypeId.ROADMAP,
                    styles: styles
                };

                // create map
                const map = new google.maps.Map($el[0], args);

                // add a markers reference
                map.markers = [];

                // add markers
                $markers.each(function () {
                    add_marker(jQuery(this), map);
                });

                // center map
                center_map(map, zoom);

                // return
                return map;
            }

            

            const center_map = (map, zoom) => {

                // vars
                var bounds = new google.maps.LatLngBounds();
                // loop through all markers and create bounds
                jQuery.each(map.markers, function (i, marker) {
                    var latlng = new google.maps.LatLng(marker.position.lat(), marker.position.lng());
                    bounds.extend(latlng);
                });

                // only 1 marker?
                if (map.markers.length == 1) {
                    // set center of map
                    map.setCenter(bounds.getCenter());
                    map.setZoom(zoom);
                }
                else {
                    // fit to bounds
                    map.fitBounds(bounds);
                }
            }

            map = new_map($scope.find('.ae-cf-gmap'));
        }

        

    };

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/ae-cf-google-map.default', 	CFGoogleMap );
    });
})(jQuery);

/***/ }),

/***/ 410:
/***/ (() => {

(function($){

    const CustomFieldHandler = function ( $scope , $ ) {

        if(elementorFrontend.isEditMode()){
            return;
        }

        if($scope.find('.ae-cf-wrapper').hasClass('hide')){
            $scope.find('.ae-cf-wrapper').closest('.elementor-widget-ae-custom-field').hide();
        }
    };

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/ae-custom-field.default', CustomFieldHandler );
    });

})(jQuery);

/***/ }),

/***/ 742:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const customOverlay =  ({ OverlayView = google.maps.OverlayView, ...args}) => {
  class CustomOverlay extends OverlayView {
    constructor() {
      super();
      this.position = args.position;
      this.html = args.html;
      this.markerIndex = args.markerIndex;
      this.setMap(args.map);
    }

    createDiv() {
      this.div = document.createElement("div");
      this.div.classList.add('ae-map-infowindow-wrapper');
      this.div.style.position = "absolute";
      if (this.html) {
        this.div.innerHTML = this.html;
      }
    }

    appendDivToOverlay() {
      const panes = this.getPanes();
      panes.overlayImage.appendChild(this.div);
    }

    positionDiv() {
      const point = this.getProjection().fromLatLngToDivPixel(this.position);
      //let offset = 50;
      if (point) {
        //this.div.style.left = `${point.x - 12}px`;
        //this.div.style.top = `${point.y - offset}px`;
        this.div.style.left = `${point.x}px`;
        this.div.style.top = `${point.y}px`;
      }
    }

    draw() {
      if (!this.div) {
        this.createDiv();
        this.appendDivToOverlay();
      }
      this.positionDiv();
    }

    remove() {
      if (this.div) {
        this.div.parentNode.removeChild(this.div);
        this.div = null;
      }
    }

    getPosition() {
      return this.position;
    }

    getDraggable() {
      return false;
    }
  }

  return new CustomOverlay();
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (customOverlay);


/***/ }),

/***/ 591:
/***/ (() => {

(function ($) {
    'use strict';

    function Hoverdir(element, options) {
        this.$el = $(element);
        // set options
        this.options = $.extend(true, {}, this.defaults, options);
        // initialize visibility to false for show and hide method
        this.isVisible = false;
        // get the hover for this element
        this.$hoverElem = this.$el.find(this.options.hoverElem);
        // transition properties
        this.transitionProp = 'all ' + this.options.speed + 'ms ' + this.options.easing;
        // support for CSS transitions
        this.support = this._supportsTransitions();
        // load the events
        this._loadEvents();
    }

    Hoverdir.prototype = {
        defaults: {
            speed: 300,
            easing: 'ease',
            hoverDelay: 0,
            inverse: false,
            hoverElem: 'div'
        },
        constructor: Hoverdir,
        /**
         * Detect if CSS transitions are supported
         *
         * @return {Boolean}
         */
        _supportsTransitions: function () {
            if (typeof Modernizr !== 'undefined') {
                return Modernizr.csstransitions;
            } else {
                var b = document.body || document.documentElement,
                    s = b.style,
                    p = 'transition';

                if (typeof s[p] === 'string') {
                    return true;
                }

                // Tests for vendor specific prop
                var v = ['Moz', 'webkit', 'Webkit', 'Khtml', 'O', 'ms'];
                p = p.charAt(0).toUpperCase() + p.substr(1);

                for (var i = 0; i < v.length; i++) {
                    if (typeof s[v[i] + p] === 'string') {
                        return true;
                    }
                }

                return false;
            }
        },
        /**
         * Bind the events to the element
         */
        _loadEvents: function () {
            this.$el.on('mouseenter.hoverdir mouseleave.hoverdir', $.proxy(function (event) {
                this.direction = this._getDir({x: event.pageX, y: event.pageY});

                if (event.type === 'mouseenter') {
                    this._showHover();
                }
                else {
                    this._hideHover();
                }
            }, this));
        },
        /**
         * Show the hover of the element
         */
        _showHover: function () {
            var styleCSS = this._getStyle(this.direction);

            if (this.support) {
                this.$hoverElem.css('transition', '');
            }

            this.$hoverElem.hide().css(styleCSS.from);
            clearTimeout(this.tmhover);

            this.tmhover = setTimeout($.proxy(function () {
                this.$hoverElem.show(0, $.proxy(function () {
                    if (this.support) {
                        this.$hoverElem.css('transition', this.transitionProp);
                    }
                    this._applyAnimation(styleCSS.to);

                }, this));
            }, this), this.options.hoverDelay);

            this.isVisible = true;
        },
        /**
         * Hide the hover to the element
         */
        _hideHover: function () {
            var styleCSS = this._getStyle(this.direction);
            if (this.support) {
                this.$hoverElem.css('transition', this.transitionProp);
            }
            clearTimeout(this.tmhover);
            this._applyAnimation(styleCSS.from);
            this.isVisible = false;
        },
        /**
         * get the direction when the event is triggered
         * credits : http://stackoverflow.com/a/3647634
         *
         * @param {Object} coordinates
         * @returns {Interger}
         */
        _getDir: function (coordinates) {
            // the width and height of the current div
            var w = this.$el.width(),
                h = this.$el.height(),
                // calculate the x and y to get an angle to the center of the div from that x and y.
                // gets the x value relative to the center of the DIV and "normalize" it
                x = (coordinates.x - this.$el.offset().left - (w / 2)) * (w > h ? (h / w) : 1),
                y = (coordinates.y - this.$el.offset().top - (h / 2)) * (h > w ? (w / h) : 1),
                // the angle and the direction from where the mouse came in/went out clockwise (TRBL=0123);
                // first calculate the angle of the point,
                // add 180 deg to get rid of the negative values
                // divide by 90 to get the quadrant
                // add 3 and do a modulo by 4 to shift the quadrants to a proper clockwise TRBL (top/right/bottom/left) **/
                direction = Math.round((((Math.atan2(y, x) * (180 / Math.PI)) + 180) / 90) + 3) % 4;
            return direction;
        },
        /**
         * get the style when the event is triggered
         *
         * @param {(Interger|String)} direction
         * @returns {Object}
         */
        _getStyle: function (direction) {
            var fromStyle, toStyle,
                slideFromTop = {'left': '0', 'top': '-100%'},
            slideFromBottom = {'left': '0', 'top': '100%'},
            slideFromLeft = {'left': '-100%', 'top': '0'},
            slideFromRight = {'left': '100%', 'top': '0'},
            slideTop = {'top': '0'},
            slideLeft = {'left': '0'};

            switch (direction) {
                case 0:
                case 'top':
                    // from top
                    fromStyle = !this.options.inverse ? slideFromTop : slideFromBottom;
                    toStyle = slideTop;
                    break;
                case 1:
                case 'right':
                    // from right
                    fromStyle = !this.options.inverse ? slideFromRight : slideFromLeft;
                    toStyle = slideLeft;
                    break;
                case 2:
                case 'bottom':
                    // from bottom
                    fromStyle = !this.options.inverse ? slideFromBottom : slideFromTop;
                    toStyle = slideTop;
                    break;
                case 3:
                case 'left':
                    // from left
                    fromStyle = !this.options.inverse ? slideFromLeft : slideFromRight;
                    toStyle = slideLeft;
                    break;
            }

            return {from: fromStyle, to: toStyle};
        },
        /**
         * Apply a transition or fallback to jquery animate based on Modernizr.csstransitions support
         *
         * @param {Object} styleCSS
         */
        _applyAnimation: function (styleCSS) {
            $.fn.applyStyle = this.support ? $.fn.css : $.fn.animate;
            this.$hoverElem.stop().applyStyle(styleCSS, $.extend(true, [], {duration: this.options.speed}));
        },
        /**
         * Show $hoverElem from the direction in argument
         *
         * @param {String} [direction=top] direction
         */
        show: function (direction) {
            this.$el.off('mouseenter.hoverdir mouseleave.hoverdir');
            if (!this.isVisible) {
                this.direction = direction || 'top';
                this._showHover();
            }
        },
        /**
         * Hide $hoverElem from the direction in argument
         *
         * @param {String} [direction=bottom] direction
         */
        hide: function (direction) {
            this.rebuild();
            if (this.isVisible) {
                this.direction = direction || 'bottom';
                this._hideHover();
            }
        },
        setOptions: function (options) {
            this.options = $.extend(true, {}, this.defaults, this.options, options);
        },
        /**
         * Unbinds the plugin.
         */
        destroy: function () {
            this.$el.off('mouseenter.hoverdir mouseleave.hoverdir');
            this.$el.data('hoverdir', null);
        },
        /**
         * Bind the plugin.
         */
        rebuild: function (options) {
            if (typeof options === 'object') {
                this.setOptions(options);
            }
            this._loadEvents();
        }
    };

    $.fn.hoverdir = function (option, parameter) {
        return this.each(function () {
            var data = $(this).data('hoverdir');
            var options = typeof option === 'object' && option;

            // Initialize hoverdir.
            if (!data) {
                data = new Hoverdir(this, options);
                $(this).data('hoverdir', data);
            }

            // Call hoverdir method.
            if (typeof option === 'string') {
                data[option](parameter);

                if (option === 'destroy') {
                    $(this).data('hoverdir', false);
                }
            }
        });
    };

    $.fn.hoverdir.Constructor = Hoverdir;
})(jQuery);

/***/ }),

/***/ 207:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(532);


const BgSliderHandler = ( $scope , $ ) => {
    
    let wid = $scope.data('id');
    let ae_slider_id = $scope.data('ae_slider');
    let slider_images;
    let aepro_slides = [];
    let aepro_slides_json = [];
    let aepro_transition;
    let aepro_animation;
    let aepro_custom_overlay;
    let aepro_overlay;
    let aepro_cover;
    let aepro_delay;
    let aepro_timer;
    let slider_wrapper;
    if ($scope.children('.aepro-section-bs').children('.aepro-section-bs-inner').hasClass('edit-mode')) {
        slider_wrapper = $scope.children('.aepro-section-bs').children('.aepro-section-bs-inner');
        slider_images = slider_wrapper.data('aepro-bg-slider');
        aepro_transition = slider_wrapper.data('aepro-bg-slider-transition');
        aepro_animation = slider_wrapper.data('aepro-bg-slider-animation');
        aepro_custom_overlay = slider_wrapper.data('aepro-bg-custom-overlay');
        aepro_cover = slider_wrapper.data('aepro-bg-slider-cover');
        aepro_delay = slider_wrapper.data('aepro-bs-slider-delay');
        aepro_timer = slider_wrapper.data('aepro-bs-slider-timer');

        if(aepro_custom_overlay == 'yes'){
            aepro_overlay = aepro.plugin_url + '/includes/assets/lib/vegas/overlays/' + slider_wrapper.data('aepro-bg-slider-overlay');
        }else{
            if(slider_wrapper.data('aepro-bg-slider-overlay')){
                aepro_overlay = aepro.plugin_url + '/includes/assets/lib/vegas/overlays/' + slider_wrapper.data('aepro-bg-slider-overlay');
            }else{
                aepro_overlay = aepro.plugin_url + '/includes/assets/lib/vegas/overlays/' + slider_wrapper.data('aepro-bg-slider-overlay');
            }
        }

        if(typeof slider_images != 'undefined'){
            aepro_slides = slider_images.split(",");

            jQuery.each(aepro_slides,function(key,value){
                var slide = [];
                slide.src = value;
                aepro_slides_json.push(slide);
            });

            slider_wrapper.vegas({
                slides: aepro_slides_json,
                transition:aepro_transition,
                animation: aepro_animation,
                overlay: aepro_overlay,
                cover: aepro_cover,
                delay: aepro_delay,
                timer: aepro_timer,
                init: function(){
                    if(aepro_custom_overlay == 'yes') {
                        var ob_vegas_overlay = slider_wrapper.children('.vegas-overlay');
                        ob_vegas_overlay.css('background-image', '');
                    }
                }
            });

        }
    } else {
        if (ae_slider_id) {
            slider_wrapper = jQuery(".elementor-element-" + wid + "[data-ae_slider='" + ae_slider_id + "']").children('.aepro-section-bs').children('.aepro-section-bs-inner');
            aepro_slides = slider_wrapper.data('aepro-bg-slider');
            if (aepro_slides) {
                slider_images = aepro_slides.slides;
                aepro_transition = aepro_slides.transition;
                aepro_animation = aepro_slides.animation;
                aepro_overlay = aepro_slides.overlay;
                aepro_custom_overlay = aepro_slides.overlay;
                aepro_cover = aepro_slides.cover;
                aepro_delay = aepro_slides.delay;
                aepro_timer = aepro_slides.timer;
                if (typeof slider_images != 'undefined') {
            

                    slider_wrapper.vegas({
                        slides: slider_images,
                        transition: aepro_transition,
                        animation: aepro_animation,
                        overlay: aepro_overlay,
                        cover: aepro_cover,
                        delay: aepro_delay,
                        timer: aepro_timer,
                        init: function () {
                            if (aepro_custom_overlay == 'yes') {
                                var ob_vegas_overlay = slider_wrapper.children('.vegas-overlay');
                                ob_vegas_overlay.css('background-image', aepro_overlay);
                            }
                        }
                    });

                }
            }
        }
    }
};

const DynamicBgHandler = function ($scope, $) {
    var scope_id = $scope.data('id');
    const dynamicBackground = $scope.find('.dynamic-background').data('dynamic_bg');
    if ($scope.hasClass("elementor-element-edit-mode")) {
        var data = {
            post_id : aepro.queried_page.ID,
            action: 'ae_repeater_data',
            nonce: aepro.aep_nonce
        }
   
        if (dynamicBackground) {
            if (dynamicBackground.acf_field_type == 'repeater') {
                //For Repeater Background Image
                if (dynamicBackground.show_featured_bg == 'yes' && dynamicBackground.bg_source == 'custom_field') {
            
                    let fieldName = dynamicBackground.cf_field_key;
                    let imageSize = dynamicBackground.image_size;

                    data['fieldType'] = 'image';
                    data['image_size'] = imageSize;
                    data['fieldName'] = fieldName;
                    jQuery.ajax({
                        url: aepro.ajaxurl,
                        dataType: 'json',
                        data: data,
                        
                        method: 'POST',
                        success: function (res) {
                            if (res.data) {
                                if (res.data['field_type'] == 'image')
                                    $scope.css('background-image', 'url(' + res.data['value'][0] + ')');
                            }
                            
                        }
                    });
                }

                //For Repeater Background Color
                if (dynamicBackground.enable_bg_color == 'yes' && dynamicBackground.bg_color_source == 'custom_field') {
                    let fieldName = dynamicBackground.cf_color_field_key;

                    data['fieldType'] = 'color';
                    data['fieldName'] = fieldName;
                    jQuery.ajax({
                        url: aepro.ajaxurl,
                        dataType: 'json',
                        data: data,
                    
                        method: 'POST',
                        success: function (res) {
                            if (res.data) {
                                if (res.data['field_type'] == 'color')
                                    $scope.css('background-color', res.data['value']);
                            }
                        }
                    });
                }
            }

            //For Flexible Background Color
            if (dynamicBackground.acf_field_type == 'flexible_content') {
                if (dynamicBackground.show_featured_bg == 'yes' && dynamicBackground.bg_source == 'custom_field') {
                    if (dynamicBackground.bg_flexible_field == 'yes') {
                        let flexibleField = dynamicBackground.cf_field_key;
                        let fieldName = dynamicBackground.flex_sub_field;
                        let imageSize = dynamicBackground.image_size;
                        data['flexible_field'] = flexibleField;

                        data['fieldType'] = 'image';
                        data['image_size'] = imageSize;
                        data['fieldName'] = fieldName;
                        jQuery.ajax({
                            url: aepro.ajaxurl,
                            dataType: 'json',
                            data: data,
                        
                            method: 'POST',
                            success: function (res) {
                                if (res.data) {
                                    if (res.data['field_type'] == 'image')
                                        $scope.css('background-image', 'url(' + res.data['value'][0] + ')');
                                }
                            
                            }
                        });
                    }
                }
            
                //For Flexible Background Color
                if (dynamicBackground.enable_bg_color == 'yes' && dynamicBackground.bg_color_source == 'custom_field') {
                    if (dynamicBackground.bg_color_flexible_field == 'yes') {
                        let flexibleField = dynamicBackground.cf_color_field_key;
                        let fieldName = dynamicBackground.flex_color_sub_field;
                        data['flexible_field'] = flexibleField;

                        data['fieldType'] = 'color';
                        data['fieldName'] = fieldName;
                        jQuery.ajax({
                            url: aepro.ajaxurl,
                            dataType: 'json',
                            data: data,
                        
                            method: 'POST',
                            success: function (res) {
                                if (res.data) {
                                    if (res.data['field_type'] == 'color')
                                        $scope.css('background-color', res.data['value']);
                                }
                            
                            }
                        });
                    }
                }
            }
        }
        
    }   
     
    

    //Dynamic Background Image
    if ( $scope.data( 'ae-bg' ) ){
        $scope.css('background-image','url(' + $scope.data( 'ae-bg' ) + ')');
    }

    //Dynamic Background Color
    if ($scope.data('ae-bg-color')) {
        $scope.css('background-color', $scope.data( 'ae-bg-color' ));
    }

    // TODO:: Add BGSLIDER
    BgSliderHandler( $scope , $);

    if(elementorFrontend.isEditMode()){
        return;
    }

    if($scope.parents('.ae-carousel-yes').length > 0){
        return;
    }

    if($scope.parents('.facetwp-template ').length > 0 ) {
        return;
    }


    if ( $scope.data( 'ae-url' ) && $scope.hasClass('ae-link-yes') ){
        $scope.on('click', function (e) {
            if ( $scope.data( 'ae-url' ) && $scope.hasClass('ae-new-window-yes') ) {
                window.open($scope.data('ae-url'));
            }else{
                location.href = $scope.data('ae-url');
            }
        })
    }
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DynamicBgHandler);

( function( $ ) {

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/global', DynamicBgHandler);
    });
})(jQuery);

/***/ }),

/***/ 630:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(532);


(function($){
    const AeDynamicCalendar = ($scope, $) => {
        const settings = $scope.data('settings');
        const wid = $scope.data('id');
        const wclass = '.elementor-element-' + wid;
        const outer_wrapper = $scope.find('.ae-swiper-outer-wrapper');
        const calendar_wrapper = $scope.find('.ae-dc-wrapper');
        const calendar = $scope.find('.ae-dc-render');
        let listing = $scope.find('.ae-dc-listing');
        let post_date = calendar.find('.ae-dc-dates .ae-dc-post-date');

        const hidelist = (hideClass, listing, calendar) => {
            if (!listing.hasClass('no-posts')) {
                if (hideClass == 'hidden') {
                    listing.css('z-index', '10');
                    listing.css('opacity', '1');
                    if ($scope.hasClass('ae-dc-listing-align-overlap')) {
                        calendar.css('opacity', '0');
                    }
                    listing.removeClass('hidden');
                } else {
                    listing.css('opacity', '0');
                    listing.css('z-index', '1');
                    if ($scope.hasClass('ae-dc-listing-align-overlap')) {
                        calendar.css('opacity', '1');
                    }
                    listing.addClass('hidden');
                }
            }
        }

        if (elementorFrontend.isEditMode() || settings.listing_render == 'load') {
            if ($scope.find('.ae-outer-wrapper').hasClass('ae-carousel-yes')) {
                let carousel = listing.find('.dc-listing-item');
                let carouselHtml = '';
                $.each(carousel, function (i, val) {
                    carouselHtml = carouselHtml + val.outerHTML;
                });
                $scope.find('.dc-listing-container .ae-swiper-wrapper').html(carouselHtml);
                $scope.find('.dc-listing-container .ae-swiper-wrapper').find('.dc-listing-item').show();
                const swiper_settings = outer_wrapper.data('swiper-settings');
                
                //Swiper object destroyed if found.
                let mswiper = document.querySelector(wclass + ' .ae-swiper-container').swiper
                if (mswiper !== undefined) mswiper.destroy(true, true);
                
                //Carousel Initialize
                new _base__WEBPACK_IMPORTED_MODULE_0__/* .SwiperBase */ .Y(swiper_settings, wid);
            }
        }

        if (!elementorFrontend.isEditMode()) {
            if (settings.listing_render == 'click') {
                hidelist('', listing, calendar);
            }
        }

        jQuery(document).on('click', wclass + ' .ae-dc-dates .ae-dc-post-date', function (e) {
            const clostbtn = $scope.find('.ae-listing-close');
            listing = $scope.find('.ae-dc-listing');
            hidelist('hidden', listing, calendar);
            e.preventDefault();
            if ($scope.hasClass('ae-dc-listing-align-overlap')) {
                listing.css('z-index', '100');
                listing.show();
                clostbtn.on('click', function () {
                    hidelist('', listing, calendar);
                    listing.css('z-index', '8');
                });
            }
            if ($scope.find('.ae-outer-wrapper').hasClass('ae-carousel-yes')) {
                let carousel = listing.find('.dc-listing-item.ae-dc-' + $(this).data('dc-date'));
                let carouselHtml = '';
                $.each(carousel, function (i, val) {
                    carouselHtml = carouselHtml + val.outerHTML;
                });
                $scope.find('.dc-listing-container .ae-swiper-wrapper').html(carouselHtml);
                $scope.find('.dc-listing-container .ae-swiper-wrapper').find('.dc-listing-item.ae-dc-' + $(this).data('dc-date')).show();
                const swiper_settings = outer_wrapper.data('swiper-settings');
                
                //Swiper object destroyed if found.
                let mswiper = document.querySelector(wclass + ' .ae-swiper-container').swiper
                if (mswiper !== undefined) mswiper.destroy(true, true);
                
                //Carousel Initialize
                new _base__WEBPACK_IMPORTED_MODULE_0__/* .SwiperBase */ .Y(swiper_settings, wid);
            } else {
                listing.find('.dc-listing-item').hide();
                listing.find('.dc-listing-item.ae-dc-' + $(this).data('dc-date')).show();
            }

            if ($scope.hasClass('ae-dc-listing-align-overlap')) {
                let container = document.querySelector(wclass + ' .ae-swiper-container');
                let container_height = container.offsetHeight;
                //calendar_wrapper.css('height', container_height + 'px');
            }
            
        });
        
    };

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/ae-dynamic-calendar.skin_1', AeDynamicCalendar);
    });
})(jQuery);

/***/ }),

/***/ 242:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {

"use strict";

// EXTERNAL MODULE: ./src/js/html-map-marker.js
var html_map_marker = __webpack_require__(533);
// EXTERNAL MODULE: ./src/js/custom-overlay.js
var custom_overlay = __webpack_require__(742);
// EXTERNAL MODULE: ./src/js/base.js + 11 modules
var base = __webpack_require__(532);
// EXTERNAL MODULE: ./node_modules/fast-deep-equal/index.js
var fast_deep_equal = __webpack_require__(17);
var fast_deep_equal_default = /*#__PURE__*/__webpack_require__.n(fast_deep_equal);
;// CONCATENATED MODULE: ./node_modules/kdbush/index.js

const ARRAY_TYPES = [
    Int8Array, Uint8Array, Uint8ClampedArray, Int16Array, Uint16Array,
    Int32Array, Uint32Array, Float32Array, Float64Array
];

/** @typedef {Int8ArrayConstructor | Uint8ArrayConstructor | Uint8ClampedArrayConstructor | Int16ArrayConstructor | Uint16ArrayConstructor | Int32ArrayConstructor | Uint32ArrayConstructor | Float32ArrayConstructor | Float64ArrayConstructor} TypedArrayConstructor */

const VERSION = 1; // serialized format version
const HEADER_SIZE = 8;

class KDBush {

    /**
     * Creates an index from raw `ArrayBuffer` data.
     * @param {ArrayBuffer} data
     */
    static from(data) {
        if (!(data instanceof ArrayBuffer)) {
            throw new Error('Data must be an instance of ArrayBuffer.');
        }
        const [magic, versionAndType] = new Uint8Array(data, 0, 2);
        if (magic !== 0xdb) {
            throw new Error('Data does not appear to be in a KDBush format.');
        }
        const version = versionAndType >> 4;
        if (version !== VERSION) {
            throw new Error(`Got v${version} data when expected v${VERSION}.`);
        }
        const ArrayType = ARRAY_TYPES[versionAndType & 0x0f];
        if (!ArrayType) {
            throw new Error('Unrecognized array type.');
        }
        const [nodeSize] = new Uint16Array(data, 2, 1);
        const [numItems] = new Uint32Array(data, 4, 1);

        return new KDBush(numItems, nodeSize, ArrayType, data);
    }

    /**
     * Creates an index that will hold a given number of items.
     * @param {number} numItems
     * @param {number} [nodeSize=64] Size of the KD-tree node (64 by default).
     * @param {TypedArrayConstructor} [ArrayType=Float64Array] The array type used for coordinates storage (`Float64Array` by default).
     * @param {ArrayBuffer} [data] (For internal use only)
     */
    constructor(numItems, nodeSize = 64, ArrayType = Float64Array, data) {
        if (isNaN(numItems) || numItems < 0) throw new Error(`Unpexpected numItems value: ${numItems}.`);

        this.numItems = +numItems;
        this.nodeSize = Math.min(Math.max(+nodeSize, 2), 65535);
        this.ArrayType = ArrayType;
        this.IndexArrayType = numItems < 65536 ? Uint16Array : Uint32Array;

        const arrayTypeIndex = ARRAY_TYPES.indexOf(this.ArrayType);
        const coordsByteSize = numItems * 2 * this.ArrayType.BYTES_PER_ELEMENT;
        const idsByteSize = numItems * this.IndexArrayType.BYTES_PER_ELEMENT;
        const padCoords = (8 - idsByteSize % 8) % 8;

        if (arrayTypeIndex < 0) {
            throw new Error(`Unexpected typed array class: ${ArrayType}.`);
        }

        if (data && (data instanceof ArrayBuffer)) { // reconstruct an index from a buffer
            this.data = data;
            this.ids = new this.IndexArrayType(this.data, HEADER_SIZE, numItems);
            this.coords = new this.ArrayType(this.data, HEADER_SIZE + idsByteSize + padCoords, numItems * 2);
            this._pos = numItems * 2;
            this._finished = true;
        } else { // initialize a new index
            this.data = new ArrayBuffer(HEADER_SIZE + coordsByteSize + idsByteSize + padCoords);
            this.ids = new this.IndexArrayType(this.data, HEADER_SIZE, numItems);
            this.coords = new this.ArrayType(this.data, HEADER_SIZE + idsByteSize + padCoords, numItems * 2);
            this._pos = 0;
            this._finished = false;

            // set header
            new Uint8Array(this.data, 0, 2).set([0xdb, (VERSION << 4) + arrayTypeIndex]);
            new Uint16Array(this.data, 2, 1)[0] = nodeSize;
            new Uint32Array(this.data, 4, 1)[0] = numItems;
        }
    }

    /**
     * Add a point to the index.
     * @param {number} x
     * @param {number} y
     * @returns {number} An incremental index associated with the added item (starting from `0`).
     */
    add(x, y) {
        const index = this._pos >> 1;
        this.ids[index] = index;
        this.coords[this._pos++] = x;
        this.coords[this._pos++] = y;
        return index;
    }

    /**
     * Perform indexing of the added points.
     */
    finish() {
        const numAdded = this._pos >> 1;
        if (numAdded !== this.numItems) {
            throw new Error(`Added ${numAdded} items when expected ${this.numItems}.`);
        }
        // kd-sort both arrays for efficient search
        sort(this.ids, this.coords, this.nodeSize, 0, this.numItems - 1, 0);

        this._finished = true;
        return this;
    }

    /**
     * Search the index for items within a given bounding box.
     * @param {number} minX
     * @param {number} minY
     * @param {number} maxX
     * @param {number} maxY
     * @returns {number[]} An array of indices correponding to the found items.
     */
    range(minX, minY, maxX, maxY) {
        if (!this._finished) throw new Error('Data not yet indexed - call index.finish().');

        const {ids, coords, nodeSize} = this;
        const stack = [0, ids.length - 1, 0];
        const result = [];

        // recursively search for items in range in the kd-sorted arrays
        while (stack.length) {
            const axis = stack.pop() || 0;
            const right = stack.pop() || 0;
            const left = stack.pop() || 0;

            // if we reached "tree node", search linearly
            if (right - left <= nodeSize) {
                for (let i = left; i <= right; i++) {
                    const x = coords[2 * i];
                    const y = coords[2 * i + 1];
                    if (x >= minX && x <= maxX && y >= minY && y <= maxY) result.push(ids[i]);
                }
                continue;
            }

            // otherwise find the middle index
            const m = (left + right) >> 1;

            // include the middle item if it's in range
            const x = coords[2 * m];
            const y = coords[2 * m + 1];
            if (x >= minX && x <= maxX && y >= minY && y <= maxY) result.push(ids[m]);

            // queue search in halves that intersect the query
            if (axis === 0 ? minX <= x : minY <= y) {
                stack.push(left);
                stack.push(m - 1);
                stack.push(1 - axis);
            }
            if (axis === 0 ? maxX >= x : maxY >= y) {
                stack.push(m + 1);
                stack.push(right);
                stack.push(1 - axis);
            }
        }

        return result;
    }

    /**
     * Search the index for items within a given radius.
     * @param {number} qx
     * @param {number} qy
     * @param {number} r Query radius.
     * @returns {number[]} An array of indices correponding to the found items.
     */
    within(qx, qy, r) {
        if (!this._finished) throw new Error('Data not yet indexed - call index.finish().');

        const {ids, coords, nodeSize} = this;
        const stack = [0, ids.length - 1, 0];
        const result = [];
        const r2 = r * r;

        // recursively search for items within radius in the kd-sorted arrays
        while (stack.length) {
            const axis = stack.pop() || 0;
            const right = stack.pop() || 0;
            const left = stack.pop() || 0;

            // if we reached "tree node", search linearly
            if (right - left <= nodeSize) {
                for (let i = left; i <= right; i++) {
                    if (sqDist(coords[2 * i], coords[2 * i + 1], qx, qy) <= r2) result.push(ids[i]);
                }
                continue;
            }

            // otherwise find the middle index
            const m = (left + right) >> 1;

            // include the middle item if it's in range
            const x = coords[2 * m];
            const y = coords[2 * m + 1];
            if (sqDist(x, y, qx, qy) <= r2) result.push(ids[m]);

            // queue search in halves that intersect the query
            if (axis === 0 ? qx - r <= x : qy - r <= y) {
                stack.push(left);
                stack.push(m - 1);
                stack.push(1 - axis);
            }
            if (axis === 0 ? qx + r >= x : qy + r >= y) {
                stack.push(m + 1);
                stack.push(right);
                stack.push(1 - axis);
            }
        }

        return result;
    }
}

/**
 * @param {Uint16Array | Uint32Array} ids
 * @param {InstanceType<TypedArrayConstructor>} coords
 * @param {number} nodeSize
 * @param {number} left
 * @param {number} right
 * @param {number} axis
 */
function sort(ids, coords, nodeSize, left, right, axis) {
    if (right - left <= nodeSize) return;

    const m = (left + right) >> 1; // middle index

    // sort ids and coords around the middle index so that the halves lie
    // either left/right or top/bottom correspondingly (taking turns)
    kdbush_select(ids, coords, m, left, right, axis);

    // recursively kd-sort first half and second half on the opposite axis
    sort(ids, coords, nodeSize, left, m - 1, 1 - axis);
    sort(ids, coords, nodeSize, m + 1, right, 1 - axis);
}

/**
 * Custom Floyd-Rivest selection algorithm: sort ids and coords so that
 * [left..k-1] items are smaller than k-th item (on either x or y axis)
 * @param {Uint16Array | Uint32Array} ids
 * @param {InstanceType<TypedArrayConstructor>} coords
 * @param {number} k
 * @param {number} left
 * @param {number} right
 * @param {number} axis
 */
function kdbush_select(ids, coords, k, left, right, axis) {

    while (right > left) {
        if (right - left > 600) {
            const n = right - left + 1;
            const m = k - left + 1;
            const z = Math.log(n);
            const s = 0.5 * Math.exp(2 * z / 3);
            const sd = 0.5 * Math.sqrt(z * s * (n - s) / n) * (m - n / 2 < 0 ? -1 : 1);
            const newLeft = Math.max(left, Math.floor(k - m * s / n + sd));
            const newRight = Math.min(right, Math.floor(k + (n - m) * s / n + sd));
            kdbush_select(ids, coords, k, newLeft, newRight, axis);
        }

        const t = coords[2 * k + axis];
        let i = left;
        let j = right;

        swapItem(ids, coords, left, k);
        if (coords[2 * right + axis] > t) swapItem(ids, coords, left, right);

        while (i < j) {
            swapItem(ids, coords, i, j);
            i++;
            j--;
            while (coords[2 * i + axis] < t) i++;
            while (coords[2 * j + axis] > t) j--;
        }

        if (coords[2 * left + axis] === t) swapItem(ids, coords, left, j);
        else {
            j++;
            swapItem(ids, coords, j, right);
        }

        if (j <= k) left = j + 1;
        if (k <= j) right = j - 1;
    }
}

/**
 * @param {Uint16Array | Uint32Array} ids
 * @param {InstanceType<TypedArrayConstructor>} coords
 * @param {number} i
 * @param {number} j
 */
function swapItem(ids, coords, i, j) {
    swap(ids, i, j);
    swap(coords, 2 * i, 2 * j);
    swap(coords, 2 * i + 1, 2 * j + 1);
}

/**
 * @param {InstanceType<TypedArrayConstructor>} arr
 * @param {number} i
 * @param {number} j
 */
function swap(arr, i, j) {
    const tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp;
}

/**
 * @param {number} ax
 * @param {number} ay
 * @param {number} bx
 * @param {number} by
 */
function sqDist(ax, ay, bx, by) {
    const dx = ax - bx;
    const dy = ay - by;
    return dx * dx + dy * dy;
}

;// CONCATENATED MODULE: ./node_modules/supercluster/index.js



const defaultOptions = {
    minZoom: 0,   // min zoom to generate clusters on
    maxZoom: 16,  // max zoom level to cluster the points on
    minPoints: 2, // minimum points to form a cluster
    radius: 40,   // cluster radius in pixels
    extent: 512,  // tile extent (radius is calculated relative to it)
    nodeSize: 64, // size of the KD-tree leaf node, affects performance
    log: false,   // whether to log timing info

    // whether to generate numeric ids for input features (in vector tiles)
    generateId: false,

    // a reduce function for calculating custom cluster properties
    reduce: null, // (accumulated, props) => { accumulated.sum += props.sum; }

    // properties to use for individual points when running the reducer
    map: props => props // props => ({sum: props.my_value})
};

const fround = Math.fround || (tmp => ((x) => { tmp[0] = +x; return tmp[0]; }))(new Float32Array(1));

const OFFSET_ZOOM = 2;
const OFFSET_ID = 3;
const OFFSET_PARENT = 4;
const OFFSET_NUM = 5;
const OFFSET_PROP = 6;

class Supercluster {
    constructor(options) {
        this.options = Object.assign(Object.create(defaultOptions), options);
        this.trees = new Array(this.options.maxZoom + 1);
        this.stride = this.options.reduce ? 7 : 6;
        this.clusterProps = [];
    }

    load(points) {
        const {log, minZoom, maxZoom} = this.options;

        if (log) console.time('total time');

        const timerId = `prepare ${  points.length  } points`;
        if (log) console.time(timerId);

        this.points = points;

        // generate a cluster object for each point and index input points into a KD-tree
        const data = [];

        for (let i = 0; i < points.length; i++) {
            const p = points[i];
            if (!p.geometry) continue;

            const [lng, lat] = p.geometry.coordinates;
            const x = fround(lngX(lng));
            const y = fround(latY(lat));
            // store internal point/cluster data in flat numeric arrays for performance
            data.push(
                x, y, // projected point coordinates
                Infinity, // the last zoom the point was processed at
                i, // index of the source feature in the original input array
                -1, // parent cluster id
                1 // number of points in a cluster
            );
            if (this.options.reduce) data.push(0); // noop
        }
        let tree = this.trees[maxZoom + 1] = this._createTree(data);

        if (log) console.timeEnd(timerId);

        // cluster points on max zoom, then cluster the results on previous zoom, etc.;
        // results in a cluster hierarchy across zoom levels
        for (let z = maxZoom; z >= minZoom; z--) {
            const now = +Date.now();

            // create a new set of clusters for the zoom and index them with a KD-tree
            tree = this.trees[z] = this._createTree(this._cluster(tree, z));

            if (log) console.log('z%d: %d clusters in %dms', z, tree.numItems, +Date.now() - now);
        }

        if (log) console.timeEnd('total time');

        return this;
    }

    getClusters(bbox, zoom) {
        let minLng = ((bbox[0] + 180) % 360 + 360) % 360 - 180;
        const minLat = Math.max(-90, Math.min(90, bbox[1]));
        let maxLng = bbox[2] === 180 ? 180 : ((bbox[2] + 180) % 360 + 360) % 360 - 180;
        const maxLat = Math.max(-90, Math.min(90, bbox[3]));

        if (bbox[2] - bbox[0] >= 360) {
            minLng = -180;
            maxLng = 180;
        } else if (minLng > maxLng) {
            const easternHem = this.getClusters([minLng, minLat, 180, maxLat], zoom);
            const westernHem = this.getClusters([-180, minLat, maxLng, maxLat], zoom);
            return easternHem.concat(westernHem);
        }

        const tree = this.trees[this._limitZoom(zoom)];
        const ids = tree.range(lngX(minLng), latY(maxLat), lngX(maxLng), latY(minLat));
        const data = tree.data;
        const clusters = [];
        for (const id of ids) {
            const k = this.stride * id;
            clusters.push(data[k + OFFSET_NUM] > 1 ? getClusterJSON(data, k, this.clusterProps) : this.points[data[k + OFFSET_ID]]);
        }
        return clusters;
    }

    getChildren(clusterId) {
        const originId = this._getOriginId(clusterId);
        const originZoom = this._getOriginZoom(clusterId);
        const errorMsg = 'No cluster with the specified id.';

        const tree = this.trees[originZoom];
        if (!tree) throw new Error(errorMsg);

        const data = tree.data;
        if (originId * this.stride >= data.length) throw new Error(errorMsg);

        const r = this.options.radius / (this.options.extent * Math.pow(2, originZoom - 1));
        const x = data[originId * this.stride];
        const y = data[originId * this.stride + 1];
        const ids = tree.within(x, y, r);
        const children = [];
        for (const id of ids) {
            const k = id * this.stride;
            if (data[k + OFFSET_PARENT] === clusterId) {
                children.push(data[k + OFFSET_NUM] > 1 ? getClusterJSON(data, k, this.clusterProps) : this.points[data[k + OFFSET_ID]]);
            }
        }

        if (children.length === 0) throw new Error(errorMsg);

        return children;
    }

    getLeaves(clusterId, limit, offset) {
        limit = limit || 10;
        offset = offset || 0;

        const leaves = [];
        this._appendLeaves(leaves, clusterId, limit, offset, 0);

        return leaves;
    }

    getTile(z, x, y) {
        const tree = this.trees[this._limitZoom(z)];
        const z2 = Math.pow(2, z);
        const {extent, radius} = this.options;
        const p = radius / extent;
        const top = (y - p) / z2;
        const bottom = (y + 1 + p) / z2;

        const tile = {
            features: []
        };

        this._addTileFeatures(
            tree.range((x - p) / z2, top, (x + 1 + p) / z2, bottom),
            tree.data, x, y, z2, tile);

        if (x === 0) {
            this._addTileFeatures(
                tree.range(1 - p / z2, top, 1, bottom),
                tree.data, z2, y, z2, tile);
        }
        if (x === z2 - 1) {
            this._addTileFeatures(
                tree.range(0, top, p / z2, bottom),
                tree.data, -1, y, z2, tile);
        }

        return tile.features.length ? tile : null;
    }

    getClusterExpansionZoom(clusterId) {
        let expansionZoom = this._getOriginZoom(clusterId) - 1;
        while (expansionZoom <= this.options.maxZoom) {
            const children = this.getChildren(clusterId);
            expansionZoom++;
            if (children.length !== 1) break;
            clusterId = children[0].properties.cluster_id;
        }
        return expansionZoom;
    }

    _appendLeaves(result, clusterId, limit, offset, skipped) {
        const children = this.getChildren(clusterId);

        for (const child of children) {
            const props = child.properties;

            if (props && props.cluster) {
                if (skipped + props.point_count <= offset) {
                    // skip the whole cluster
                    skipped += props.point_count;
                } else {
                    // enter the cluster
                    skipped = this._appendLeaves(result, props.cluster_id, limit, offset, skipped);
                    // exit the cluster
                }
            } else if (skipped < offset) {
                // skip a single point
                skipped++;
            } else {
                // add a single point
                result.push(child);
            }
            if (result.length === limit) break;
        }

        return skipped;
    }

    _createTree(data) {
        const tree = new KDBush(data.length / this.stride | 0, this.options.nodeSize, Float32Array);
        for (let i = 0; i < data.length; i += this.stride) tree.add(data[i], data[i + 1]);
        tree.finish();
        tree.data = data;
        return tree;
    }

    _addTileFeatures(ids, data, x, y, z2, tile) {
        for (const i of ids) {
            const k = i * this.stride;
            const isCluster = data[k + OFFSET_NUM] > 1;

            let tags, px, py;
            if (isCluster) {
                tags = getClusterProperties(data, k, this.clusterProps);
                px = data[k];
                py = data[k + 1];
            } else {
                const p = this.points[data[k + OFFSET_ID]];
                tags = p.properties;
                const [lng, lat] = p.geometry.coordinates;
                px = lngX(lng);
                py = latY(lat);
            }

            const f = {
                type: 1,
                geometry: [[
                    Math.round(this.options.extent * (px * z2 - x)),
                    Math.round(this.options.extent * (py * z2 - y))
                ]],
                tags
            };

            // assign id
            let id;
            if (isCluster || this.options.generateId) {
                // optionally generate id for points
                id = data[k + OFFSET_ID];
            } else {
                // keep id if already assigned
                id = this.points[data[k + OFFSET_ID]].id;
            }

            if (id !== undefined) f.id = id;

            tile.features.push(f);
        }
    }

    _limitZoom(z) {
        return Math.max(this.options.minZoom, Math.min(Math.floor(+z), this.options.maxZoom + 1));
    }

    _cluster(tree, zoom) {
        const {radius, extent, reduce, minPoints} = this.options;
        const r = radius / (extent * Math.pow(2, zoom));
        const data = tree.data;
        const nextData = [];
        const stride = this.stride;

        // loop through each point
        for (let i = 0; i < data.length; i += stride) {
            // if we've already visited the point at this zoom level, skip it
            if (data[i + OFFSET_ZOOM] <= zoom) continue;
            data[i + OFFSET_ZOOM] = zoom;

            // find all nearby points
            const x = data[i];
            const y = data[i + 1];
            const neighborIds = tree.within(data[i], data[i + 1], r);

            const numPointsOrigin = data[i + OFFSET_NUM];
            let numPoints = numPointsOrigin;

            // count the number of points in a potential cluster
            for (const neighborId of neighborIds) {
                const k = neighborId * stride;
                // filter out neighbors that are already processed
                if (data[k + OFFSET_ZOOM] > zoom) numPoints += data[k + OFFSET_NUM];
            }

            // if there were neighbors to merge, and there are enough points to form a cluster
            if (numPoints > numPointsOrigin && numPoints >= minPoints) {
                let wx = x * numPointsOrigin;
                let wy = y * numPointsOrigin;

                let clusterProperties;
                let clusterPropIndex = -1;

                // encode both zoom and point index on which the cluster originated -- offset by total length of features
                const id = ((i / stride | 0) << 5) + (zoom + 1) + this.points.length;

                for (const neighborId of neighborIds) {
                    const k = neighborId * stride;

                    if (data[k + OFFSET_ZOOM] <= zoom) continue;
                    data[k + OFFSET_ZOOM] = zoom; // save the zoom (so it doesn't get processed twice)

                    const numPoints2 = data[k + OFFSET_NUM];
                    wx += data[k] * numPoints2; // accumulate coordinates for calculating weighted center
                    wy += data[k + 1] * numPoints2;

                    data[k + OFFSET_PARENT] = id;

                    if (reduce) {
                        if (!clusterProperties) {
                            clusterProperties = this._map(data, i, true);
                            clusterPropIndex = this.clusterProps.length;
                            this.clusterProps.push(clusterProperties);
                        }
                        reduce(clusterProperties, this._map(data, k));
                    }
                }

                data[i + OFFSET_PARENT] = id;
                nextData.push(wx / numPoints, wy / numPoints, Infinity, id, -1, numPoints);
                if (reduce) nextData.push(clusterPropIndex);

            } else { // left points as unclustered
                for (let j = 0; j < stride; j++) nextData.push(data[i + j]);

                if (numPoints > 1) {
                    for (const neighborId of neighborIds) {
                        const k = neighborId * stride;
                        if (data[k + OFFSET_ZOOM] <= zoom) continue;
                        data[k + OFFSET_ZOOM] = zoom;
                        for (let j = 0; j < stride; j++) nextData.push(data[k + j]);
                    }
                }
            }
        }

        return nextData;
    }

    // get index of the point from which the cluster originated
    _getOriginId(clusterId) {
        return (clusterId - this.points.length) >> 5;
    }

    // get zoom of the point from which the cluster originated
    _getOriginZoom(clusterId) {
        return (clusterId - this.points.length) % 32;
    }

    _map(data, i, clone) {
        if (data[i + OFFSET_NUM] > 1) {
            const props = this.clusterProps[data[i + OFFSET_PROP]];
            return clone ? Object.assign({}, props) : props;
        }
        const original = this.points[data[i + OFFSET_ID]].properties;
        const result = this.options.map(original);
        return clone && result === original ? Object.assign({}, result) : result;
    }
}

function getClusterJSON(data, i, clusterProps) {
    return {
        type: 'Feature',
        id: data[i + OFFSET_ID],
        properties: getClusterProperties(data, i, clusterProps),
        geometry: {
            type: 'Point',
            coordinates: [xLng(data[i]), yLat(data[i + 1])]
        }
    };
}

function getClusterProperties(data, i, clusterProps) {
    const count = data[i + OFFSET_NUM];
    const abbrev =
        count >= 10000 ? `${Math.round(count / 1000)  }k` :
        count >= 1000 ? `${Math.round(count / 100) / 10  }k` : count;
    const propIndex = data[i + OFFSET_PROP];
    const properties = propIndex === -1 ? {} : Object.assign({}, clusterProps[propIndex]);
    return Object.assign(properties, {
        cluster: true,
        cluster_id: data[i + OFFSET_ID],
        point_count: count,
        point_count_abbreviated: abbrev
    });
}

// longitude/latitude to spherical mercator in [0..1] range
function lngX(lng) {
    return lng / 360 + 0.5;
}
function latY(lat) {
    const sin = Math.sin(lat * Math.PI / 180);
    const y = (0.5 - 0.25 * Math.log((1 + sin) / (1 - sin)) / Math.PI);
    return y < 0 ? 0 : y > 1 ? 1 : y;
}

// spherical mercator to longitude/latitude
function xLng(x) {
    return (x - 0.5) * 360;
}
function yLat(y) {
    const y2 = (180 - y * 360) * Math.PI / 180;
    return 360 * Math.atan(Math.exp(y2)) / Math.PI - 90;
}

;// CONCATENATED MODULE: ./node_modules/@googlemaps/markerclusterer/dist/index.esm.js



/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

/**
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * util class that creates a common set of convenience functions to wrap
 * shared behavior of Advanced Markers and Markers.
 */
class MarkerUtils {
    static isAdvancedMarkerAvailable(map) {
        return (google.maps.marker &&
            map.getMapCapabilities().isAdvancedMarkersAvailable === true);
    }
    static isAdvancedMarker(marker) {
        return (google.maps.marker &&
            marker instanceof google.maps.marker.AdvancedMarkerElement);
    }
    static setMap(marker, map) {
        if (this.isAdvancedMarker(marker)) {
            marker.map = map;
        }
        else {
            marker.setMap(map);
        }
    }
    static getPosition(marker) {
        // SuperClusterAlgorithm.calculate expects a LatLng instance so we fake it for Adv Markers
        if (this.isAdvancedMarker(marker)) {
            if (marker.position) {
                if (marker.position instanceof google.maps.LatLng) {
                    return marker.position;
                }
                // since we can't cast to LatLngLiteral for reasons =(
                if (marker.position.lat && marker.position.lng) {
                    return new google.maps.LatLng(marker.position.lat, marker.position.lng);
                }
            }
            return new google.maps.LatLng(null);
        }
        return marker.getPosition();
    }
    static getVisible(marker) {
        if (this.isAdvancedMarker(marker)) {
            /**
             * Always return true for Advanced Markers because the clusterer
             * uses getVisible as a way to count legacy markers not as an actual
             * indicator of visibility for some reason. Even when markers are hidden
             * Marker.getVisible returns `true` and this is used to set the marker count
             * on the cluster. See the behavior of Cluster.count
             */
            return true;
        }
        return marker.getVisible();
    }
}

/**
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class Cluster {
    constructor({ markers, position }) {
        this.markers = markers;
        if (position) {
            if (position instanceof google.maps.LatLng) {
                this._position = position;
            }
            else {
                this._position = new google.maps.LatLng(position);
            }
        }
    }
    get bounds() {
        if (this.markers.length === 0 && !this._position) {
            return;
        }
        const bounds = new google.maps.LatLngBounds(this._position, this._position);
        for (const marker of this.markers) {
            bounds.extend(MarkerUtils.getPosition(marker));
        }
        return bounds;
    }
    get position() {
        return this._position || this.bounds.getCenter();
    }
    /**
     * Get the count of **visible** markers.
     */
    get count() {
        return this.markers.filter((m) => MarkerUtils.getVisible(m)).length;
    }
    /**
     * Add a marker to the cluster.
     */
    push(marker) {
        this.markers.push(marker);
    }
    /**
     * Cleanup references and remove marker from map.
     */
    delete() {
        if (this.marker) {
            MarkerUtils.setMap(this.marker, null);
            this.marker = undefined;
        }
        this.markers.length = 0;
    }
}

/**
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Returns the markers visible in a padded map viewport
 *
 * @param map
 * @param mapCanvasProjection
 * @param markers The list of marker to filter
 * @param viewportPaddingPixels The padding in pixel
 * @returns The list of markers in the padded viewport
 */
const filterMarkersToPaddedViewport = (map, mapCanvasProjection, markers, viewportPaddingPixels) => {
    const extendedMapBounds = extendBoundsToPaddedViewport(map.getBounds(), mapCanvasProjection, viewportPaddingPixels);
    return markers.filter((marker) => extendedMapBounds.contains(MarkerUtils.getPosition(marker)));
};
/**
 * Extends a bounds by a number of pixels in each direction
 */
const extendBoundsToPaddedViewport = (bounds, projection, numPixels) => {
    const { northEast, southWest } = latLngBoundsToPixelBounds(bounds, projection);
    const extendedPixelBounds = extendPixelBounds({ northEast, southWest }, numPixels);
    return pixelBoundsToLatLngBounds(extendedPixelBounds, projection);
};
/**
 * Gets the extended bounds as a bbox [westLng, southLat, eastLng, northLat]
 */
const getPaddedViewport = (bounds, projection, pixels) => {
    const extended = extendBoundsToPaddedViewport(bounds, projection, pixels);
    const ne = extended.getNorthEast();
    const sw = extended.getSouthWest();
    return [sw.lng(), sw.lat(), ne.lng(), ne.lat()];
};
/**
 * Returns the distance between 2 positions.
 *
 * @hidden
 */
const distanceBetweenPoints = (p1, p2) => {
    const R = 6371; // Radius of the Earth in km
    const dLat = ((p2.lat - p1.lat) * Math.PI) / 180;
    const dLon = ((p2.lng - p1.lng) * Math.PI) / 180;
    const sinDLat = Math.sin(dLat / 2);
    const sinDLon = Math.sin(dLon / 2);
    const a = sinDLat * sinDLat +
        Math.cos((p1.lat * Math.PI) / 180) *
            Math.cos((p2.lat * Math.PI) / 180) *
            sinDLon *
            sinDLon;
    const c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
    return R * c;
};
/**
 * Converts a LatLng bound to pixels.
 *
 * @hidden
 */
const latLngBoundsToPixelBounds = (bounds, projection) => {
    return {
        northEast: projection.fromLatLngToDivPixel(bounds.getNorthEast()),
        southWest: projection.fromLatLngToDivPixel(bounds.getSouthWest()),
    };
};
/**
 * Extends a pixel bounds by numPixels in all directions.
 *
 * @hidden
 */
const extendPixelBounds = ({ northEast, southWest }, numPixels) => {
    northEast.x += numPixels;
    northEast.y -= numPixels;
    southWest.x -= numPixels;
    southWest.y += numPixels;
    return { northEast, southWest };
};
/**
 * @hidden
 */
const pixelBoundsToLatLngBounds = ({ northEast, southWest }, projection) => {
    const sw = projection.fromDivPixelToLatLng(southWest);
    const ne = projection.fromDivPixelToLatLng(northEast);
    return new google.maps.LatLngBounds(sw, ne);
};

/**
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @hidden
 */
class AbstractAlgorithm {
    constructor({ maxZoom = 16 }) {
        this.maxZoom = maxZoom;
    }
    /**
     * Helper function to bypass clustering based upon some map state such as
     * zoom, number of markers, etc.
     *
     * ```typescript
     *  cluster({markers, map}: AlgorithmInput): Cluster[] {
     *    if (shouldBypassClustering(map)) {
     *      return this.noop({markers})
     *    }
     * }
     * ```
     */
    noop({ markers, }) {
        return noop(markers);
    }
}
/**
 * Abstract viewport algorithm proves a class to filter markers by a padded
 * viewport. This is a common optimization.
 *
 * @hidden
 */
class AbstractViewportAlgorithm extends AbstractAlgorithm {
    constructor(_a) {
        var { viewportPadding = 60 } = _a, options = __rest(_a, ["viewportPadding"]);
        super(options);
        this.viewportPadding = 60;
        this.viewportPadding = viewportPadding;
    }
    calculate({ markers, map, mapCanvasProjection, }) {
        if (map.getZoom() >= this.maxZoom) {
            return {
                clusters: this.noop({
                    markers,
                }),
                changed: false,
            };
        }
        return {
            clusters: this.cluster({
                markers: filterMarkersToPaddedViewport(map, mapCanvasProjection, markers, this.viewportPadding),
                map,
                mapCanvasProjection,
            }),
        };
    }
}
/**
 * @hidden
 */
const noop = (markers) => {
    const clusters = markers.map((marker) => new Cluster({
        position: MarkerUtils.getPosition(marker),
        markers: [marker],
    }));
    return clusters;
};

/**
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * The default Grid algorithm historically used in Google Maps marker
 * clustering.
 *
 * The Grid algorithm does not implement caching and markers may flash as the
 * viewport changes. Instead use {@link SuperClusterAlgorithm}.
 */
class GridAlgorithm extends AbstractViewportAlgorithm {
    constructor(_a) {
        var { maxDistance = 40000, gridSize = 40 } = _a, options = __rest(_a, ["maxDistance", "gridSize"]);
        super(options);
        this.clusters = [];
        this.state = { zoom: -1 };
        this.maxDistance = maxDistance;
        this.gridSize = gridSize;
    }
    calculate({ markers, map, mapCanvasProjection, }) {
        const state = { zoom: map.getZoom() };
        let changed = false;
        if (this.state.zoom >= this.maxZoom && state.zoom >= this.maxZoom) ;
        else {
            changed = !fast_deep_equal_default()(this.state, state);
        }
        this.state = state;
        if (map.getZoom() >= this.maxZoom) {
            return {
                clusters: this.noop({
                    markers,
                }),
                changed,
            };
        }
        return {
            clusters: this.cluster({
                markers: filterMarkersToPaddedViewport(map, mapCanvasProjection, markers, this.viewportPadding),
                map,
                mapCanvasProjection,
            }),
        };
    }
    cluster({ markers, map, mapCanvasProjection, }) {
        this.clusters = [];
        markers.forEach((marker) => {
            this.addToClosestCluster(marker, map, mapCanvasProjection);
        });
        return this.clusters;
    }
    addToClosestCluster(marker, map, projection) {
        let maxDistance = this.maxDistance; // Some large number
        let cluster = null;
        for (let i = 0; i < this.clusters.length; i++) {
            const candidate = this.clusters[i];
            const distance = distanceBetweenPoints(candidate.bounds.getCenter().toJSON(), MarkerUtils.getPosition(marker).toJSON());
            if (distance < maxDistance) {
                maxDistance = distance;
                cluster = candidate;
            }
        }
        if (cluster &&
            extendBoundsToPaddedViewport(cluster.bounds, projection, this.gridSize).contains(MarkerUtils.getPosition(marker))) {
            cluster.push(marker);
        }
        else {
            const cluster = new Cluster({ markers: [marker] });
            this.clusters.push(cluster);
        }
    }
}

/**
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Noop algorithm does not generate any clusters or filter markers by the an extended viewport.
 */
class NoopAlgorithm extends AbstractAlgorithm {
    constructor(_a) {
        var options = __rest(_a, []);
        super(options);
    }
    calculate({ markers, map, mapCanvasProjection, }) {
        return {
            clusters: this.cluster({ markers, map, mapCanvasProjection }),
            changed: false,
        };
    }
    cluster(input) {
        return this.noop(input);
    }
}

/**
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A very fast JavaScript algorithm for geospatial point clustering using KD trees.
 *
 * @see https://www.npmjs.com/package/supercluster for more information on options.
 */
class SuperClusterAlgorithm extends AbstractAlgorithm {
    constructor(_a) {
        var { maxZoom, radius = 60 } = _a, options = __rest(_a, ["maxZoom", "radius"]);
        super({ maxZoom });
        this.state = { zoom: -1 };
        this.superCluster = new Supercluster(Object.assign({ maxZoom: this.maxZoom, radius }, options));
    }
    calculate(input) {
        let changed = false;
        const state = { zoom: input.map.getZoom() };
        if (!fast_deep_equal_default()(input.markers, this.markers)) {
            changed = true;
            // TODO use proxy to avoid copy?
            this.markers = [...input.markers];
            const points = this.markers.map((marker) => {
                const position = MarkerUtils.getPosition(marker);
                const coordinates = [position.lng(), position.lat()];
                return {
                    type: "Feature",
                    geometry: {
                        type: "Point",
                        coordinates,
                    },
                    properties: { marker },
                };
            });
            this.superCluster.load(points);
        }
        if (!changed) {
            if (this.state.zoom <= this.maxZoom || state.zoom <= this.maxZoom) {
                changed = !fast_deep_equal_default()(this.state, state);
            }
        }
        this.state = state;
        if (changed) {
            this.clusters = this.cluster(input);
        }
        return { clusters: this.clusters, changed };
    }
    cluster({ map }) {
        return this.superCluster
            .getClusters([-180, -90, 180, 90], Math.round(map.getZoom()))
            .map((feature) => this.transformCluster(feature));
    }
    transformCluster({ geometry: { coordinates: [lng, lat], }, properties, }) {
        if (properties.cluster) {
            return new Cluster({
                markers: this.superCluster
                    .getLeaves(properties.cluster_id, Infinity)
                    .map((leaf) => leaf.properties.marker),
                position: { lat, lng },
            });
        }
        const marker = properties.marker;
        return new Cluster({
            markers: [marker],
            position: MarkerUtils.getPosition(marker),
        });
    }
}

/**
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * A very fast JavaScript algorithm for geospatial point clustering using KD trees.
 *
 * @see https://www.npmjs.com/package/supercluster for more information on options.
 */
class SuperClusterViewportAlgorithm extends AbstractViewportAlgorithm {
    constructor(_a) {
        var { maxZoom, radius = 60, viewportPadding = 60 } = _a, options = __rest(_a, ["maxZoom", "radius", "viewportPadding"]);
        super({ maxZoom, viewportPadding });
        this.superCluster = new Supercluster(Object.assign({ maxZoom: this.maxZoom, radius }, options));
        this.state = { zoom: -1, view: [0, 0, 0, 0] };
    }
    calculate(input) {
        const state = {
            zoom: Math.round(input.map.getZoom()),
            view: getPaddedViewport(input.map.getBounds(), input.mapCanvasProjection, this.viewportPadding),
        };
        let changed = !fast_deep_equal_default()(this.state, state);
        if (!fast_deep_equal_default()(input.markers, this.markers)) {
            changed = true;
            // TODO use proxy to avoid copy?
            this.markers = [...input.markers];
            const points = this.markers.map((marker) => {
                const position = MarkerUtils.getPosition(marker);
                const coordinates = [position.lng(), position.lat()];
                return {
                    type: "Feature",
                    geometry: {
                        type: "Point",
                        coordinates,
                    },
                    properties: { marker },
                };
            });
            this.superCluster.load(points);
        }
        if (changed) {
            this.clusters = this.cluster(input);
            this.state = state;
        }
        return { clusters: this.clusters, changed };
    }
    cluster({ map, mapCanvasProjection }) {
        /* recalculate new state because we can't use the cached version. */
        const state = {
            zoom: Math.round(map.getZoom()),
            view: getPaddedViewport(map.getBounds(), mapCanvasProjection, this.viewportPadding),
        };
        return this.superCluster
            .getClusters(state.view, state.zoom)
            .map((feature) => this.transformCluster(feature));
    }
    transformCluster({ geometry: { coordinates: [lng, lat], }, properties, }) {
        if (properties.cluster) {
            return new Cluster({
                markers: this.superCluster
                    .getLeaves(properties.cluster_id, Infinity)
                    .map((leaf) => leaf.properties.marker),
                position: { lat, lng },
            });
        }
        const marker = properties.marker;
        return new Cluster({
            markers: [marker],
            position: MarkerUtils.getPosition(marker),
        });
    }
}

/**
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Provides statistics on all clusters in the current render cycle for use in {@link Renderer.render}.
 */
class ClusterStats {
    constructor(markers, clusters) {
        this.markers = { sum: markers.length };
        const clusterMarkerCounts = clusters.map((a) => a.count);
        const clusterMarkerSum = clusterMarkerCounts.reduce((a, b) => a + b, 0);
        this.clusters = {
            count: clusters.length,
            markers: {
                mean: clusterMarkerSum / clusters.length,
                sum: clusterMarkerSum,
                min: Math.min(...clusterMarkerCounts),
                max: Math.max(...clusterMarkerCounts),
            },
        };
    }
}
class DefaultRenderer {
    /**
     * The default render function for the library used by {@link MarkerClusterer}.
     *
     * Currently set to use the following:
     *
     * ```typescript
     * // change color if this cluster has more markers than the mean cluster
     * const color =
     *   count > Math.max(10, stats.clusters.markers.mean)
     *     ? "#ff0000"
     *     : "#0000ff";
     *
     * // create svg url with fill color
     * const svg = window.btoa(`
     * <svg fill="${color}" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 240 240">
     *   <circle cx="120" cy="120" opacity=".6" r="70" />
     *   <circle cx="120" cy="120" opacity=".3" r="90" />
     *   <circle cx="120" cy="120" opacity=".2" r="110" />
     *   <circle cx="120" cy="120" opacity=".1" r="130" />
     * </svg>`);
     *
     * // create marker using svg icon
     * return new google.maps.Marker({
     *   position,
     *   icon: {
     *     url: `data:image/svg+xml;base64,${svg}`,
     *     scaledSize: new google.maps.Size(45, 45),
     *   },
     *   label: {
     *     text: String(count),
     *     color: "rgba(255,255,255,0.9)",
     *     fontSize: "12px",
     *   },
     *   // adjust zIndex to be above other markers
     *   zIndex: 1000 + count,
     * });
     * ```
     */
    render({ count, position }, stats, map) {
        // change color if this cluster has more markers than the mean cluster
        const color = count > Math.max(10, stats.clusters.markers.mean) ? "#ff0000" : "#0000ff";
        // create svg literal with fill color
        const svg = `<svg fill="${color}" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 240 240" width="50" height="50">
<circle cx="120" cy="120" opacity=".6" r="70" />
<circle cx="120" cy="120" opacity=".3" r="90" />
<circle cx="120" cy="120" opacity=".2" r="110" />
<text x="50%" y="50%" style="fill:#fff" text-anchor="middle" font-size="50" dominant-baseline="middle" font-family="roboto,arial,sans-serif">${count}</text>
</svg>`;
        const title = `Cluster of ${count} markers`, 
        // adjust zIndex to be above other markers
        zIndex = Number(google.maps.Marker.MAX_ZINDEX) + count;
        if (MarkerUtils.isAdvancedMarkerAvailable(map)) {
            // create cluster SVG element
            const parser = new DOMParser();
            const svgEl = parser.parseFromString(svg, "image/svg+xml").documentElement;
            svgEl.setAttribute("transform", "translate(0 25)");
            const clusterOptions = {
                map,
                position,
                zIndex,
                title,
                content: svgEl,
            };
            return new google.maps.marker.AdvancedMarkerElement(clusterOptions);
        }
        const clusterOptions = {
            position,
            zIndex,
            title,
            icon: {
                url: `data:image/svg+xml;base64,${btoa(svg)}`,
                anchor: new google.maps.Point(25, 25),
            },
        };
        return new google.maps.Marker(clusterOptions);
    }
}

/**
 * Copyright 2019 Google LLC. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Extends an object's prototype by another's.
 *
 * @param type1 The Type to be extended.
 * @param type2 The Type to extend with.
 * @ignore
 */
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function extend(type1, type2) {
    /* istanbul ignore next */
    // eslint-disable-next-line prefer-const
    for (let property in type2.prototype) {
        type1.prototype[property] = type2.prototype[property];
    }
}
/**
 * @ignore
 */
class OverlayViewSafe {
    constructor() {
        // MarkerClusterer implements google.maps.OverlayView interface. We use the
        // extend function to extend MarkerClusterer with google.maps.OverlayView
        // because it might not always be available when the code is defined so we
        // look for it at the last possible moment. If it doesn't exist now then
        // there is no point going ahead :)
        extend(OverlayViewSafe, google.maps.OverlayView);
    }
}

/**
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var MarkerClustererEvents;
(function (MarkerClustererEvents) {
    MarkerClustererEvents["CLUSTERING_BEGIN"] = "clusteringbegin";
    MarkerClustererEvents["CLUSTERING_END"] = "clusteringend";
    MarkerClustererEvents["CLUSTER_CLICK"] = "click";
})(MarkerClustererEvents || (MarkerClustererEvents = {}));
const defaultOnClusterClickHandler = (_, cluster, map) => {
    map.fitBounds(cluster.bounds);
};
/**
 * MarkerClusterer creates and manages per-zoom-level clusters for large amounts
 * of markers. See {@link MarkerClustererOptions} for more details.
 *
 */
class MarkerClusterer extends OverlayViewSafe {
    constructor({ map, markers = [], algorithmOptions = {}, algorithm = new SuperClusterAlgorithm(algorithmOptions), renderer = new DefaultRenderer(), onClusterClick = defaultOnClusterClickHandler, }) {
        super();
        this.markers = [...markers];
        this.clusters = [];
        this.algorithm = algorithm;
        this.renderer = renderer;
        this.onClusterClick = onClusterClick;
        if (map) {
            this.setMap(map);
        }
    }
    addMarker(marker, noDraw) {
        if (this.markers.includes(marker)) {
            return;
        }
        this.markers.push(marker);
        if (!noDraw) {
            this.render();
        }
    }
    addMarkers(markers, noDraw) {
        markers.forEach((marker) => {
            this.addMarker(marker, true);
        });
        if (!noDraw) {
            this.render();
        }
    }
    removeMarker(marker, noDraw) {
        const index = this.markers.indexOf(marker);
        if (index === -1) {
            // Marker is not in our list of markers, so do nothing:
            return false;
        }
        MarkerUtils.setMap(marker, null);
        this.markers.splice(index, 1); // Remove the marker from the list of managed markers
        if (!noDraw) {
            this.render();
        }
        return true;
    }
    removeMarkers(markers, noDraw) {
        let removed = false;
        markers.forEach((marker) => {
            removed = this.removeMarker(marker, true) || removed;
        });
        if (removed && !noDraw) {
            this.render();
        }
        return removed;
    }
    clearMarkers(noDraw) {
        this.markers.length = 0;
        if (!noDraw) {
            this.render();
        }
    }
    /**
     * Recalculates and draws all the marker clusters.
     */
    render() {
        const map = this.getMap();
        if (map instanceof google.maps.Map && map.getProjection()) {
            google.maps.event.trigger(this, MarkerClustererEvents.CLUSTERING_BEGIN, this);
            const { clusters, changed } = this.algorithm.calculate({
                markers: this.markers,
                map,
                mapCanvasProjection: this.getProjection(),
            });
            // Allow algorithms to return flag on whether the clusters/markers have changed.
            if (changed || changed == undefined) {
                // Accumulate the markers of the clusters composed of a single marker.
                // Those clusters directly use the marker.
                // Clusters with more than one markers use a group marker generated by a renderer.
                const singleMarker = new Set();
                for (const cluster of clusters) {
                    if (cluster.markers.length == 1) {
                        singleMarker.add(cluster.markers[0]);
                    }
                }
                const groupMarkers = [];
                // Iterate the clusters that are currently rendered.
                for (const cluster of this.clusters) {
                    if (cluster.marker == null) {
                        continue;
                    }
                    if (cluster.markers.length == 1) {
                        if (!singleMarker.has(cluster.marker)) {
                            // The marker:
                            // - was previously rendered because it is from a cluster with 1 marker,
                            // - should no more be rendered as it is not in singleMarker.
                            MarkerUtils.setMap(cluster.marker, null);
                        }
                    }
                    else {
                        // Delay the removal of old group markers to avoid flickering.
                        groupMarkers.push(cluster.marker);
                    }
                }
                this.clusters = clusters;
                this.renderClusters();
                // Delayed removal of the markers of the former groups.
                requestAnimationFrame(() => groupMarkers.forEach((marker) => MarkerUtils.setMap(marker, null)));
            }
            google.maps.event.trigger(this, MarkerClustererEvents.CLUSTERING_END, this);
        }
    }
    onAdd() {
        this.idleListener = this.getMap().addListener("idle", this.render.bind(this));
        this.render();
    }
    onRemove() {
        google.maps.event.removeListener(this.idleListener);
        this.reset();
    }
    reset() {
        this.markers.forEach((marker) => MarkerUtils.setMap(marker, null));
        this.clusters.forEach((cluster) => cluster.delete());
        this.clusters = [];
    }
    renderClusters() {
        // Generate stats to pass to renderers.
        const stats = new ClusterStats(this.markers, this.clusters);
        const map = this.getMap();
        this.clusters.forEach((cluster) => {
            if (cluster.markers.length === 1) {
                cluster.marker = cluster.markers[0];
            }
            else {
                // Generate the marker to represent the group.
                cluster.marker = this.renderer.render(cluster, stats, map);
                // Make sure all individual markers are removed from the map.
                cluster.markers.forEach((marker) => MarkerUtils.setMap(marker, null));
                if (this.onClusterClick) {
                    cluster.marker.addListener("click", 
                    /* istanbul ignore next */
                    (event) => {
                        google.maps.event.trigger(this, MarkerClustererEvents.CLUSTER_CLICK, cluster);
                        this.onClusterClick(event, cluster, map);
                    });
                }
            }
            MarkerUtils.setMap(cluster.marker, map);
        });
    }
}


//# sourceMappingURL=index.esm.js.map

;// CONCATENATED MODULE: ./src/js/dynamic-map.js




(function ($) {

    const DynamicMap = ($scope, $) => {
        
        if ($scope.find('.ae-dynamic-map-wrapper').length) {
            const wid = $scope.data('id');
            const wclass = '.elementor-element-' + wid;
            let settings = {};
            let map;
            let activeInfoWindow = false;
            let currentMarker;
            let marker_cluster = [];
            let animation;

            // Carousel
            if($scope.find('.ae-swiper-outer-wrapper').hasClass('ae-carousel-yes')) {
                const wid = $scope.data('id');
                const outer_wrapper = $scope.find('.ae-swiper-outer-wrapper');
                const swiper_settings = outer_wrapper.data('swiper-settings');
                new base/* SwiperBase */.Y(swiper_settings, wid);
            }

            //Map options
            if (typeof document.querySelector(wclass + ' .ae-dynamic-map-wrapper').dataset.map_options !== 'undefined') {
                settings = JSON.parse(document.querySelector(wclass + ' .ae-dynamic-map-wrapper').dataset.map_options);
            }

            //Listing marker interaction
            const marker_item = document.querySelectorAll(wclass + ' .ae-map-listing .ae-marker-item');
            if (settings['listing_marker_sync']) {
                marker_item.forEach(node => {
                    node.addEventListener('click', function (el) {
                        el.preventDefault();
                        marker_item.forEach(node => {
                            node.classList.remove('ae-marker-active');
                        });
                        el.currentTarget.classList.add('ae-marker-active');

                        var id = el.currentTarget.dataset.id;
                        var clicked_marker = map.markers[id];
                        if (settings['marker_click_action'] != 'post_link') {
                            google.maps.event.trigger(map.markers[id], 'click');
                        }

                        var divHeightOfTheMap = document.querySelector(wclass + ' .ae-map-render').clientHeight;
                        var offSetFromBottom = 100;
                        var offSetFromLeft = 0;
                        map.setCenter(clicked_marker.getPosition());
                        map.panBy(offSetFromLeft, -(divHeightOfTheMap / 2 - offSetFromBottom));

                        if (document.querySelector(wclass + ' .ae-responsive-btn')) {
                            if (document.querySelector(wclass + ' .ae-listing-responsive-mode-yes.' + document.querySelector('body').dataset.elementorDeviceMode)) {
                                let map_listing = document.querySelector(wclass + ' .ae-map-listing');
                                let map_render = document.querySelector(wclass + ' .ae-map-render');
                                let responsive_btn = document.querySelector(wclass + ' .ae-responsive-btn');
                                let responsive_btn_a = document.querySelector(wclass + ' .ae-responsive-btn a');

                                responsive_mode(responsive_btn_a, map_render, map_listing, responsive_btn);
                            }
                        }
                    });
                });
            }

            //Google Map
            if (document.querySelector(wclass + ' .ae-dynamic-map-wrapper').dataset.map_type === 'google_map') {
                // create marker
                const add_marker = ($marker_div, map) => {
                    const $marker = $marker_div.data('marker');
                    const latlng = new google.maps.LatLng($marker.lat, $marker.lng);
                    let icon = '<div class="ae-map-marker" id="temp"><img src="/wp-content/plugins/anywhere-elementor-pro/includes/assets/images/map-icon.png" /></div>';
                    animation = settings['markerAnimation'];
                    if (settings['marker_type'] === 'default') {
                        var marker = (0,html_map_marker/* default */.A)({
                            position: latlng,
                            map: map,
                            html: icon,
                            markerIndex: $marker.marker_index,
                            animation: animation,
                        });
                    } else {
                        if (settings['marker']['icon']) {
                            icon = settings['marker']['icon'];
                        }
                        if (settings['marker']['icon'] && settings['marker']['type'] === 'image') {
                            var marker = (0,html_map_marker/* default */.A)({
                                position: latlng,
                                map: map,
                                html: icon,
                                markerIndex: $marker.marker_index,
                                animation: animation,
                            });
                        } else if (settings['marker']['icon'] && (settings['marker']['type'] === 'icon' || settings['marker']['type'] === 'svg')) {
                            var marker = (0,html_map_marker/* default */.A)({
                                position: latlng,
                                map: map,
                                html: icon,
                                markerIndex: $marker.marker_index,
                                animation: animation,
                            });
                        } else if (settings['marker_type'] === 'dynamic' && settings['marker']['type'] === 'image') {
                            if ($marker.marker) {
                                icon = $marker.marker;
                            }
                             var marker = (0,html_map_marker/* default */.A)({
                                position: latlng,
                                map: map,
                                html: icon,
                                markerIndex: $marker.marker_index,
                                animation: animation,
                            });
                            
                        }
                    }

                    // add to array
                    map.markers.push(marker);

                    // add to cluster
                    marker_cluster[$marker.marker_index] = marker;

                    // if marker contains HTML, add it to an infoWindow
                    if ($marker_div.html()) {
                        // create info window

                        // show info window when marker is clicked
                        google.maps.event.addListener(marker, 'click', function (i) {
                           
                            if (settings['marker_click_action'] == 'info_window') {
                                const popup = document.querySelector(wclass + ' #infowindow_id_' + marker.markerIndex);
                                marker.removeAnimation(animation);
                                if (activeInfoWindow) {
                                    activeInfoWindow.style.display = 'none';
                                    if (marker != currentMarker) {
                                        currentMarker.addAnimation(animation);
                                    }
                                }
                                activeInfoWindow = popup;
                                currentMarker = marker;

                                popup.style.display = 'block';
                                popup.style.bottom = marker.div.offsetHeight + 15 + 'px';

                                var divHeightOfTheMap = document.querySelector(wclass + ' .ae-map-render').clientHeight;
                                var offSetFromBottom = 100;
                                var offSetFromLeft = 0;
                                
                                map.setCenter(marker.getPosition());
                                //map.setCenter(new google.maps.LatLng(marker.getPosition().lat(), map.getCenter().lng()));
                                map.panBy(offSetFromLeft, -(divHeightOfTheMap / 2 - offSetFromBottom));

                                $scope.find('.elementor-section').each(function () {
                                    elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
                                });

                                $scope.find('.elementor-column').each(function () {
                                    elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
                                });
                                
                                $scope.find('.elementor-widget').each(function () {
                                    elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
                                });

                                let iw_close_btn = document.querySelector(wclass + ' #infowindow_id_' + marker.markerIndex + ' .ae-infowindow-close-btn');
                                iw_close_btn.addEventListener('click', function () {
                                    popup.style.display = 'none';
                                    marker.addAnimation(animation);
                                    activeInfoWindow = false;
                                });
                            }

                            if (settings['marker_click_action'] == 'post_link') {
                                if ($marker.open_in_new_window == 'yes') {
                                    window.open($marker.post_link);
                                } else {
                                    window.location.href = $marker.post_link;
                                }
                            } else {

                                //Listing marker interaction
                                if (settings['listing_marker_sync']) {
                                    marker_item.forEach(node => {
                                        node.classList.remove('ae-marker-active');
                                    });

                                    if (document.querySelector(wclass + ' .ae-swiper-container')) {
                                        let $mswiper = document.querySelector(wclass + ' .ae-swiper-container').swiper;
                                        if (marker_item[marker.markerIndex]) {
                                            $mswiper.slideTo(marker.markerIndex);
                                            marker_item[marker.markerIndex].classList.add('ae-marker-active');
                                        }
                                    } else {
                                        if (marker_item[marker.markerIndex]) {
                                            marker_item[marker.markerIndex].classList.add('ae-marker-active');
                                            let scrollDiv = marker_item[marker.markerIndex].offsetTop;
                                            document.querySelector(wclass + ' .ae-map-listing').scrollTo({ top: scrollDiv, behavior: 'smooth' });
                                        }
                                    }
                                }
                            }

                            if (!activeInfoWindow) {
                                marker.toggleAnimation (animation);
                            }

                        });
                    }
                }

                const add_infowindow = ($marker_div, map) => {
                    const $marker = $marker_div.data('marker');
                    const latlng = new google.maps.LatLng($marker.lat, $marker.lng);
                    const CustomOverlay = (0,custom_overlay/* default */.A)({
                                position: latlng,
                                map: map,
                                html: '<div class="ae-map-infowindow" id="infowindow_id_' + $marker.marker_index + '"><div class="infowindow">' + $marker_div.html() + '</div><button class="ae-infowindow-close-btn" title="Close" type="button" class="gm-ui-hover-effect"><img src="data:image/svg+xml,%3Csvg%20xmlns%3D%22http%3A//www.w3.org/2000/svg%22%20viewBox%3D%220%200%2024%2024%22%3E%3Cpath%20d%3D%22M19%206.41L17.59%205%2012%2010.59%206.41%205%205%206.41%2010.59%2012%205%2017.59%206.41%2019%2012%2013.41%2017.59%2019%2019%2017.59%2013.41%2012z%22/%3E%3Cpath%20d%3D%22M0%200h24v24H0z%22%20fill%3D%22none%22/%3E%3C/svg%3E" alt=""></button></div>',
                                markerIndex: $marker.marker_index
                            })
                }

                const map_options = [
                    'backgroundColor',
                    'clickableIcons',
                    'disableDefaultUI',
                    'disableDoubleClickZoom',
                    'mapTypeId',
                    'zoom',
                    'mapTypeControl',
                    'streetViewControl',
                    'zoomControl',
                    'fullscreenControl',
                    'gestureHandling',
                    'scrollwheel',
                    //'styles'
                ];

                const new_map = ($el) => {
                    const $markers = $el.find('.marker');
                    const styles = $scope.find('.ae-map-render').data('map-style');
                    const args = {};

                    map_options.forEach(option => {
                        if (typeof settings[option] != "undefined") {
                            args[option] = settings[option];
                        }
                    
					});
					
					args['mapId'] = wid;

                    // create map
                    const map = new google.maps.Map($el[0], args);

                    // add a markers reference
                    map.markers = [];

                    // add markers
                    $markers.each(function () {
                        add_marker(jQuery(this), map);
                        add_infowindow(jQuery(this), map);
                    });

                    // center map
                    center_map(map, settings['zoom']);

                    // marker cluster
                    cluster(map);

                    // return
                    return map;
                }

                /* const cluster = (map) => {
                    var cluster_image = {
				        imagePath: 'https://developers.google.com/maps/documentation/javascript/examples/markerclusterer/m'
                    };
                    
                    if( 0 < marker_cluster.length && settings['markerCluster']) {
                        var markerCluster = new MarkerClusterer(
                            map,
                            marker_cluster,
                            cluster_image
                        );
                    }
				} */
				
				const cluster = (map) => {
					if (marker_cluster.length > 0 && settings['markerCluster']) {
						// Use the global MarkerClusterer from the loaded script
						new MarkerClusterer({
							map,
							markers: marker_cluster,
							// Optional: cluster options
							// renderer: ...
						});
					}
				}

                const center_map = (map, zoom) => {

                    // vars
                    var bounds = new google.maps.LatLngBounds();
                    // loop through all markers and create bounds
                    jQuery.each(map.markers, function (i, marker) {
                        var latlng = new google.maps.LatLng(marker.position.lat(), marker.position.lng());
                        bounds.extend(latlng);
                    });

                    // only 1 marker?
                    if (map.markers.length == 1) {
                        // set center of map
                        map.setCenter(bounds.getCenter());
                        map.setZoom(zoom);
                    }
                    else {
                        //map.setCenter(bounds.getCenter());
                        map.setCenter(map.markers[0].getPosition());
                        map.setZoom(zoom);
                        // fit to bounds
                        if (settings['auto_center'] == 'yes') {
                            map.fitBounds(bounds);
                        }
                    }
                }

                if ($scope.find('.ae-map-render').length) {
                    map = new_map($scope.find('.ae-map-render'));
                }

            }
           
            if (document.querySelector(wclass + ' .ae-responsive-btn')) {
                if (document.querySelector(wclass + ' .ae-listing-responsive-mode-yes.' + document.querySelector('body').dataset.elementorDeviceMode)) {

                    let map_wrapper = document.querySelector(wclass + ' .ae-dynamic-map-wrapper');

                    let map_render = document.querySelector(wclass + ' .ae-map-render');
                    let map_listing = document.querySelector(wclass + ' .ae-map-listing')
                    let responsive_btn = document.querySelector(wclass + ' .ae-responsive-btn');
                    let responsive_btn_a = document.querySelector(wclass + ' .ae-responsive-btn a');

                    let map_render_height = map_render.offsetHeight;
                    let responsive_btn_height = responsive_btn.offsetHeight;
                    let map_wrapper_height = map_render_height + responsive_btn_height;
                    map_listing.style.setProperty('height', map_render_height + 'px');

                    responsive_btn_a.addEventListener("click", function (e) {
                        e.preventDefault();
                        responsive_mode(this, map_render, map_listing, responsive_btn);
                    });
                }
            }

            const responsive_mode = ($this, map_render, map_listing, responsive_btn) => {
                if (responsive_btn.classList.contains('hide-list')) {
                    map_listing.style.setProperty('z-index', '10');
                    map_listing.style.setProperty('opacity', '1');
                    map_render.style.setProperty('opacity', '0');
                    responsive_btn.classList.remove('hide-list');
                    $this.innerHTML = $this.dataset.close_list_text;
                } else {
                    map_listing.style.setProperty('z-index', '1');
                    map_listing.style.setProperty('opacity', '0');
                    map_render.style.setProperty('opacity', '1');
                    responsive_btn.classList.add('hide-list');
                    $this.innerHTML = $this.dataset.show_list_text;
                }
            }
        }

        

    };

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/ae-dynamic-map.default', DynamicMap );
    });
})(jQuery);

/***/ }),

/***/ 533:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   A: () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const createHTMLMapMarker = ({ OverlayView = google.maps.OverlayView, ...args}) => {
  class HTMLMapMarker extends OverlayView {
    constructor() {
      super();
      this.position = args.position;
      this.html = args.html;
      this.markerIndex = args.markerIndex;
      this.animation = args.animation;
      this.setMap(args.map);
    }

    createDiv() {
      this.div = document.createElement("div");
      this.div.classList.add('ae-map-marker-icon-wrapper');
      this.div.style.position = "absolute";
      if (this.html) {
        this.div.innerHTML = this.html;
      }
      google.maps.event.addDomListener(this.div, "click", event => {
        google.maps.event.trigger(this, "click");
      });
    }

    appendDivToOverlay() {
      const panes = this.getPanes();
      panes.overlayImage.appendChild(this.div);
    }

    getPopup() {
      return document.querySelector('#infowindow-' + this.markerIndex);
    }

    positionDiv() {
      const point = this.getProjection().fromLatLngToDivPixel(this.position);
      //let offset = 50;
      if (point) {
        //this.div.style.left = `${point.x - 12}px`;
        //this.div.style.top = `${point.y - offset}px`;
        this.div.style.left = `${point.x}px`;
        this.div.style.top = `${point.y}px`;
      }
    }

    draw() {
      if (!this.div) {
        this.createDiv();
        this.appendDivToOverlay();
        this.addAnimation();
      }
      this.positionDiv();
    }

    addAnimation() {
      this.div.classList.add(this.animation);
    }

    removeAnimation() {
      this.div.classList.remove(this.animation);
    }

    toggleAnimation() {
      this.div.classList.toggle(this.animation);
    }

    remove() {
      if (this.div) {
        this.div.parentNode.removeChild(this.div);
        this.div = null;
      }
    }

    getPosition() {
      return this.position;
    }

    getDraggable() {
      return false;
	}
	  
	getVisible() {
   		return true;
  	}
  }

  return new HTMLMapMarker();
};

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createHTMLMapMarker);


/***/ }),

/***/ 443:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(532);


( function( $ ) {

    var PodsGallery = function ( $scope , $ ) {
        var $wrapper = $scope.find('.ae-grid-wrapper');
        if($scope.hasClass('ae-pods-gallery-carousel')) {
            const outer_wrapper = $scope.find('.ae-swiper-outer-wrapper');
            const wid = $scope.data('id');
            const swiper_settings = outer_wrapper.data('swiper-settings');

            new _base__WEBPACK_IMPORTED_MODULE_0__/* .SwiperBase */ .Y(swiper_settings, wid);
        }

        if($scope.hasClass('ae-pods-gallery-grid')) {
            if ($scope.find('.ae-grid-wrapper').hasClass('ae-masonry-yes')) {
                var grid = $scope.find('.ae-grid');
                var $grid_obj = grid.masonry({

                });

                $grid_obj.imagesLoaded().progress(function () {
                    $grid_obj.masonry('layout');
                });
            }

            if(!$wrapper.hasClass('ae-hover-direction-effect')) {
                $scope.find('.ae-grid-item').hover(function(){
                    $(this).find('.ae-grid-overlay').addClass('animated');
                });
            }
            if($wrapper.hasClass('ae-hover-direction-effect')){
                const  overlay_speed = parseInt($wrapper.attr('data-overlay-speed'));
                $scope.find('.ae-grid-item').hover(function () {
                    $(this).find('.ae-grid-overlay').addClass('aep-overlay');
                });
                $wrapper.find('.ae-grid-item' ).hoverdir({
                        speed: overlay_speed,
                        hoverElem : '.ae-grid-overlay'
                });
            };
        }
    };

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/ae-pods.file_gallery', PodsGallery );
    });

})( jQuery );

/***/ }),

/***/ 578:
/***/ (() => {

(function($){

    const PortfolioHandler = ( $scope , $ ) => {
        if($scope.find('.ae-post-widget-wrapper').hasClass('ae-masonry-yes')){
            var grid = $scope.find('.ae-post-list-wrapper');
            var $grid_obj = grid.masonry();

            $grid_obj.imagesLoaded().progress(function(){
                $grid_obj.masonry('layout');
            });
        }

        $scope.find('article.ae-post-list-item').css('opacity', '1');
    };

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/ae-portfolio.default', PortfolioHandler );
    });

})(jQuery);

/***/ }),

/***/ 566:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(532);
/* harmony import */ var _dynamic_bg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(207);



( function( $ ) {

    const PostBlocksAdvHandler = ($scope, $) => {

        const grid = $scope.find('.ae-post-list-wrapper');

        // Carousel
        if($scope.find('.ae-swiper-outer-wrapper').hasClass('ae-carousel-yes')) {
            const wid = $scope.data('id');
            const outer_wrapper = $scope.find('.ae-swiper-outer-wrapper');
            const swiper_settings = outer_wrapper.data('swiper-settings');
            new _base__WEBPACK_IMPORTED_MODULE_0__/* .SwiperBase */ .Y( swiper_settings, wid, $scope );
        }

        if(elementorFrontend.isEditMode()){
            
            $scope.find('.elementor-section').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });

            $scope.find('.elementor-column').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
			});
			
			$scope.find('.e-con').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });
        }


    }

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/ae-post-blocks-adv.carousel', 	PostBlocksAdvHandler );
    });


})(jQuery);

/***/ }),

/***/ 94:
/***/ (() => {

(function($){

    const PostBlockAdvAccordionHandler = ( $scope , $ ) => {
        const title = $scope.find('.ae-tab-title');
        const accordion_content = $scope.find('.ae-tab-content');
        const expand_button = $scope.find('.ae-accordion-toggle-button.expand');
        const collapse_button = $scope.find('.ae-accordion-toggle-button.collapse');
        const speed = $scope.find('.ae-accordion').data('transition-speed');
        let acc_status = 'start';
        (title).on('click',function (e) {
            e.preventDefault();
            collapse_button.removeClass('active');
            expand_button.removeClass('active');
            acc_status = 'start';
            const $this = $(this);
            if ($this.hasClass("ae-active")) {
                $this.removeClass("ae-active");
                $this.next().slideUp(speed);
            } else {
                $this
                    .parent()
                    .parent()
                    .find(".ae-tab-title")
                    .removeClass("ae-active");
                $this
                    .parent()
                    .parent()
                    .find(".ae-tab-content")
                    .slideUp(speed);
                $this.toggleClass("ae-active");
                $this.next().slideToggle(speed);
            }

            if ('undefined' !== typeof $this.data('hashtag')) {
                window.location.hash = $this.data('hashtag');
            }

            setTimeout(function () {
                /* Initialise ACF Gallery on Ajax */
                $this.siblings('.ae-tab-content').find('.elementor-widget-ae-acf-gallery').each(function () {
                    elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
                });
            }, 100);
        });
        (expand_button).on('click', function (e) {
            e.preventDefault();
            const $this = $(this);
            var role = $(this).data('role');
            if(acc_status == role){
                return;
            }else{
                acc_status = role;
                collapse_button.removeClass('active');
                $this.toggleClass('active');
                title.each(function(index,element){
                    $(element).addClass('ae-active');
                    var content = $(element).next();
                    content.slideDown(speed);
                    content.addClass('ae-active');
                });
            }
        });
        (collapse_button).on('click',function(e){
            e.preventDefault();
            const $this = $(this);
            var role = $(this).data('role');
            if(acc_status == role){
                return;
            } else {
                acc_status = role;
                expand_button.removeClass('active');
                $this.toggleClass('active');
                title.each(function (index, element) {
                    $(element).removeClass('ae-active'); 
                    var content = $(element).next();
                    content.slideUp(speed);
                    //content.removeClass('elementor-active');
                     
                });
            }
        });
        let $hashtag = window.location.hash.substring(1);
        if ($hashtag) {
            let $tab = title.filter('[data-hashtag="' + $hashtag + '"]');
            if ($tab.length > 0) {
                if (!$tab.hasClass('ae-active')) {
                    jQuery($tab).trigger('click');
                }
                let $tab_offset = parseInt(jQuery($tab).offset().top);
                jQuery('html, body').animate({
                    scrollTop: $tab_offset - 100
                }, 1000);

            }
        }

        if(elementorFrontend.isEditMode()){
            
            $scope.find('.elementor-section').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });

            $scope.find('.elementor-column').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
			});
			
			$scope.find('.e-con').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });
        }
    };

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/ae-post-blocks-adv.accordion',  PostBlockAdvAccordionHandler );
    });

})(jQuery);

/***/ }),

/***/ 86:
/***/ (() => {

(function ($) {
    
	let wid, wclass;
    const safariResize = ($scope) => {
        // Targetting collapsed images in pjax loading box (safari bug)
        let imgLoad = imagesLoaded($scope.find('.ae-element-post-image > .ae_thumb_wrapper img'));
        imgLoad.on('progress', function (instance, image) {
            if (image.isLoaded && image.img.height == 0) {
                var naturalH = image.img.naturalHeight,
                    naturalW = image.img.naturalWidth;
                if (image.img.parentElement.clientWidth < naturalW) {
                    var ratio = naturalH / naturalW;
                    naturalW = image.img.parentElement.clientWidth;
                    naturalH = naturalW * ratio;
                }
                image.img.setAttribute("style", "width: " + naturalW + "px; height: " + naturalH + "px; display:none;");
                $(image.img).fadeIn();
            }
        });
    };

    const _ias =  ( $scope , $, grid ) => {

        wid = $scope.data('id');
        wclass = '.elementor-element-' + wid;


        const ias = grid;
        let msnry = '';
        if($scope.find('.ae-outer-wrapper').hasClass('ae-masonry-yes')) {
            msnry = grid.data('masonry');
        }
        const $ias_obj = ias.infiniteScroll({
            path: '.next',
            append: wclass + ' .ae-post-item-' + wid,
            status: wclass + ' .scroller-status',
            hideNav: wclass + ' .ae-pagination-wrapper',
            outlayer: msnry,
            button: wclass + ' .view-more-button',
            history: $scope.find('.ae-outer-wrapper').data('ias-history'),
        });

        ias.on('append.infiniteScroll', function(event, response, path, items) {

            $scope.find('.ae-post-collection').find('.ae-cf-wrapper').each(function() {
                if ($(this).hasClass('hide')) {
                    $(this).closest('.elementor-widget-ae-custom-field').hide();
                }
            });

            /* EAE Modal Popup Widget compatibility on IAS ajax */

            /* if($scope.find('.eae-popup-link').length){

                const $close_btn = $scope.find('.eae-popup-wrapper').data('close-btn');

                const $magnific = $scope.find('.eae-popup-link').eaePopup({
                    type: 'inline',

                    mainClass: 'eae-popup eae-popup-' + $scope.find('.eae-popup-link').data('id') + ' eae-wrap-' + $scope.find('.eae-popup-link').data('ctrl-id'),

                    closeBtnInside: $scope.find('.eae-popup-wrapper').data('close-in-out'),

                    closeMarkup: '<i class="eae-close ' + $close_btn + '"> </i>',
                });

            } */
            /* EAE Modal Popup Widget compatibility on IAS ajax */

            if (navigator.userAgent.indexOf('Safari') != -1 && navigator.userAgent.indexOf('Chrome') == -1)  {
                safariResize($scope);
            } else if (navigator.userAgent.indexOf('iPad') != -1 && navigator.userAgent.indexOf('Chrome') == -1) {
                safariResize($scope);
            }

            if (navigator.userAgent.indexOf('Safari') != -1 || navigator.userAgent.indexOf('iPad') != -1 || navigator.userAgent.indexOf('iPhone') != -1 && navigator.userAgent.indexOf('Chrome') == -1){
				//var ias_image = $scope.find('.ae-post-list-wrapper').find('.wp-post-image');
				var ias_image = $scope.find('.ae-post-collection').find('img');
                ias_image.each(function (index, ias_image) {
                    ias_image.outerHTML = ias_image.outerHTML;
                });
            }

            let appendedPostItem = document.querySelectorAll('.ae-post-item');

            appendedPostItem.forEach(function (el) {
                el.classList.remove("appended");
            });
            items.forEach(function (el) {
                el.classList.add("appended");
            });
            /* Initialise ACF Gallery on Ajax */
           /*  $scope.find('.ae-post-item.appended .elementor-widget-ae-acf-gallery').each(function () {
                elementorFrontend.elementsHandler.runReadyTrigger($(this));
            }); */

			$scope.find('.ae-post-item.appended .e-con').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });

            $scope.find('.ae-post-item.appended .elementor-section').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });

            $scope.find('.ae-post-item.appended .elementor-column').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });
            
            $scope.find('.ae-post-item.appended .elementor-widget').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });
        });

        if($scope.find('.ae-outer-wrapper').hasClass('ae-ias-load-with-button-yes')) {
            var $viewMoreButton = $('.view-more-button');

            // get Infinite Scroll instance
            var infScroll = ias.data('infiniteScroll');

            ias.on('load.infiniteScroll', onPageLoad);
            var loadCount = $scope.find('.ae-outer-wrapper').data('load-offset-page');
            function onPageLoad() {
                if (infScroll.loadCount == loadCount) {
                    // after 2nd page loaded
                    // disable loading on scroll
                    ias.infiniteScroll('option', {
                        loadOnScroll: false,
                    });
                    // show button
                    $viewMoreButton.show();
                    // remove event listener
                    ias.off('load.infiniteScroll', onPageLoad);
                }
            }

            if (loadCount == 0) {
                ias.infiniteScroll('option', {
                    loadOnScroll: false,
                });
                // show button
                $viewMoreButton.show();
                // remove event listener
                var $scroller_status = $scope.find('.scroller-status');
                $scroller_status.hide();
                //ias.off('load.infiniteScroll', onPageLoad);
            }
        }

        ias.on( 'last.infiniteScroll', function( event, response, path ) {
            // parse JSON
            $scope.find('.load-more-wrapper').hide();
            // do something with JSON...
        });
    };

    const PostBlocksAdvHandler = ($scope, $) => {
		
		wid = $scope.data('id');
		wclass = '.elementor-element-' + wid;
		
        const grid = $scope.find('.ae-post-collection');
        // Masonry Layout
        if($scope.find('.ae-outer-wrapper').hasClass('ae-masonry-yes')){
             const $grid_obj = grid.masonry({
                 horizontalOrder: true
             });
             $grid_obj.imagesLoaded().progress(function(){
                 $grid_obj.masonry('layout');
             });

         }

        // Infinite Scroll
        const ias_grid = $scope.find('.ae-outer-wrapper[data-wid=' + wid + '] > .ae-post-collection');
        if ($scope.find('.ae-outer-wrapper').hasClass('ae-ias-yes')) {
            if ($scope.find('.ae-pagination-wrapper .page-numbers').length) {
                _ias($scope, $, ias_grid)
            }else{
                $scope.find('.scroller-status').hide();
                $scope.find('.load-more-wrapper').hide();
            }
        }

        /* Filter Dropdown item selected */
        var device_mode = jQuery('body').data('elementor-device-mode');

        //Elementor Editor
        if (elementorFrontend.isEditMode()) {
            device_mode = elementor.channels.deviceMode.request('currentMode');
            var filter = $scope.find('.aep-filter-bar.' + device_mode);
            $scope.find('.aep-filter-bar').hide();
            filter.show();
            elementor.channels.deviceMode.on('change', function(){
                device_mode = elementor.channels.deviceMode.request('currentMode');
                filter = $scope.find('.aep-filter-bar.' + device_mode);
                $scope.find('.aep-filter-bar').hide();
                filter.show();
            });
        }

        var filter_dropdown = $scope.find('.' + device_mode + ' .ae-dropdown');
        if (filter_dropdown.find('.ae-menu .filter-items.active').length) {
            var cur_term = filter_dropdown.find('.filter-items.active a').html();
            filter_dropdown.find('.dropdown-filter-text').html(cur_term);
            filter_dropdown.addClass('active');
        } else {
            var default_filter_text = filter_dropdown.find('.dropdown-filter-text').html();
            filter_dropdown.find('.dropdown-filter-text').html(default_filter_text);
        }

        if(elementorFrontend.isEditMode()){
            
            $scope.find('.elementor-section').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });

            $scope.find('.elementor-column').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
			});
			
			$scope.find('.e-con').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });
        }

        let $hashtag = window.location.hash.substring(1);
        if ($hashtag) {
            let device = jQuery('body').data('elementor-device-mode');
            let filter_dropdown = $scope.find('.' + device + ' .filter-items');
            let $tab = filter_dropdown.filter('[data-hashtag="' + $hashtag + '"]');
            if ($tab.length > 0) {
                if (!$tab.hasClass('ae-active')) {
                    jQuery($tab).find('a').trigger('click');
                }
                let $tab_offset = parseInt(jQuery($tab).offset().top);
                jQuery('html, body').animate({
                    scrollTop: $tab_offset - 100
                }, 1000);

            }
        }

    }

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/ae-post-blocks-adv.grid', 	PostBlocksAdvHandler );
    });




    $(document).on('click', '.facetwp-template.elementor-widget-ae-post-blocks-adv .ae-pagination-wrapper a', function(e) {
        e.preventDefault();
        var $this = jQuery(this);
        var wrapper = jQuery(this).closest('.ae-outer-wrapper');
        var ae_post_overlay = wrapper.siblings('.ae-post-overlay');
        ae_post_overlay.show();
        var matches = $this.attr('href').match(/\/page\/(\d+)/);
        if (null !== matches) {
            FWP.paged = parseInt(matches[1]);
            FWP.soft_refresh = true;
            FWP.refresh();
        } else {
            FWP.paged = 1;
            FWP.soft_refresh = true;
            FWP.refresh();
        }

    });

    if(jQuery('.ae-outer-wrapper').parents('.facetwp-template ').length > 0 ) {
        var facetWP_flag = false;
        $(document).on('facetwp-refresh', function() {
            var wrapper = jQuery('.ae-outer-wrapper');
            var ae_post_overlay = wrapper.siblings('.ae-post-overlay');
            ae_post_overlay.show();
        });
        $(document).on('facetwp-loaded', function () {
            var widget_wrapper = jQuery('.facetwp-template.elementor-widget-ae-post-blocks-adv');
            var wrapper = jQuery('.ae-outer-wrapper');
            var ae_post_overlay = wrapper.siblings('.ae-post-overlay');
            if(wrapper.data('item-reveal-animation') == 'yes') {
                ae_post_overlay.show();
                wrapper.removeClass('transit-in');
                wrapper.addClass('transit-out');
                setTimeout(function () {
                    wrapper.find('.ae-featured-bg-yes').each(function () {
                        img = jQuery(this).attr('data-ae-bg');
                        jQuery(this).css('background-image', 'url(' + img + ')');
                    });

                    if (wrapper.find('.ae-link-yes').data('ae-url')) {
                        wrapper.find('.ae-link-yes').on('click', function (e) {
                            if (jQuery(this).data('ae-url') && jQuery(this).hasClass('ae-new-window-yes')) {
                                window.open(jQuery(this).data('ae-url'));
                            } else {
                                location.href = jQuery(this).data('ae-url');
                            }
                        });
                    }

                    // hide black custom field widget wrapper
                    wrapper.find('.ae-cf-wrapper.hide').each(function () {
                        jQuery(this).closest('.elementor-widget-ae-custom-field').hide();
                    });

                    // reinitialize masonry
                    if (wrapper.hasClass('ae-masonry-yes')) {
                        var grid = wrapper.find('.ae-post-collection');
                        var $grid_obj = grid.masonry({
                            horizontalOrder: true
                        });

                        $grid_obj.imagesLoaded().progress(function () {
                            $grid_obj.masonry('layout');
                        });
                    }

                    wrapper.find('.elementor-invisible').each(function () {
                        // get settings
                        settings = jQuery(this).data('settings');
                        animation = settings.animation || settings._animation;

                        jQuery(this).removeClass('elementor-invisible').removeClass(animation).addClass(animation);

                    });

                    wrapper.find('article.ae-post-item').css('opacity', '1');
                    ae_post_overlay.hide();

                    var disable_scroll_on_ajax_load = wrapper.data('disable_scroll_on_ajax_load');
                    if (disable_scroll_on_ajax_load == 'no') {
                        if (facetWP_flag) {
                           var settings = widget_wrapper.data('settings');
                            pagination_scroll_top_offset = settings['grid_pagination_scroll_top_offset']['size'];
                            if (document.body.dataset.elementorDeviceMode != 'desktop') {
                                pagination_scroll_top_offset = settings['grid_pagination_scroll_top_offset_' + document.body.dataset.elementorDeviceMode]['size'];
                            }
                            //var pagination_scroll_top_offset = wrapper.data('pagination_scroll_top_offset');
                            var pagination_scroll_top_offset = pagination_scroll_top_offset
                            jQuery('html,body').animate({
                                    scrollTop: wrapper.offset().top - pagination_scroll_top_offset
                                },
                                'slow');
                        }
                    }

                    if (wrapper.find('.eae-popup-link').length) {

                        $close_btn = wrapper.find('.eae-popup-wrapper').data('close-btn');

                        $magnific = wrapper.find('.eae-popup-link').eaePopup({
                            type: 'inline',

                            mainClass: 'eae-popup eae-popup-' + wrapper.find('.eae-popup-link').data('id') + ' eae-wrap-' + wrapper.find('.eae-popup-link').data('ctrl-id'),

                            closeBtnInside: wrapper.find('.eae-popup-wrapper').data('close-in-out'),

                            closeMarkup: '<i class="eae-close ' + $close_btn + '"> </i>',
                        });

                    }
                    facetWP_flag = true;
                }, wrapper.data('overlay-animation-speed'));
                setTimeout(function () {
                    ae_post_overlay.hide();
                    wrapper.removeClass('transit-out');
                    wrapper.addClass('transit-in');
                }, wrapper.data('overlay-animation-speed'));
            }else{
                ae_post_overlay.show();
                wrapper.find('.ae-featured-bg-yes').each(function () {
                    img = jQuery(this).attr('data-ae-bg');
                    jQuery(this).css('background-image', 'url(' + img + ')');
                });

                if (wrapper.find('.ae-link-yes').data('ae-url')) {
                    wrapper.find('.ae-link-yes').on('click', function (e) {
                        if (jQuery(this).data('ae-url') && jQuery(this).hasClass('ae-new-window-yes')) {
                            window.open(jQuery(this).data('ae-url'));
                        } else {
                            location.href = jQuery(this).data('ae-url');
                        }
                    });
                }

                // hide black custom field widget wrapper
                wrapper.find('.ae-cf-wrapper.hide').each(function () {
                    jQuery(this).closest('.elementor-widget-ae-custom-field').hide();
                });

                // reinitialize masonry
                if (wrapper.hasClass('ae-masonry-yes')) {
                    var grid = wrapper.find('.ae-post-collection');
                    var $grid_obj = grid.masonry({
                        horizontalOrder: true
                    });

                    $grid_obj.imagesLoaded().progress(function () {
                        $grid_obj.masonry('layout');
                    });
                }

                wrapper.find('.elementor-invisible').each(function () {
                    // get settings
                    settings = jQuery(this).data('settings');
                    animation = settings.animation || settings._animation;

                    jQuery(this).removeClass('elementor-invisible').removeClass(animation).addClass(animation);

                });

                wrapper.find('article.ae-post-item').css('opacity', '1');

                var disable_scroll_on_ajax_load = wrapper.data('disable_scroll_on_ajax_load');
                if (disable_scroll_on_ajax_load == 'no') {
                    if (facetWP_flag) {
                        var settings = widget_wrapper.data('settings');
                        pagination_scroll_top_offset = settings['grid_pagination_scroll_top_offset']['size'];
                        if (document.body.dataset.elementorDeviceMode != 'desktop') {
                            pagination_scroll_top_offset = settings['grid_pagination_scroll_top_offset_' + document.body.dataset.elementorDeviceMode]['size'];
                        }
                        //var pagination_scroll_top_offset = wrapper.data('pagination_scroll_top_offset');
                        var pagination_scroll_top_offset = pagination_scroll_top_offset
                        jQuery('html,body').animate({
                                scrollTop: wrapper.offset().top - pagination_scroll_top_offset
                            },
                            'slow');
                    }
                }

                if (wrapper.find('.eae-popup-link').length) {

                    $close_btn = wrapper.find('.eae-popup-wrapper').data('close-btn');

                    $magnific = wrapper.find('.eae-popup-link').eaePopup({
                        type: 'inline',

                        mainClass: 'eae-popup eae-popup-' + wrapper.find('.eae-popup-link').data('id') + ' eae-wrap-' + wrapper.find('.eae-popup-link').data('ctrl-id'),

                        closeBtnInside: wrapper.find('.eae-popup-wrapper').data('close-in-out'),

                        closeMarkup: '<i class="eae-close ' + $close_btn + '"> </i>',
                    });

                }
                facetWP_flag = true;
                ae_post_overlay.hide();
            }
        });
    }

    //Search and Filter Pro
    if ($('.searchandfilter').length > 0) {
        $(document).on("sf:ajaxfinish", ".searchandfilter", function () {
            var wrapper = jQuery('.ae-outer-wrapper');

            // hide black custom field widget wrapper
            wrapper.find('.ae-cf-wrapper.hide').each(function () {
                jQuery(this).closest('.elementor-widget-ae-custom-field').hide();
            });

            // reinitialize masonry
            if (wrapper.hasClass('ae-masonry-yes')) {
                var grid = wrapper.find('.ae-post-collection');
                var $grid_obj = grid.masonry({
                    horizontalOrder: true
                });

                $grid_obj.imagesLoaded().progress(function () {
                    $grid_obj.masonry('layout');
                });
            }

            /* EAE Modal Popup Widget compatibility on post block ajax */

            if (wrapper.find('.eae-popup-link').length) {

                $close_btn = wrapper.find('.eae-popup-wrapper').data('close-btn');

                $magnific = wrapper.find('.eae-popup-link').eaePopup({
                    type: 'inline',

                    mainClass: 'eae-popup eae-popup-' + wrapper.find('.eae-popup-link').data('id') + ' eae-wrap-' + wrapper.find('.eae-popup-link').data('ctrl-id'),

                    closeBtnInside: wrapper.find('.eae-popup-wrapper').data('close-in-out'),

                    closeMarkup: '<i class="eae-close ' + $close_btn + '"> </i>',
                });

            }
            /* EAE Modal Popup Widget compatibility on post block ajax */

            wrapper.find('.elementor-section').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });

            wrapper.find('.elementor-column').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });
            
            wrapper.find('.elementor-widget').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
			});
			
			wrapper.find('.e-con').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });
        });
    }

})(jQuery);

/***/ }),

/***/ 402:
/***/ (() => {

(function($){

    const PostBlocksAdvTabsHandler = ( $scope, $ ) => {

        var defaultActiveTab = $scope.find( '.ae-post-blocks-adv-tabs' ).data( 'active-tab' ),
            $tabsTitles = $scope.find( '.ae-post-blocks-adv-tab-title' ),
            $tabs = $scope.find( '.ae-post-blocks-adv-tab-content' ),
            $active,
            $content;

        if ( ! defaultActiveTab ) {
            defaultActiveTab = 1;
        }

        const activateTab = ( tabIndex ) => {
            if ( $active ) {
                $active.removeClass( 'active' );
                $content.hide();
            }

            $active = $tabsTitles.filter( '[data-tab="' + tabIndex + '"]' );
            $active.addClass( 'active' );

            $content = $tabs.filter( '[data-tab="' + tabIndex + '"]' );
            $content.show();
        };

        activateTab( defaultActiveTab );
        $tabsTitles.on( 'click', function() {
            activateTab( this.dataset.tab );

            /* Initialise ACF Gallery on Ajax */
            $tabs.find('.elementor-widget-ae-acf-gallery').each(function () {
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });
        });

        if(elementorFrontend.isEditMode()){
            
            $scope.find('.elementor-section').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });

            $scope.find('.elementor-column').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
			});
			
			$scope.find('.e-con').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });
        }
    };

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/ae-post-blocks-adv.tabs',   PostBlocksAdvTabsHandler );
    });
})(jQuery);

/***/ }),

/***/ 241:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(532);
/* harmony import */ var _dynamic_bg__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(207);



( function( $ ) {

    const safariResize = ($scope) => {
        // Targetting collapsed images in pjax loading box (safari bug)
        let imgLoad = imagesLoaded( $scope.find('.ae-element-post-image > .ae_thumb_wrapper img') );
        imgLoad.on( 'progress', function( instance, image ) {
            if(image.isLoaded && image.img.height == 0){
                var naturalH = image.img.naturalHeight,
                    naturalW = image.img.naturalWidth;
                if( image.img.parentElement.clientWidth < naturalW ){
                    var ratio = naturalH / naturalW;
                    naturalW = image.img.parentElement.clientWidth;
                    naturalH = naturalW * ratio;
                }
                image.img.setAttribute("style","width: "+naturalW+"px; height: "+naturalH+"px; display:none;");
                $(image.img).fadeIn();
            }
        });
    }

    const _ias =  ( $scope , $, grid ) => {

        const wid = $scope.data('id');
        const wclass = '.elementor-element-' + wid;


        const ias = grid;
        let msnry = '';
        if($scope.find('.ae-post-widget-wrapper').hasClass('ae-masonry-yes')) {
            msnry = grid.data('masonry');
        }
        const $ias_obj = ias.infiniteScroll({
            path: '.next',
            append: wclass + ' .ae-post-list-item-' + wid,
            status: wclass + ' .scroller-status',
            hideNav: wclass + ' .ae-pagination-wrapper',
            outlayer: msnry,
            button: wclass + ' .view-more-button',
            history: $scope.find('.ae-post-widget-wrapper').data('ias-history'),
        });

        ias.on('append.infiniteScroll', function(event, response, path, items) {

            $scope.find('.ae-post-list-wrapper').find('.ae-cf-wrapper').each(function() {
                if ($(this).hasClass('hide')) {
                    $(this).closest('.elementor-widget-ae-custom-field').hide();
                }
            });

            /* EAE Modal Popup Widget compatibility on IAS ajax */

            /* if($scope.find('.eae-popup-link').length){

                const $close_btn = $scope.find('.eae-popup-wrapper').data('close-btn');

                const $magnific = $scope.find('.eae-popup-link').eaePopup({
                    type: 'inline',

                    mainClass: 'eae-popup eae-popup-' + $scope.find('.eae-popup-link').data('id') + ' eae-wrap-' + $scope.find('.eae-popup-link').data('ctrl-id'),

                    closeBtnInside: $scope.find('.eae-popup-wrapper').data('close-in-out'),

                    closeMarkup: '<i class="eae-close ' + $close_btn + '"> </i>',
                });

            } */
            /* EAE Modal Popup Widget compatibility on IAS ajax */

            if (navigator.userAgent.indexOf('Safari') != -1 && navigator.userAgent.indexOf('Chrome') == -1)  {
                safariResize($scope);
            } else if (navigator.userAgent.indexOf('iPad') != -1 && navigator.userAgent.indexOf('Chrome') == -1) {
                safariResize($scope);
            }

            if (navigator.userAgent.indexOf('Safari') != -1 || navigator.userAgent.indexOf('iPad') != -1 || navigator.userAgent.indexOf('iPhone') != -1 && navigator.userAgent.indexOf('Chrome') == -1){
				//var ias_image = $scope.find('.ae-post-list-wrapper').find('.wp-post-image');
				var ias_image = $scope.find('.ae-post-list-wrapper').find('img');
                ias_image.each(function (index, ias_image) {
                    ias_image.outerHTML = ias_image.outerHTML;
                });
            }

            let appendedPostItem = document.querySelectorAll('.ae-post-list-item');

            appendedPostItem.forEach(function (el) {
                el.classList.remove("appended");
            });
            items.forEach(function (el) {
                el.classList.add("appended");
            });
            /* Initialise ACF Gallery on Ajax */
           /*  $scope.find('.ae-post-list-item.appended .elementor-widget-ae-acf-gallery').each(function () {
                elementorFrontend.elementsHandler.runReadyTrigger($(this));
            }); */

            $scope.find('.ae-post-list-item.appended .elementor-section').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });

            $scope.find('.ae-post-list-item.appended .elementor-column').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });
            
            $scope.find('.ae-post-list-item.appended .elementor-widget').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
			});
			
			$scope.find('.ae-post-list-item.appended .e-con').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });

        });

        if($scope.find('.ae-post-widget-wrapper').hasClass('ae-ias-load-with-button-yes')) {
            var $viewMoreButton = $('.view-more-button');

            // get Infinite Scroll instance
            var infScroll = ias.data('infiniteScroll');

            ias.on('load.infiniteScroll', onPageLoad);
            var loadCount = $scope.find('.ae-post-widget-wrapper').data('load-offset-page') - 1;
            function onPageLoad() {
                if (infScroll.loadCount == loadCount) {
                    // after 2nd page loaded
                    // disable loading on scroll
                    ias.infiniteScroll('option', {
                        loadOnScroll: false,
                    });
                    // show button
                    $viewMoreButton.show();
                    // remove event listener
                    ias.off('load.infiniteScroll', onPageLoad);
                }
            }
        }

        ias.on( 'last.infiniteScroll', function( event, response, path ) {
            // parse JSON
            $scope.find('.load-more-wrapper').hide();
            // do something with JSON...
        });
    };

    const PostBlocksHandler = ($scope, $) => {

        const grid = $scope.find('.ae-post-list-wrapper');

        // Masonry Layout
        if($scope.find('.ae-post-widget-wrapper').hasClass('ae-masonry-yes')){
            const $grid_obj = grid.masonry({
                horizontalOrder: true
            });
            $grid_obj.imagesLoaded().progress(function(){
                $grid_obj.masonry('layout');
            });
        }

        // Infinite Scroll
        if ($scope.find('.ae-post-widget-wrapper').hasClass('ae-ias-yes')) {
            if ($scope.find('.ae-pagination-wrapper .page-numbers').length) {
                //_ias($scope, $, grid);
                _ias($scope, $, $scope.find('.ae-post-widget-wrapper > .ae-post-list-wrapper'));
            }else{
                $scope.find('.scroller-status').hide();
                $scope.find('.load-more-wrapper').hide();
            }
        }

        // Carousel
        if($scope.find('.ae-post-widget-wrapper').hasClass('ae-carousel-yes')) {
            const wid = $scope.data('id');
            const outer_wrapper = $scope.find('.ae-swiper-outer-wrapper');
            const swiper_settings = outer_wrapper.data('swiper-settings');
            new _base__WEBPACK_IMPORTED_MODULE_0__/* .SwiperBase */ .Y( swiper_settings, wid );
        }

        if(elementorFrontend.isEditMode()){
            
            $scope.find('.elementor-section').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });

            $scope.find('.elementor-column').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
			});
			
			$scope.find('.e-con').each(function(){
                elementorFrontend.elementsHandler.runReadyTrigger(jQuery(this));
            });
        }

    }

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/ae-post-blocks.default', 	PostBlocksHandler );
    });


})(jQuery);

/***/ }),

/***/ 382:
/***/ (() => {

(function($){

    var ContentUnfold = function ( $scope, $ ) {

        if($scope.find('.ae-element-post-content').hasClass('ae-post-content-unfold-yes')) {
            const postcontent = $scope.find('.ae-element-post-content');
            const postcontentinner = $scope.find('.ae-element-post-content-inner');
            const postcontentunfold = postcontent.find('.ae-post-content-unfold');
            const postcontentunfoldlink = postcontentunfold.find('.ae-post-content-unfold-link');
            let totalHeight = 0;
            totalHeight = postcontentinner.outerHeight();
            if(totalHeight){
                totalHeight += postcontentunfold.outerHeight();
            }
            if((postcontentinner.outerHeight() <= postcontentunfold.data('unfold-max-height')) && postcontentunfold.data('auto-hide-unfold') == 'yes' ){
                postcontentunfold.css({ 'display': 'none'});
            }else{
                postcontentunfoldlink.on( 'click', function() {
                    if(postcontentunfold.hasClass('fold')){
                        postcontent.css({ 'height': postcontent.outerHeight(), 'max-height': '100%' }).animate({ 'height': totalHeight }, {'duration': postcontentunfold.data('animation-speed')});
                        postcontentunfold.toggleClass('fold');
                        postcontentunfoldlink.html(postcontentunfold.data('fold-text'));
                    }else{
                        postcontent.css({ 'max-height': totalHeight }).animate({ 'max-height' : postcontentunfold.data('unfold-max-height') }, {'duration': postcontentunfold.data('animation-speed')});
                        postcontentunfold.toggleClass('fold');
                        postcontentunfoldlink.html(postcontentunfold.data('unfold-text'))
                    }

                });
            }
        }
    };

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/ae-post-content.default',    ContentUnfold );
    });

})(jQuery);

/***/ }),

/***/ 726:
/***/ (() => {

(function($){

    const PostImageHandler = ($scope , $ ) => {

        if($scope.find('.ae_thumb_wrapper').hasClass('ae_image_ratio_yes')) {

            const imageParent = $scope.find('.ae-post-image');
            const image = $scope.find('.ae-post-image img');

            const imageParentRatio = imageParent.outerHeight() / imageParent.outerWidth();
            const imageRatio = image.height() / image.width();

            if(imageRatio < imageParentRatio){
                imageParent.addClass( 'ae-post-image-fit' );
            }else{
                imageParent.removeClass( 'ae-post-image-fit' );
            }
        }
    };

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/ae-post-image.default',  PostImageHandler );
    });

})(jQuery);

/***/ }),

/***/ 766:
/***/ (() => {

(function ($) {
    
    var TriggerHandler = function (widget_target, $) {
        const $scope = $(widget_target);
        const settings = $scope.data('settings');
        
        if (typeof settings === "undefined") {
            return false;
        }

        let trigger_targets = settings.trigger_target.split(',');
        
        jQuery.each(trigger_targets, function (i, trigger_target) {
            //For Swiper: Carousels/Sliders
            let trigger_toggle = false;
            let wrapper = $scope.find('.ae-triggers');
            let button = $scope.find('.ae-trigger');
            Array.from(wrapper).forEach((el) => {
                const trigger_data = JSON.parse(el.dataset.trigger_settings);
                if (trigger_data.trigger_type == 'carousel') {
                    let $mswiper = document.querySelector('.elementor-element-' + trigger_target + ' .ae-swiper-container').swiper;
                    if ('undefined' === typeof $mswiper) {
                        return;
                    }
                    trigger_toggle = $mswiper.autoplay.running;
                    if (trigger_data.trigger_action == 'play_pause') {
                        if (trigger_toggle) {
                            trigger_toggle = false;
                            el.classList.add('active');
                            if ('undefined' !== typeof trigger_data.selected_icon_secondary) {
                                el.querySelector('.ae-trigger-icon i').classList.removeMany(trigger_data.selected_icon.value);
                                el.querySelector('.ae-trigger-icon i').classList.addMany(trigger_data.selected_icon_secondary.value);
                            }
                            if ('undefined' !== typeof trigger_data.secondary_text) {
                                el.setAttribute('title', trigger_data.secondary_text);
                                el.querySelector('.ae-trigger-text').innerHTML = trigger_data.secondary_text;
                            }
                        } else if (trigger_data.trigger_action == 'play_pause') {
                            el.classList.add('active');
                        } else if(trigger_data.trigger_action == 'pause_slide'){
                            el.classList.add('active');
                        }
                    }
                }
            });

            $scope.find('.ae-trigger').on('click', function (e) {

                e.preventDefault();
                const $this = $(this);
                const trigger_data = $this.parent('.ae-triggers').data('trigger_settings');
                if (trigger_data.trigger_type == 'carousel') {
                    $scope.find('.ae-triggers').removeClass('active');
                    $this.parent('.ae-triggers').addClass('active');
                    let $mswiper = document.querySelector('.elementor-element-' + trigger_target + ' .ae-swiper-container').swiper;
                    switch (trigger_data.trigger_action) {
                        case 'next_slide':
                            $mswiper.slideNext();
                            break;
                        case 'prev_slide':
                            $mswiper.slidePrev();
                            break;
                        case 'first_slide':
                            if ($mswiper.params.loop == 'yes') {
                                $mswiper.slideTo(3);
                            } else {
                                $mswiper.slideTo(0);
                            }
                            break;
                        case 'last_slide':
                            var totalSlides = $('.elementor-element-' + trigger_target + ' .ae-swiper-container .swiper-slide:not(.swiper-slide-duplicate)').length;
                            $mswiper.slideTo(totalSlides);
                            break;
                        case 'play_slide':
                            $mswiper.autoplay.start();
                            break;
                        case 'pause_slide':
                            $mswiper.autoplay.stop();
                            break;
                        case 'play_pause':
                            if (trigger_toggle) {
                                $mswiper.autoplay.stop();
                                trigger_toggle = false;
                                if ('undefined' !== typeof trigger_data.selected_icon_secondary) {
                                    $this.find('.ae-trigger-icon i').removeClass(trigger_data.selected_icon_secondary.value);
                                    $this.find('.ae-trigger-icon i').addClass(trigger_data.selected_icon.value);
                                }
                                if ('undefined' !== typeof trigger_data.text) {
                                    $this.attr('title', trigger_data.text);
                                    $this.find('.ae-trigger-text').html(trigger_data.text);
                                }
                            } else {
                                $mswiper.autoplay.start();
                                trigger_toggle = true;
                                if ('undefined' !== typeof trigger_data.selected_icon) {
                                    $this.find('.ae-trigger-icon i').removeClass(trigger_data.selected_icon.value);
                                    $this.find('.ae-trigger-icon i').addClass(trigger_data.selected_icon_secondary.value);
                                }
                                if ('undefined' !== typeof trigger_data.secondary_text) {
                                    $this.attr('title', trigger_data.secondary_text);
                                    $this.find('.ae-trigger-text').html(trigger_data.secondary_text);
                                }
                            }
                            break;
                        // code block
                    }
                }
            });


            //For Accordions
            const accordion = $('.elementor-element-' + trigger_target);
            const accordion_setting = accordion.data('settings');
            const widget_type = accordion.data('widget_type');
            let active_class = 'ae-active';
            if (widget_type === 'ae-acf-repeater.accordion') {
                active_class = 'elementor-active';
            }

            jQuery.each($scope.find('.ae-triggers'), function (i, item) {
                const trigger = jQuery(item);
                const trigger_data = trigger.data('trigger_settings');
                if (trigger_data.trigger_type == 'accordion') {
                    if (accordion_setting.accordion_accordion_state == 'all_open') {
                        if (trigger_data.trigger_action == 'expand') {
                            trigger.addClass('active');
                            trigger_toggle = true;
                        }
                    }
                    if (accordion_setting.accordion_accordion_state == 'all_closed') {
                        if (trigger_data.trigger_action == 'collapse') {
                            trigger.addClass('active');
                            trigger_toggle = false;
                        }
                    }
                    if ('undefined' !== typeof trigger_data.selected_icon_secondary) {
                        item.querySelector('.ae-trigger-icon i').classList.removeMany(trigger_data.selected_icon.value);
                        item.querySelector('.ae-trigger-icon i').classList.addMany(trigger_data.selected_icon_secondary.value);
                    }
                    if ('undefined' !== typeof trigger_data.secondary_text) {
                        item.setAttribute('title', trigger_data.secondary_text);
                        item.querySelector('.ae-trigger-text').innerHTML = trigger_data.secondary_text;
                    }
                }
            });

            $scope.find('.ae-trigger').on('click', function (e) {
                e.preventDefault();
                const $this = $(this);
                const trigger_data = $this.parent('.ae-triggers').data('trigger_settings');
                if (trigger_data.trigger_type == 'accordion') {
                    $scope.find('.ae-triggers').removeClass('active');
                    $this.parent('.ae-triggers').addClass('active');
                    const el_target = $('.elementor-element-' + trigger_target);
                    const title = $('.elementor-element-' + trigger_target + ' .ae-tab-title');
                    var content = $('.elementor-element-' + trigger_target + ' .ae-tab-content');
                    const speed = $scope.find('.ae-accordion').data('transition-speed');
                    switch (trigger_data.trigger_action) {
                        case 'expand_collapse':
                            if (trigger_toggle) {
                                title.each(function (index, element) {
                                    $(element).removeClass(active_class);
                                    var content = $(element).next();
                                    content.slideUp(speed);
                                });
                                trigger_toggle = false;
                                if ('undefined' !== typeof trigger_data.selected_icon_secondary) {
                                    $this.find('.ae-trigger-icon i').removeClass(trigger_data.selected_icon_secondary.value);
                                    $this.find('.ae-trigger-icon i').addClass(trigger_data.selected_icon.value);
                                }
                                if ('undefined' !== typeof trigger_data.text) {
                                    $this.attr('title', trigger_data.text);
                                    $this.find('.ae-trigger-text').html(trigger_data.text);
                                }
                            } else {
                                title.each(function (index, element) {
                                    $(element).addClass(active_class);
                                    var content = $(element).next();
                                    content.slideDown(speed);
                                    content.addClass(active_class);
                                });
                                trigger_toggle = true;
                                if ('undefined' !== typeof trigger_data.selected_icon) {
                                    $this.find('.ae-trigger-icon i').removeClass(trigger_data.selected_icon.value);
                                    $this.find('.ae-trigger-icon i').addClass(trigger_data.selected_icon_secondary.value);
                                }
                                if ('undefined' !== typeof trigger_data.secondary_text) {
                                    $this.attr('title', trigger_data.secondary_text);
                                    $this.find('.ae-trigger-text').html(trigger_data.secondary_text);
                                }
                            }
                            break;
                        case 'expand':
                            title.each(function (index, element) {
                                $(element).addClass(active_class);
                                var content = $(element).next();
                                content.slideDown(speed);
                                content.addClass(active_class);
                            });
                            break;
                        case 'collapse':
                            title.each(function (index, element) {
                                $(element).removeClass(active_class);
                                var content = $(element).next();
                                content.slideUp(speed);
                            });
                            break;
                        case 'next':
                            var tab = 0;
                            var current_title = title.parent().find('.ae-tab-title.' + active_class);
                            if (!current_title.length) {
                                tab = tab + 1;
                            } else {
                                tab = current_title.data('tab') + 1;
                            }
                            var next_title = el_target.find('.ae-tab-title[data-tab="' + tab + '"');

                            if (next_title.length) {
                                next_title.addClass(active_class);
                                next_title.next().slideDown(speed);
                                current_title.removeClass(active_class);
                                current_title.next().slideUp(speed);
                            }

                            break;
                        case 'prev':
                            var tab = 0;
                            var current_title = title.parent().find('.ae-tab-title.' + active_class);
                            if (!current_title.length) {
                                tab = title.length;
                            } else {
                                tab = current_title.data('tab') - 1;
                            }
                            var next_title = el_target.find('.ae-tab-title[data-tab="' + tab + '"');
                            if (next_title.length) {
                                next_title.addClass(active_class);
                                next_title.next().slideDown(speed);
                                current_title.removeClass(active_class);
                                current_title.next().slideUp(speed);
                            }
                        
                            break;
                        default:
                        // code block
                    }
                }
            });
        });
    };
    

    DOMTokenList.prototype.addMany = function(classes) {
        var array = classes.split(' ');
        for (var i = 0, length = array.length; i < length; i++) {
        this.add(array[i]);
        }
    }

    DOMTokenList.prototype.removeMany = function(classes) {
        var array = classes.split(' ');
        for (var i = 0, length = array.length; i < length; i++) {
        this.remove(array[i]);
        }
    }

    $(window).on('load', function () {
        const widget_triggers = $('.elementor-widget-ae-trigger');
        $.each(widget_triggers, function (i, widget_trigger) {
            TriggerHandler(widget_trigger, $);
        });
    });

})( jQuery );


/***/ }),

/***/ 504:
/***/ (() => {

(function($){

	const WooAddToCartHandler = ($scope, $) => {
		let cartQuantity = $scope.find('.ae-element-woo-add-to-cart .quantity input');
		cartQuantity.on('change', function () {
			let quantityVal = $(this).val();
			let addTooCartBtn = $(this).parent().siblings('.ae-element-woo-add-to-cart-btn');
			addTooCartBtn.attr('data-quantity', quantityVal);
		});
    };

	$(window).on('elementor/frontend/init', function () {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/ae-woo-add-to-cart.default', 	WooAddToCartHandler );
    });

})(jQuery);

/***/ }),

/***/ 484:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(532);


( function( $ ) {

    var WooProductCarousel = function ( $scope , $ ) {
        const outer_wrapper =  $scope.find('.ae-swiper-outer-wrapper');
        const wid = $scope.data('id');
        const swiper_settings = outer_wrapper.data('swiper-settings');

        new _base__WEBPACK_IMPORTED_MODULE_0__/* .SwiperBase */ .Y( swiper_settings, wid);
    };

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/ae-woo-products.carousel', 	 WooProductCarousel );
    });

})( jQuery );


/***/ }),

/***/ 608:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {

"use strict";
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(532);

(function($){

var WooProductImgeGallery = function ( $scope, $ ) {

    if($scope.parents('.elementor-editor-active').length){
        jQuery( '.woocommerce-product-gallery' ).each( function() {
            jQuery( this ).wc_product_gallery();
            wc_single_product_params.zoom_enabled = 0;
        } );
    }

    let outer_wrapper =  $scope.find('.ae-swiper-outer-wrapper');
    if(outer_wrapper.length){
        const wid = $scope.data('id');
        const swiper_settings = outer_wrapper.data('swiper-settings');
        new _base__WEBPACK_IMPORTED_MODULE_0__/* .SwiperBase */ .Y( swiper_settings, wid, $scope);
    }

};
    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/ae-woo-gallery.default', WooProductImgeGallery);
    });

})(jQuery);

/***/ }),

/***/ 599:
/***/ (() => {

(function($){
    const WooProductsGrid = ( $scope , $ ) => {

        if($scope.hasClass('ae-masonry-yes')){
            const grid = $scope.find('.ae-grid');
            const $grid_obj = grid.masonry({

            });

            $grid_obj.imagesLoaded().progress(function(){
                $grid_obj.masonry('layout');
            });

            $(window).resize(function(){
                // Todo:: Overlap on render mode
                //$grid_obj.masonry('layout');
            });
        }

        $scope.find('.ae-grid-item-inner').hover(function(){
            $(this).find('.ae-grid-overlay').addClass('animated');
        });
    };

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/ae-woo-products.grid',   WooProductsGrid );
    });

})(jQuery);

/***/ }),

/***/ 751:
/***/ (() => {

(function($){

    const WooRatingHandler = ( $scope, $ ) => {
        const ratinglink = $scope.find('.woocommerce-review-link');
        const tabsTitles = $( '.ae-woo-tab-title' );
        const tabs = $( '.ae-woo-tab-content' );

        ratinglink.on('click', function () {
            if(tabsTitles.length) {
                tabsTitles.removeClass('active');
                tabs.hide();
                tabsTitles.filter('[data-hashtag="reviews"]').addClass('active');
                tabs.filter('[data-hashtag="reviews"]').show();
            }
        })
    };

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/ae-woo-rating.default',  WooRatingHandler );
    });

})

/***/ }),

/***/ 6:
/***/ (() => {

(function($){

    const WooTabsHandler = ( $scope, $ ) => {

        var defaultActiveTab = $scope.find( '.ae-woo-tabs' ).data( 'active-tab' ),
            $tabsTitles = $scope.find( '.ae-woo-tab-title' ),
            $tabs = $scope.find( '.ae-woo-tab-content' ),
            $active,
            $content;

        if ( ! defaultActiveTab ) {
            defaultActiveTab = 1;
        }

        const activateTab = ( tabIndex ) => {
            if ( $active ) {
                $active.removeClass( 'active' );
                $content.hide();
            }

            $active = $tabsTitles.filter( '[data-tab="' + tabIndex + '"]' );
            $active.addClass( 'active' );

            $content = $tabs.filter( '[data-tab="' + tabIndex + '"]' );
            $content.show();
        };

        activateTab( defaultActiveTab );
        $tabsTitles.on( 'click', function() {
            activateTab( this.dataset.tab );
        });

        let $reviewtaglink = window.location.hash.substring(1);
        if($reviewtaglink === 'reviews'){
            let $reviewtab = $tabsTitles.filter('[data-hashtag="reviews"]' );
            activateTab( $reviewtab.data('tab') );
        }
    };

    $(window).on( 'elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction( 'frontend/element_ready/ae-woo-tabs.default', WooTabsHandler );
    });

})(jQuery);

/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/compat get default export */
/******/ 	(() => {
/******/ 		// getDefaultExport function for compatibility with non-harmony modules
/******/ 		__webpack_require__.n = (module) => {
/******/ 			var getter = module && module.__esModule ?
/******/ 				() => (module['default']) :
/******/ 				() => (module);
/******/ 			__webpack_require__.d(getter, { a: getter });
/******/ 			return getter;
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	__webpack_require__(532);
/******/ 	__webpack_require__(965);
/******/ 	__webpack_require__(23);
/******/ 	__webpack_require__(818);
/******/ 	__webpack_require__(652);
/******/ 	__webpack_require__(955);
/******/ 	__webpack_require__(852);
/******/ 	__webpack_require__(150);
/******/ 	__webpack_require__(453);
/******/ 	__webpack_require__(567);
/******/ 	__webpack_require__(245);
/******/ 	__webpack_require__(448);
/******/ 	__webpack_require__(127);
/******/ 	__webpack_require__(822);
/******/ 	__webpack_require__(410);
/******/ 	__webpack_require__(742);
/******/ 	__webpack_require__(591);
/******/ 	__webpack_require__(207);
/******/ 	__webpack_require__(630);
/******/ 	__webpack_require__(242);
/******/ 	__webpack_require__(533);
/******/ 	__webpack_require__(443);
/******/ 	__webpack_require__(578);
/******/ 	__webpack_require__(566);
/******/ 	__webpack_require__(94);
/******/ 	__webpack_require__(86);
/******/ 	__webpack_require__(402);
/******/ 	__webpack_require__(241);
/******/ 	__webpack_require__(382);
/******/ 	__webpack_require__(726);
/******/ 	__webpack_require__(766);
/******/ 	__webpack_require__(504);
/******/ 	__webpack_require__(484);
/******/ 	__webpack_require__(608);
/******/ 	__webpack_require__(599);
/******/ 	__webpack_require__(751);
/******/ 	var __webpack_exports__ = __webpack_require__(6);
/******/ 	
/******/ })()
;