<?php
namespace Aepro\Modules\TaxonomyBlocks\Skins;

use Aepro\Aepro;
use Aepro\Helper;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Skin_Classic extends Skin_Base {
	//phpcs:ignore PSR2.Methods.MethodDeclaration.Underscore
	protected function _register_controls_actions() {
		parent::_register_controls_actions(); // TODO: Change the autogenerated stub
		add_action( 'elementor/element/ae-taxonomy-blocks/section_layout/before_section_end', [ $this, 'register_controls' ] );
		add_action( 'elementor/element/ae-taxonomy-blocks/classic_section_overlay_style/after_section_end', [ $this, 'update_style_controls' ] );
		add_action( 'elementor/element/ae-taxonomy-blocks/classic_section_overlay_style/after_section_end', [ $this, 'remove_style_controls' ] );
	}

	public function get_id() {
		return 'classic';
	}

	public function get_title() {
		return __( 'Classic', 'ae-pro' );
	}

	public function register_controls( Widget_Base $widget ) {

		$this->parent = $widget;

		$this->layout_controls();
		$this->title_controls();
		$this->overlay_controls();
		$this->image_controls();
		$this->count_controls();

		$this->remove_responsive_control( 'block_min_height' );
	}
	public function register_style_controls() {
		parent::register_style_controls();

		$this->update_control(
			'title_background_color',
			[
				'default' => '#fff',
			]
		);

		$this->update_control(
			'title_align_vertical',
			[
				'options'      => [
					'top' => [
						'title' => __( 'Top', 'ae-pro' ),
						'icon'  => 'eicon-v-align-top',
					],
					'bottom' => [
						'title' => __( 'bottom', 'ae-pro' ),
						'icon'  => 'eicon-v-align-bottom',
					],
				],
				'default'      => 'bottom',
				'prefix_class' => 'caption-block-align-',
			]
		);

		$this->update_control(
			'title_align_horizontal',
			[
				'options' => [
					'left' => [
						'title' => __( 'Left', 'ae-pro' ),
						'icon'  => 'eicon-h-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'ae-pro' ),
						'icon'  => 'eicon-h-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'ae-pro' ),
						'icon'  => 'eicon-h-align-right',
					],
				],
			]
		);
	}

	public function update_style_controls() {

		$this->update_control(
			'title_typography_font_family',
			[
				'default' => 'Poppins',
			]
		);

		$this->update_control(
			'title_typography_font_size',
			[
				'default' => [
					'unit' => 'px',
					'size' => 18,
				],
			]
		);

		$this->update_control(
			'overlay_color',
			[
				'default' => 'rgba(0,0,0,0.16)',
			]
		);

		$this->update_responsive_control(
			'overlay_margin',
			[
				'default' => [
					'size' => 10,
				],
				'tablet_default' => [
					'size' => 5,
				],
			]
		);

		$this->update_responsive_control(
			'overlay_margin_hover',
			[
				'default' => [
					'size' => 0,
				],
				'tablet_default' => [
					'size' => 0,
				],
			]
		);

		$this->update_responsive_control(
			'overlay_opacity_hover',
			[
				'default' => [
					'size' => 0,
				],
			]
		);
	}

	public function remove_style_controls() {

		$this->remove_control( 'text_indent' );
	}

	public function render() {
		$settings = $this->parent->get_settings();
		$layout   = $settings['layout'];

		if ( $layout === '' || $layout === 'grid' ) {
			$this->render_grid();
		} elseif ( $layout === 'carousel' ) {
			$this->render_carousel();
		}
	}

	public function render_item( $term, $current_term, $layout) {
		
		if ( \Elementor\Plugin::instance()->editor->is_edit_mode() ) {
			if($term->term_id == $current_term){
				$class = ['ae-term-active', 'ae-term-list-item'];
				if($layout == 'carousel'){
					$carousel_class = ['ae-swiper-slide', 'swiper-slide'];
					$class = array_merge($class, $carousel_class); 
				}
				$this->parent->set_render_attribute( 'term-list-item', 'class', $class );
			}else{
				$class = ['ae-term-list-item'];
				if($layout == 'carousel'){
					$carousel_class = ['ae-swiper-slide', 'swiper-slide'];
					$class = array_merge($class, $carousel_class); 
				}
				$this->parent->set_render_attribute( 'term-list-item', 'class', $class);
			}
		}else{
			if(is_archive()){
				if($term->term_id === $current_term){
					$class = ['ae-term-active', 'ae-term-list-item'];
					if($layout == 'carousel'){
						$carousel_class = ['ae-swiper-slide', 'swiper-slide'];
						$class = array_merge($class, $carousel_class); 
					}
					$this->parent->set_render_attribute( 'term-list-item', 'class', $class );
				}else{
					$class = ['ae-term-list-item'];
					if($layout == 'carousel'){
						$carousel_class = ['ae-swiper-slide', 'swiper-slide'];
						$class = array_merge($class, $carousel_class); 
					}
					$this->parent->set_render_attribute( 'term-list-item', 'class', $class);
				}
			}else{
				$class = ['ae-term-list-item'];
				if($layout == 'carousel'){
					$carousel_class = ['ae-swiper-slide', 'swiper-slide'];
					$class = array_merge($class, $carousel_class); 
				}
				$this->parent->set_render_attribute( 'term-list-item', 'class', $class);
			}
		}	
		
		$image = '';
		if ( $this->get_instance_value( 'show_image' ) === 'yes' ) {
			$img_size = $this->get_instance_value( 'ae_taxonomy_image_size' );
			if ( $this->get_instance_value( 'image_type' ) === 'custom_field' ) {
				$img = wp_get_attachment_image_src( get_term_meta( $term->term_id, $this->get_instance_value( 'ae_taxonomy_bg_cf_field_key' ), true ), $img_size );
				if ( is_array( $img ) ) {
					$image = $img[0];
				} else {
					$img   = $this->get_instance_value( 'cf_taxonomy_image_fallback' );
					$image = $img['url'];
				}
			} else {
				$img   = $this->get_instance_value( 'taxonomy_image' );
				$image = $img['url'];
			}
		}

		?>

		<div <?php echo $this->parent->get_render_attribute_string( 'term-list-item' ); ?>>
			<div <?php echo $this->parent->get_render_attribute_string( 'term-list-item-inner' ); ?>>
				<?php
				$this->parent->set_render_attribute( 'term-image-wrapper', 'class', 'ae-term-image-wrapper' );
				if ( $image !== '' ) {
					?>
					<div <?php echo $this->parent->get_render_attribute_string( 'term-image-wrapper' ); ?>>
						<div class="ae-post-image">
							<img src="<?php echo $image; ?>"/>
						</div>
						<div class="term-overlay"></div>
					</div>
					<?php
				}

				$title_html = '';
				$this->parent->set_render_attribute( 'term-title-wrapper', 'class', 'ae-term-title-wrapper' );
				$title_html .= '<div ' . $this->parent->get_render_attribute_string( 'term-title-wrapper' ) . '>';
				if ( $this->get_instance_value( 'show_title' ) === 'yes' ) {
					$this->parent->set_render_attribute( 'term-title-class', 'class', 'ae-element-term-title' );
					$term_title = $term->name;
					if ( $this->get_instance_value( 'strip_title' ) === 'yes' ) {
						if ( $this->get_instance_value( 'strip_mode' ) === 'word' ) {
							$term_title = wp_trim_words( $term_title, $this->get_instance_value( 'strip_size' ), $this->get_instance_value( 'strip_append' ) );
						} else {
							$term_title = rtrim( substr( $term_title, 0, $this->get_instance_value( 'strip_size' ) ) ) . $this->get_instance_value( 'strip_append' );
						}
					}
					if ( $this->get_instance_value( 'enable_title_link' ) === 'yes' ) {
						if ( $this->get_instance_value( 'title_new_tab' ) === 'yes' ) {
							$this->parent->set_render_attribute( 'term-link-class', 'target', '_blank' );
						}
						$title_html .= '<a ' . $this->parent->get_render_attribute_string( 'term-link-class' ) . ' href="' . esc_url( get_term_link( $term ) ) . '">';
					}
					if ( $this->get_instance_value( 'show_count' ) === 'yes' ) {
						$term_title .= ' (' . $term->count . ')';
					}
					$title_html .= sprintf( '<%1$s itemprop="name" %2$s>%3$s</%1$s>', $this->get_instance_value( 'html_tag' ), $this->parent->get_render_attribute_string( 'term-title-class' ), $term_title );

					if ( $this->get_instance_value( 'enable_title_link' ) === 'yes' ) {
						$title_html .= '</a>';
					}
				}
				$title_html .= '</div>';
				echo $title_html;
				?>
				<?php
				if ( $this->get_instance_value( 'overlay_enable_link' ) === 'yes' ) {
					$this->parent->set_render_attribute( 'term-overlay-link', 'class', 'overlay-link' );
					$this->parent->set_render_attribute( 'term-overlay-link', 'href', esc_url( get_term_link( $term ) ) );
					if ( $this->get_instance_value( 'overlay_link_new_tab' ) === 'yes' ) {
						$this->parent->set_render_attribute( 'term-overlay-link', 'target', '_blank' );
					}
					?>
					<a <?php echo $this->parent->get_render_attribute_string( 'term-overlay-link' ); ?>></a>
				<?php } ?>
			</div>
		</div>

		<?php
	}
}
