<?php

namespace Aepro\Modules\PodsFields\Skins;

use Aepro\Modules\PodsFields;
use Aepro\Classes\PodsMaster;
use Aepro\Helper;
use Elementor\Icons_Manager;
use Aepro\Base\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Core\Kits\Documents\Tabs\Global_Typography;
use Elementor\Core\Kits\Documents\Tabs\Global_Colors;


class Skin_Text_Area extends Skin_Text {

	public function get_id() {
		return 'text-area';
	}

	public function get_title() {
		return __( 'Text Area', 'ae-pro' );
	}
    //phpcs:ignore PSR2.Methods.MethodDeclaration.Underscore
	protected function _register_controls_actions() {

		parent::_register_controls_actions();
		add_action( 'elementor/element/ae-pods/general/after_section_end', [ $this, 'add_unfold_section' ] );
		add_action( 'elementor/element/ae-pods/general/after_section_end', [ $this, 'manage_controls' ] );
	}

	public function manage_controls() {

		$this->remove_control( 'prefix' );
		$this->remove_control( 'suffix' );
		$this->remove_control( 'links_to' );
	}

	public function register_style_controls() {
		parent::register_style_controls(); // TODO: Change the autogenerated stub

		$helper = new Helper();

		$this->start_controls_section(
			'section_unfold_style',
			[
				'label'     => __( 'Unfold', 'ae-pro' ),
				'tab'       => Controls_Manager::TAB_STYLE,
				'condition' => [
					$this->get_control_id( 'enable_unfold' ) => 'yes',
				],
			]
		);
		$this->add_responsive_control(
			'unfold_max_height',
			[
				'label'     => __( 'Max Height', 'ae-pro' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min'  => 0,
						'max'  => 500,
						'step' => 1,
					],
				],
				'default'   => [
					'size' => 200,
				],
				'selectors' => [
					'{{WRAPPER}} .ae-acf-wrapper.ae-acf-unfold-yes' => 'max-height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'unfold_color',
			[
				'label'     => __( 'Background Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'global'    => [
					'default' => Global_Colors::COLOR_TEXT,
				],
				'selectors' => [
					'{{WRAPPER}} .ae-acf-unfold' => 'background-image: linear-gradient(to bottom, transparent, {{VALUE}});',
				],
			]
		);

		$this->add_control(
			'unfold_button_settings_heading',
			[
				'label'     => __( 'Button', 'ae-pro' ),
				'type'      => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'unfold_button_typography',
				'global'   => [
					'default' => Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .ae-acf-wrapper .ae-acf-unfold',
			]
		);

		$this->start_controls_tabs( 'tabs_button_styles' );

		$this->start_controls_tab(
			'tab_button_normal',
			[
				'label' => __( 'Normal', 'ae-pro' ),
			]
		);

		$this->add_control(
			'unfold_button_color',
			[
				'label'     => __( 'Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'global'    => [
					'default' => Global_Colors::COLOR_TEXT,
				],
				'selectors' => [
					'{{WRAPPER}} .ae-acf-unfold-link' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'unfold_button_bg_color',
			[
				'label'     => __( 'Background Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'global'    => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'selectors' => [
					'{{WRAPPER}} .ae-acf-unfold-link' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'unfold_icon_color',
			[
				'label'     => __( 'Icon Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ae-acf-unfold-button-icon i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .ae-acf-unfold-button-icon svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'icon_size',
			[
				'label'     => __( 'Icon Size', 'ae-pro' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 10,
						'max' => 300,
					],
				],
				'default'   => [
					'size' => 30,
				],
				'selectors' => [
					'{{WRAPPER}} .ae-acf-unfold-button-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .ae-acf-unfold-button-icon svg' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$helper->box_model_controls(
			$this,
			[
				'name'          => 'unfold_button_style',
				'label'         => __( 'Button', 'ae-pro' ),
				'border'        => true,
				'border-radius' => true,
				'margin'        => true,
				'padding'       => true,
				'box-shadow'    => true,
				'selector'      => '{{WRAPPER}} .ae-acf-unfold-link',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_button_hover',
			[
				'label' => __( 'Hover', 'ae-pro' ),
			]
		);

		$this->add_control(
			'unfold_button_color_hover',
			[
				'label'     => __( 'Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'global'    => [
					'default' => Global_Colors::COLOR_SECONDARY,
				],
				'selectors' => [
					'{{WRAPPER}} .ae-acf-unfold-link:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'unfold_button_bg_color_hover',
			[
				'label'     => __( 'Background Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'global'    => [
					'default' => Global_Colors::COLOR_PRIMARY,
				],
				'selectors' => [
					'{{WRAPPER}} .ae-acf-unfold-link:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'unfold_icon_color_hover',
			[
				'label'     => __( 'Icon Color', 'ae-pro' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .ae-acf-unfold-link:hover .ae-acf-unfold-button-icon i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .ae-acf-unfold-link:hover .ae-acf-unfold-button-icon svg' => 'fill: {{VALUE}};',
				],
			]
		);

		$helper->box_model_controls(
			$this,
			[
				'name'          => 'unfold_button_style_hover',
				'label'         => __( 'Button', 'ae-pro' ),
				'border'        => false,
				'border-radius' => true,
				'margin'        => false,
				'padding'       => false,
				'box-shadow'    => true,
				'selector'      => '{{WRAPPER}} .ae-acf-unfold-link:hover',
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
	}

	public function render() {

		$settings = $this->parent->get_settings();

		$field_args = [
			'field_name' => $settings['field_name'],
			'field_type' => $settings['field_type'],

		];

		if ( $settings['pods_option_name'] !== '' ) {
			$field_args['pods_option_name'] = $settings['pods_option_name'];
		}

		$placeholder = $this->get_instance_value( 'placeholder' );
		$unfold      = $this->get_instance_value( 'enable_unfold' );

		$text = PodsMaster::instance()->get_field_value( $field_args );

		if ( ( $text === '' || is_null( $text ) ) && ( $placeholder !== '' && ! is_null( $placeholder ) ) ) {
			$text   = $placeholder;
			$unfold = '';
		}

		$html_tag = $this->get_instance_value( 'html_tag' );

		$this->parent->add_render_attribute( 'title-class', 'class', 'ae-acf-content-wrapper' );
		$this->parent->add_render_attribute( 'wrapper-class', 'class', 'ae-acf-wrapper' );
		$this->parent->add_render_attribute( 'wrapper-class', 'class', 'ae-acf-unfold-' . $settings[ $this->get_control_id( 'enable_unfold' ) ] );

		// Process Content
		$text = $this->process_content( $text );
		if ( $text === '' ) {
			$this->parent->add_render_attribute( 'wrapper-class', 'class', 'ae-hide' );
		}
		?>
		<div <?php echo $this->parent->get_render_attribute_string( 'wrapper-class' ); ?>>
			<?php
			echo sprintf( '<%1$s itemprop="name" %2$s>%3$s</%1$s>', $html_tag, $this->parent->get_render_attribute_string( 'title-class' ), $text );

			if ( $unfold === 'yes' ) {
				$this->getFoldUnfoldButtonHtml();
			}

			?>
		</div>
		<?php
	}

	public function getFoldUnfoldButtonHtml() {

		$max_height      = $this->get_instance_value( 'unfold_max_height' );
		$unfold_text     = $this->get_instance_value( 'unfold_text' );
		$fold_text       = $this->get_instance_value( 'fold_text' );
		$animation_speed = $this->get_instance_value( 'unfold_animation_speed' );

		$this->parent->add_render_attribute( 'post-acf-unfold-class', 'class', [ 'ae-acf-unfold', 'fold' ] );
		$this->parent->add_render_attribute( 'post-acf-unfold-class', 'data-unfold-max-height', $max_height['size'] );
		$this->parent->add_render_attribute( 'post-acf-unfold-class', 'data-unfold-text', $unfold_text );
		$this->parent->add_render_attribute( 'post-acf-unfold-class', 'data-fold-text', $fold_text );
		$this->parent->add_render_attribute( 'post-acf-unfold-class', 'data-animation-speed', $animation_speed['size'] );

		?>

		<p <?php echo $this->parent->get_render_attribute_string( 'post-acf-unfold-class' ); ?>>
			<span class="ae-acf-unfold-link" href="#">
				<?php if ( $this->get_instance_value( 'unfold_icon' ) ) { ?>
				<span class="ae-acf-unfold-button-icon elementor-align-icon-<?php echo $this->get_instance_value( 'button_icon_position' ); ?>"><?php Icons_Manager::render_icon( $this->get_instance_value( 'unfold_icon' ) ); ?></span>
				<?php } ?>
				<span class="ae-acf-unfold-button-text"><?php echo $this->get_instance_value( 'unfold_text' ); ?></span>
			</span>
		</p>
		<?php
	}

}
