<?php

global $post, $form;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
$data_types = array(
    'post' => __( 'Post', 'acf-frontend-form-element' ),
    'user' => __( 'User', 'acf-frontend-form-element' ),
    'term' => __( 'Term', 'acf-frontend-form-element' ),
    'options' => __( 'Site Options', 'acf-frontend-form-element' ),
);
if ( class_exists( 'woocommerce' ) ){
    $data_types['product'] = __( 'Product', 'acf-frontend-form-element' );
}

$form_fields = array();

$args = array(
    'post_type' => 'acf-field',
    'posts_per_page' => '-1',
    'post_parent' => $post->ID,
    'fields' => 'ids',
    'orderby' => 'menu_order', 
    'order' => 'ASC'
);

$fields_query = get_posts( $args );

if ( $fields_query ) {
    foreach( $fields_query as $field ){
        $form_fields[] = acf_get_field( $field );
    }
}
// get fields
$view = array(
    'fields'	=> $form_fields,
    'parent'	=> 0
);

ob_start();
acf_get_view('field-group-fields', $view);
$field_objects = ob_get_contents();
ob_end_clean();	

return array(	
    array(
        'key' => 'custom_fields_wrapper',
        'field_label_hide' => 1,
        'type' => 'message',
        'instructions' => '',
        'new_lines' => '',
        'message' => '<div class="inside">'.$field_objects.'</div>',
        'php_code' => '1',
        'wrapper' => array(
            'width' => '',
            'class' =>'',
            'id' => 'acf-field-group-fields'
        )
    ),	
    array(
        'key' => 'custom_fields_save',
        'label' => __( 'Save Custom Fields to...', 'acf-frontend-form-element' ),
        'field_label_hide' => 0,
        'type' => 'select',
        'instructions' => '',
        'required' => 0,
        'choices' => $data_types,
        'allow_null' => 0,
        'multiple' => 0,
        'ui' => 0,
        'return_format' => 'value',
        'ajax' => 0,
        'placeholder' => '',
        'wrapper' => array(
            'width' => '75',
            'class' =>'',
            'id' => ''
        )
    ),
    array(
        'key' => 'no_kses',
        'label' => __( 'Allow Unfiltered HTML', 'acf-frontend-form-element' ),
        'field_label_hide' => 0,
        'type' => 'true_false',
        'instructions' => '',
        'required' => 0,
        'ui' => 1,
        'wrapper' => array(
            'width' => '50',
            'class' =>'',
            'id' => ''
        )
    ),
);    