<?php

namespace Aepro\Modules\DynamicRules\Rules;


use Aepro\Base\RuleBase;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Acf_Relationship extends RuleBase
{


    public function get_group()
    {
        return 'acf';
    }

    public function get_name()
    {
        return 'acf_relationship';
    }


    public function get_title()
    {
        return __('ACF Relationship', 'ae-pro');
    }

    public function get_name_control()
    {
        return [
            'label'         => 'ACF Name',
            'type'             => Controls_Manager::TEXT,
            'default'         => '',
            'placeholder'    => __('Name', 'ae-pro'),
        ];
    }

    public function get_value_control()
    {
        return
            [
                'label' => __('Value', 'ae-pro'),
                'type'  => 'aep-query',
                'placeholder' => __('', 'ae-pro'),
                'label_block'     => true,
                'query_type' => 'post',
                'multiple' => true,
            ];
    }

    protected function get_rule_operators(){
		$rule_operators = array();

        $rule_operators = [
            'equal' => __('Is Equal', 'ae-pro'),
            'not_equal' => __('Is Not Equal', 'ae-pro'),
            'contains' => __('Contains', 'ae-pro'),
            'not_contains' => __('Does Not Contains', 'ae-pro'),
            'empty' => __('Is Empty', 'ae-pro'),
            'not_empty' => __('Is Not Empty', 'ae-pro'),
        ];

        return $rule_operators;
	}

    public function check($name, $operator, $value)
    {
        global $post;
        $field_value = get_field($name);
        return $this->compare($field_value, $value, $operator);
    }
}
